//
// C++ Implementation: kpgcastsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcastsfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgcastsfolder.h"
#include "../DbObjects/kpgconnection.h"

KPGCastsFolderPropPage::KPGCastsFolderPropPage(QWidget *pParent, KPGCastsFolder *pCastsFolder)
 : KPGPropertyPage(pParent, "KPGCastsFolderPropPage")
{
	m_pCastsFolder = pCastsFolder;
	displayProperties();
}


KPGCastsFolderPropPage::~KPGCastsFolderPropPage()
{
}

void KPGCastsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Casts &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Context"));
  	pHeader->setLabel(nCol++, i18n("Source type"));
	pHeader->setLabel(nCol++, i18n("Target type"));
  	pHeader->setLabel(nCol++, i18n("Function"));
	pHeader->setLabel(nCol++, i18n("Namespace"));
	
	QTextCodec * pTextCodec = m_pCastsFolder->connection()->textCodec();
	
	KPGUtil::fillPropertiesTable(m_pCastsFolder->resultCasts(), m_pTableItems, pTextCodec);
}

