//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablespacesfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgserver.h"
#include "kpgtablespace.h"


KPGTablespacesFolder::KPGTablespacesFolder(KPGServer *parent)
	: KPGItemsFolder(parent, i18n("Tablespaces"), m_pIconFolderBlueClosed, m_pIconFolderBlueOpen)
{
}


KPGTablespacesFolder::~KPGTablespacesFolder()
{
}

void KPGTablespacesFolder::refresh() throw(const KPGSqlException &)
{
	// delete all child items (databases)
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	// obtain list of tablespaces
	QString strQuery("SELECT ts.oid, ts.spcname, sh.usename AS owner, ts.spclocation, ts.spcacl ");
	
	// Is it 8.1 or newer ?
	KPGServer *pServer = static_cast <KPGServer *> (parent());
	m_bVersion81_OrNewer = false;
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		m_bVersion81_OrNewer = true;
	}
	
	if(m_bVersion81_OrNewer) 
	{
		strQuery.append(", pg_catalog.pg_size_pretty(pg_catalog.pg_tablespace_size(ts.oid)) AS size_pretty, pg_catalog.pg_tablespace_size(ts.oid) AS tablespace_size ");
		m_bVersion81_OrNewer = true;
	}
	
	strQuery.append("FROM pg_catalog.pg_tablespace ts ");
    strQuery.append("LEFT JOIN pg_catalog.pg_user sh ON ts.spcowner=sh.usesysid  ");
			
    KPGConnection *pConnection = connection();
	try
	{
        m_pqxxResultTablespaces = pConnection->runQuery(strQuery);
	
		KPGTablespace *pTablespace = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultTablespaces.size(); ++i)
		{
			pqxx::oid oid;
			m_pqxxResultTablespaces[i][0].to(oid);
			
			if(pTablespace == 0)
				pTablespace = new KPGTablespace(this, m_pqxxResultTablespaces[i]["spcname"].c_str(), oid);
			else
				pTablespace = new KPGTablespace(this, pTablespace, m_pqxxResultTablespaces[i]["spcname"].c_str(), oid);
					
				pTablespace->setProperties(m_pqxxResultTablespaces[i], m_bVersion81_OrNewer);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
	} 
}
