//
// C++ Implementation: kpgconversionsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgconversionsfolder.h"

#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgconversion.h"
#include "kpgschema.h"
#include "../kpgutil.h"

KPGConversionsFolder::KPGConversionsFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
	: KPGItemsFolder(parent, i18n("Conversions"), m_pIconFolderGreyClosed, m_pIconFolderGreyOpen)
{
	m_oidNameSpace = oidNameSpace;
}


KPGConversionsFolder::~KPGConversionsFolder()
{
}

void KPGConversionsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items 
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
    // obtain list of conversions
    QString strQuery("SELECT co.oid, co.conname, co.condefault, pg_encoding_to_char(conforencoding) as fromencoding, pg_encoding_to_char(contoencoding) as toencoding, \
    conproc::oid AS conprocoid, pr.proname, pg_get_userbyid(conowner) as owner ");
		
	strQuery.append("FROM pg_catalog.pg_conversion co ");
	strQuery.append("JOIN pg_catalog.pg_proc pr ON pr.oid=conproc ");
	strQuery.append("JOIN pg_catalog.pg_namespace na ON na.oid=pr.pronamespace ");
	strQuery.append("WHERE connamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY conname");
			
    KPGConnection *pConnection = connection();
    try
    {
        m_pqxxResultConversions = pConnection->runQuery(strQuery);
    
        KPGConversion *pConversion = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultConversions.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultConversions[i][0].to(oid);
            
            if(pConversion == 0)
                pConversion = new KPGConversion(this, m_pqxxResultConversions[i]["conname"].c_str(), oid);
            else
                pConversion = new KPGConversion(this, pConversion, m_pqxxResultConversions[i]["conname"].c_str(), oid);
                
            pConversion->setProperties(m_pqxxResultConversions[i]); 
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
    } 
}
