/***************************************************************************
                           kxetextviewsettings.h
                           --------------------
    begin                : Tue Dec 23 2003
    copyright            : (C) 2003-2005 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXETEXTVIEWSETTINGS_H
#define KXETEXTVIEWSETTINGS_H

#include <qcolor.h>
#include <qfont.h>

#include "../kpgsettings.h"


class KXETextViewSettingsPage;

/**
 * This class represents the group of configuration settings for
 * the text view.
 *
 * @author The KXMLEditor Team
 */
class KXETextViewSettings : public KPGSettings
{
public:

	KXETextViewSettings( QObject * pParent = 0, const char * pszName = 0 );

	// The following functions can be used to access this object's settings.
	const QColor & colorDfltText() const { return m_colorDfltText; }
	const QColor & colorElemNames() const { return  m_colorElemNames; }
	const QColor & colorAttrNames() const { return  m_colorAttrNames; }
	const QColor & colorAttrValues() const { return  m_colorAttrValues; }
	const QColor & colorSyntaxChars() const { return  m_colorSyntaxChars; }
	const QColor & colorComments() const { return  m_colorComments; }
	const QColor & colorErrors() const { return  m_colorErrors; }
    int indentSteps() const { return m_iIndentSteps; }
	bool isWrapOn() const { return m_bWrapOn; }
    const QFont & font() const { return  m_Font; }   
    
	/**
	 * Derived from @ref KXESettings
	 */
	virtual QString dialogPageName() const;
		
    /**
	 * Derived from @ref KXESettings
	 */
	virtual QString dialogPageHeader() const;
		
    /**
	 * Derived from @ref KXESettings
	 */
	virtual QString dialogPageIcon() const;
		
    /**
	 * Derived from @ref KXESettings
	 */
	virtual QWidget * dialogPage( QFrame * pParent );

protected:

	/**
	 * Derived from @ref KXESettings
	 */
	virtual void write( KConfig * ) const;
		
    /**
	 * Derived from @ref KXESettings
	 */
	virtual void read( const KConfig * );
    
	/**
	 * Derived from @ref KXESettings
	 */
	virtual void setFromPage();
		
    /**
	 * Derived from @ref KXESettings
	 */
	virtual void updatePage() const;

	// the settings itself
	QColor m_colorDfltText;
	QColor m_colorElemNames;
	QColor m_colorAttrNames;
	QColor m_colorAttrValues;
	QColor m_colorSyntaxChars;
	QColor m_colorComments;
	QColor m_colorErrors;
        
        
    int m_iIndentSteps;
	bool m_bWrapOn;

    QFont m_Font;

	/**
	 * the corresponding configuration dialog page
	 * It is created on demand by @ref dialogPage.
	 */
	KXETextViewSettingsPage * m_pDialogPage;
};

#endif
