//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDUMPDATABASEWIZARD_H
#define KPGDUMPDATABASEWIZARD_H

#include "kpgdumpdatabasewizardbase.h"

#include <kparts/partmanager.h>
#include <qguardedptr.h>

#include "../kpgdcoptalkthread.h"

class KonsoleViewWidget;
class DCOPClient;

/**
DUMP database wizard

@author Lumir Vanek
*/

class KPGDumpDatabaseWizard : public KPGDumpDatabaseWizardBase
{
Q_OBJECT
public:
    KPGDumpDatabaseWizard(QWidget *parent, const char *name, DCOPClient *, const QString &, const QString &, const QString &, const QString &);
    ~KPGDumpDatabaseWizard();
    
    KParts::PartManager * partManager() const { return m_pPartManager; }

protected:
    KParts::PartManager *m_pPartManager;
    DCOPClient *m_pDcopClient;
    QGuardedPtr<KonsoleViewWidget> m_pConsoleWidget;
    KPGDcopTalkThread m_dcopTalkThread;
    
protected slots:
    virtual void slotOutputFileChanged(const QString &);
    virtual void slotFormatChanged(int);
    virtual void slotOnlyDataToggled(bool);
    virtual void slotOnlySchemaToggled(bool);
    
protected:
    virtual void showPage(QWidget *);
    const QString getCommand() const;
    
    QString m_strDatabase;
    QString m_strHostname;
    QString m_strPort;
    QString m_strUsername;
};

#endif
