/***************************************************************************
                          kpgtablecolumnproppage  -  description
                             -------------------
    begin                : So no 7 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgtablecolumnproppage.h"

#include <qtable.h>  

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "../kpglinklabel.h"
#include "../kpgutil.h"
#include "../DbObjects/kpgtablecolumn.h"


KPGTableColumnPropPage::KPGTableColumnPropPage(QWidget *parent, KPGTableColumn * pTableColumn)
 : KPGTableColumnPropPageBase(parent, "KPGTableColumnPropPage")
{
	m_pTableColumn = pTableColumn;
	displayProperties();
}


KPGTableColumnPropPage::~KPGTableColumnPropPage()
{
}

void KPGTableColumnPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pTableColumn->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("The column name"));
	
	//--- Type Name
	m_pTableProperties->setText(iRow, 0, i18n("Type"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Type" );
	pLabel->setValues(m_pTableColumn->oidType(), m_pTableColumn->typName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("The column type"));
	
	//--- Created as
	m_pTableProperties->setText(iRow, 0, i18n("Created as"));
	m_pTableProperties->setText(iRow, 1, m_pTableColumn->createdAs());
	m_pTableProperties->setText(iRow++, 2, i18n("The column type specified in CREATE TABLE statement"));
		
	//--- Type length
	m_pTableProperties->setText(iRow, 0, i18n("Type length"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTableColumn->attLen()));
	m_pTableProperties->setText(iRow++, 2, i18n("For a fixed-size type, typlen is the number of bytes in the internal representation of the type. But for a variable-length type, typlen is negative. -1 indicates a \"varlena\" type (one that has a length word), -2 indicates a null-terminated C string."));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pTableColumn->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the column"));
	
	//--- Statistics target
	m_pTableProperties->setText(iRow, 0, i18n("Statistics target"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTableColumn->statTarget()));
	m_pTableProperties->setText(iRow++, 2, i18n("Controls the level of detail of statistics accumulated for this column by ANALYZE. A zero value indicates that no statistics should be collected. A negative value says to use the system default statistics target. The exact meaning of positive values is data type-dependent. For scalar data types, attstattarget is both the target number of \"most common values\" to collect, and the target number of histogram bins to create."));
	
	
	//--- Attribute number
	m_pTableProperties->setText(iRow, 0, i18n("Attribute number"));
  m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTableColumn->attNum()));
	m_pTableProperties->setText(iRow++, 2, i18n("The number of the column. Ordinary columns are numbered from 1 up. System columns, such as oid, have (arbitrary) negative numbers."));
	
	//--- Number of dimensions
	m_pTableProperties->setText(iRow, 0, i18n("Number of dimensions"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTableColumn->attNdims()));
	m_pTableProperties->setText(iRow++, 2, i18n("Number of dimensions, if the column is an array type; otherwise 0. (Presently, the number of dimensions of an array is not enforced, so any nonzero value effectively means \"it's an array\".) "));
	
	//--- Type mode
	m_pTableProperties->setText(iRow, 0, i18n("Type mode"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTableColumn->attTypmod()));
	m_pTableProperties->setText(iRow++, 2, i18n("Records type-specific data supplied at type creation time (for example, the maximum length of a varchar column). It is passed to \
type-specific input functions and length coercion functions. The value will generally be -1 for types that do not need atttypmod. "));
	
	//--- By Value
	m_pTableProperties->setText(iRow, 0, i18n("By value"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pTableColumn->byValue() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Determines whether internal routines pass a value of this type by value or by reference. It had better be false if typlen is not 1, 2, or 4 (or 8 on machines where Date is 8 bytes). Variable-length types are always passed by reference. Note that typbyval can be false even if the length would allow pass-by-value; this is currently true for type float4, for example."));
	
	//--- Not null
	m_pTableProperties->setText(iRow, 0, i18n("Not null"));
  m_pTableProperties->setPixmap(iRow, 1, m_pTableColumn->isNotNull() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("This represents a not-null constraint. It is possible to change this column to enable or disable the constraint."));
	
	//--- Not null
	m_pTableProperties->setText(iRow, 0, i18n("Has default"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pTableColumn->hasDefault() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("This column has a default value, in which case there will be a \
	corresponding entry in the pg_attrdef catalog that actually defines the value."));
	
	//--- Is dropped
	m_pTableProperties->setText(iRow, 0, i18n("Is dropped"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pTableColumn->isDropped() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("This column has been dropped and is no longer \
	valid. A dropped column is still physically present in the table, but is ignored by \
	the parser and so cannot be accessed via SQL."));
	
	//--- Is local
	m_pTableProperties->setText(iRow, 0, i18n("Is local"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pTableColumn->isLocal() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("This column is defined locally in the relation. Note that a column may be locally defined and inherited simultaneously. "));
  
	//--- Storage
	m_pTableProperties->setText(iRow, 0, i18n("Storage"));
	m_pTableProperties->setText(iRow, 1, m_pTableColumn->storage());
	m_pTableProperties->setText(iRow++, 2, i18n("Column storage. For TOAST-able data types, this can be altered after column creation to control storage policy."));
	
	//--- Type mode
	m_pTableProperties->setText(iRow, 0, i18n("Inherited count"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTableColumn->inhCount()));
	m_pTableProperties->setText(iRow++, 2, i18n("The number of direct ancestors this column has. A column with a nonzero number of ancestors cannot be dropped nor renamed. "));
	
	//--- Default value
	m_pTableProperties->setText(iRow, 0, i18n("Default value"));
  	m_pTableProperties->setText(iRow, 1, m_pTableColumn->defaultValue());
	m_pTableProperties->setText(iRow++, 2, i18n("A human-readable representation of the default value"));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
  	m_pTableProperties->setText(iRow, 1, m_pTableColumn->nspName());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the datatype namespace"));

			
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

void KPGTableColumnPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGTableColumnPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgtablecolumnproppage.moc"
