//
// C++ Interface: kpgschemaproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGSCHEMAPROPPAGE_H
#define KPGSCHEMAPROPPAGE_H

#include "kpgschemaproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"

class KPGSchema;

/**
Schema properties

@author Lumir Vanek
*/

class KPGSchemaPropPage : public KPGSchemaPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGSchemaPropPage(QWidget *parent, KPGSchema *);
    ~KPGSchemaPropPage();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult();
	
    void setACL(const QString &);
    
    // Display properties of underlying database object
    void displayProperties();
    
protected:

    void displayAggregates();
	void displayConversions();
	void displayDomains();
	void displayFunctions();
	void displayOperators();
	void displayOperatorClasses();
	void displaySequences();
	void displayTables();
	void displayTypes();
	void displayViews();
    
protected:

    KPGSchema *m_pSchema;
    KPGAclItemList m_listOfAclItems;
    
    bool m_bPageTablesDisplaied;
  	bool m_bPageViewsDisplaied;
	bool m_bPageSequencesDisplaied;
  	bool m_bPageFunctionsDisplaied;
	bool m_bPageOperatorsDisplaied;
	bool m_bPageOperatorClassesDisplaied;
	bool m_bPageAggregatesDisplaied;
	bool m_bPageDomainsDisplaied;
	bool m_bPageTypesDisplaied;	
	bool m_bPageConversionsDisplaied;
    
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	virtual void slotCurrentTabChanged(QWidget *);
    virtual void slotTableAggregatesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableConversionsDblClicked(int, int, int, const QPoint &);
    virtual void slotTableDomainsDblClicked(int, int, int, const QPoint &);
    virtual void slotTableFunctionsDblClicked(int, int, int, const QPoint &);
	virtual void slotTableOpClassesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableOperatorsDblClicked(int, int, int, const QPoint &);
    virtual void slotTableSequencesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableTablesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableTypesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableViewsDblClicked(int, int, int, const QPoint &);
			            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
    virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();
    
signals:
	void sigSearchObject(const pqxx::oid);
	void sigRunWizard(const QString &); 
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
