//
// C++ Implementation: kpgschemaproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgschemaproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h> 

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <ktextedit.h>
#include <klocale.h>
#include <kcursor.h>
#include <kdebug.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../kpgutil.h"

KPGSchemaPropPage::KPGSchemaPropPage(QWidget *parent, KPGSchema * pSchema)
 : KPGSchemaPropPageBase(parent, "KPGSchemaPropPage")
{
  	m_pSchema = pSchema;

	m_pTabWidget->setTabIconSet(tabAggregates, QIconSet(*KPGTreeItem::m_pIconAggregate)); 
	m_pTabWidget->setTabIconSet(tabConversions, QIconSet(*KPGTreeItem::m_pIconConversion));
	m_pTabWidget->setTabIconSet(tabDomains, QIconSet(*KPGTreeItem::m_pIconDomain));
	m_pTabWidget->setTabIconSet(tabFunctions, QIconSet(*KPGTreeItem::m_pIconFunctionC));
	m_pTabWidget->setTabIconSet(tabOperatorClasses, QIconSet(*KPGTreeItem::m_pIconOperatorClass));
	m_pTabWidget->setTabIconSet(tabOperators, QIconSet(*KPGTreeItem::m_pIconOperator));
	m_pTabWidget->setTabIconSet(tabSequences, QIconSet(*KPGTreeItem::m_pIconSequence));
	m_pTabWidget->setTabIconSet(tabTables, QIconSet(*KPGTreeItem::m_pIconTable));
	m_pTabWidget->setTabIconSet(tabTypes, QIconSet(*KPGTreeItem::m_pIconTypeStandalone));
	m_pTabWidget->setTabIconSet(tabViews, QIconSet(*KPGTreeItem::m_pIconView));
  	m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group.png"))));
  	
  	m_bPageAggregatesDisplaied = false;
	m_bPageConversionsDisplaied = false;
	m_bPageDomainsDisplaied = false;
	m_bPageFunctionsDisplaied = false;
	m_bPageOperatorClassesDisplaied = false;
	m_bPageOperatorsDisplaied = false;
	m_bPageSequencesDisplaied = false;
    m_bPageTablesDisplaied = false;
    m_bPageTypesDisplaied = false;
	m_bPageViewsDisplaied = false;
	
	displayProperties();
}


KPGSchemaPropPage::~KPGSchemaPropPage()
{
}

// Display properties of underlying database object
void KPGSchemaPropPage::displayProperties()
{
	//--- Header 
	// field names
  	QHeader* hHeader = m_pTableProperties->horizontalHeader();

  	hHeader->setLabel(0, i18n("Name"));
	hHeader->setLabel(1, i18n("Value"));
	hHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSchema->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pSchema->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the schema"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pSchema->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the schema"));
	
	//--- ACL
	setACL(m_pSchema->acl());
	
	//--- Can Create
	m_pTableProperties->setText(iRow, 0, i18n("Can Create"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pSchema->canCreate() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Does current user have CREATE privilege for schema ? "));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pSchema->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the schema"));
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}


void KPGSchemaPropPage::displayAggregates()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultAggregates(), m_pTableAggregates);
	m_bPageAggregatesDisplaied = true;
}

void KPGSchemaPropPage::displayConversions()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultConversions(), m_pTableConversions);
	m_bPageConversionsDisplaied = true;
}

void KPGSchemaPropPage::displayDomains()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultDomains(), m_pTableDomains);
	m_bPageDomainsDisplaied = true;
}

void KPGSchemaPropPage::displayFunctions()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultFunctions(), m_pTableFunctions, true, 13);
	m_bPageFunctionsDisplaied = true;
}

void KPGSchemaPropPage::displayOperatorClasses()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultOperatorClasses(), m_pTableOperatorClasses, false);
	m_bPageOperatorClassesDisplaied = true;
}

void KPGSchemaPropPage::displayOperators()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultOperators(), m_pTableOperators);
	m_bPageOperatorsDisplaied = true;
}

void KPGSchemaPropPage::displaySequences()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultSequences(), m_pTableSequences);
	m_bPageSequencesDisplaied = true;
}

void KPGSchemaPropPage::displayTables()
{
	// Get pointer to server for version info
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (m_pSchema->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
	
	bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	int iColumns = 9;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
       iColumns += 1;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
		iColumns += 2;
	}
				
	// fill properties table with result data
	KPGUtil::fillPropertiesTable(m_pSchema->resultTables(), m_pTableTables, true, iColumns);
	m_bPageTablesDisplaied = true;
}

void KPGSchemaPropPage::displayTypes()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultTypes(), m_pTableTypes);
	m_bPageTypesDisplaied = true;
}

void KPGSchemaPropPage::displayViews()
{
	KPGUtil::fillPropertiesTable(m_pSchema->resultViews(), m_pTableViews);
	m_bPageViewsDisplaied = true;
}

void KPGSchemaPropPage::slotTablePropDblClicked(int iRow, int iCol, int, const QPoint &)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
				
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotCurrentTabChanged(QWidget *pPage)
{
	setCursor(KCursor::waitCursor());	
		
	if((pPage == tabAggregates) && (!m_bPageAggregatesDisplaied))
		displayAggregates();	
	else if((pPage == tabConversions) && (!m_bPageConversionsDisplaied))
		displayConversions();
	else if((pPage == tabDomains) && (!m_bPageDomainsDisplaied))
		displayDomains();
	else if((pPage == tabFunctions) && (!m_bPageFunctionsDisplaied))
		displayFunctions();
	else if((pPage == tabOperatorClasses) && (!m_bPageOperatorClassesDisplaied))
	  displayOperatorClasses();
	else if((pPage == tabOperators) && (!m_bPageOperatorsDisplaied))
		displayOperators();
	else if((pPage == tabSequences) && (!m_bPageSequencesDisplaied))
	  displaySequences();
	else if((pPage == tabTables) && (!m_bPageTablesDisplaied))
		displayTables();	
	else if((pPage == tabTypes) && (!m_bPageTypesDisplaied))
		displayTypes();
	else if((pPage == tabViews) && (!m_bPageViewsDisplaied))
		displayViews();
				
	setCursor(KCursor::arrowCursor());
}

void KPGSchemaPropPage::slotTableAggregatesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableAggregates->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableConversionsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableConversions->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableDomainsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableDomains->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableFunctionsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableFunctions->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableOpClassesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableOperatorClasses->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableOperatorsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableOperators->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableSequencesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableSequences->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableTablesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableTables->cellWidget(iRow, iCol);
		if(w == 0)
			return;
					
		KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
		pqxx::oid _oid = pLabel->oid();
			
		if(_oid != 0)
			emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableTypesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableTypes->cellWidget(iRow, iCol);
		if(w == 0)
			return;
					
		KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
		pqxx::oid _oid = pLabel->oid();
			
		if(_oid != 0)
			emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::slotTableViewsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableViews->cellWidget(iRow, iCol);
		if(w == 0)
			return;
					
		KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
		pqxx::oid _oid = pLabel->oid();
			
		if(_oid != 0)
			emit sigSearchObject(_oid);
}

void KPGSchemaPropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
		strAclItem.truncate(0); // clear ACL string
		}
		else
		{
		strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canCreate() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(3, UserIcon((*it).canUse() ? "box_checked.png" : "box_clear.png"));
			
		if((*it).canPassGrantToOther())
		{  
		pItem->setPixmap(4, UserIcon((*it).canGrantCreate() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(5, UserIcon((*it).canGrantUse() ? "box_checked.png" : "box_clear.png")); 
		}
	} 
}

void KPGSchemaPropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
  // Find KPGAclItem using pItem value
  KPGAclItemList::iterator it;
  for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
  {   
    if(pItem == (*it).getListViewItem())
    {
      // found ...
      
      switch(iColumn)
      {
        case 0:
        case 1: // do nothing on first 2 columns
            break;
        
        case 2:
            pItem->setPixmap(2, UserIcon((*it).toggleCreate() ? "box_checked.png" : "box_clear.png"));
            break;
       
        case 3:
            pItem->setPixmap(3, UserIcon((*it).toggleUse() ? "box_checked.png" : "box_clear.png"));
            break;
        
        case 4:
            if((*it).canPassGrantToOther())
              pItem->setPixmap(4, UserIcon((*it).toggleGrantCreate() ? "box_checked.png" : "box_clear.png"));
            
            break;
        
        case 5:
            if((*it).canPassGrantToOther())
              pItem->setPixmap(5, UserIcon((*it).toggleGrantUse() ? "box_checked.png" : "box_clear.png"));
            
            break;
            
        default:
            kdError() << k_funcinfo << " Unexpected column !" << endl;
            break;      
      }
    
      m_pPushButtonUpdateACL->setEnabled(true);
      return;
    }
  }
}

void KPGSchemaPropPage::slotUpdateACL()
{
  QString strSQL;
  
  // Traverse all items and get their SQL's
  KPGAclItemList::iterator it;
  for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
  {   
    strSQL.append((*it).getSQL("SCHEMA " + KPGUtil::quotedName(m_pSchema->text(0))));
  }
  
  if(!strSQL.isEmpty())
    emit sigRunWizard(strSQL);
}

// Consumes request for context menu for property table
void KPGSchemaPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

// Return Result table for clipboard actions and export. 
QTable* KPGSchemaPropPage::tableResult() 
{ 
	switch(m_pTabWidget->currentPageIndex())
	{
		case 0: return m_pTableProperties; 
				break;
				
		case 1: return 0; 
				break;
				
		case 2: return m_pTableAggregates; 
				break;
				
		case 3: return m_pTableConversions; 
				break;
				
		case 4: return m_pTableDomains; 
				break;
				
		case 5: return m_pTableFunctions; 
				break;
								
		case 6: return m_pTableOperatorClasses; 
				break;	
						
		case 7: return m_pTableOperators; 
				break;	
				
		case 8: return m_pTableSequences; 
				break;	
				
		case 9: return m_pTableTables; 
				break;	
				
		case 10: return m_pTableTypes; 
				break;	
				
		case 11: return m_pTableViews; 
				break;	
	}
	
	return 0;
}

#include "kpgschemaproppage.moc"
