//
// C++ Interface: kpgoperatorproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGOPERATORPROPPAGE_H
#define KPGOPERATORPROPPAGE_H

#include "kpgoperatorproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGOperator;

/**
  * Operator properties
  *
  * @author Lumir Vanek
  */
class KPGOperatorPropPage : public KPGOperatorPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGOperatorPropPage(QWidget *, KPGOperator *);
    ~KPGOperatorPropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGOperator * m_pOperator;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	            
signals:
	void sigSearchObject(const pqxx::oid);
	
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);	
};

#endif
