//
// C++ Interface: kpggroupproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGGROUPPROPPAGE_H
#define KPGGROUPPROPPAGE_H

#include "kpggroupproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGGroup;

/**
  * Group properties
  *
  * @author Lumir Vanek
  */
class KPGGroupPropPage : public KPGGroupPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGGroupPropPage(QWidget *parent, KPGGroup *);
    ~KPGGroupPropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGGroup *m_pGroup;
	
protected slots:
		
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
    
signals:
  	void sigSearchObject(const pqxx::oid);
  	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
