//
// C++ Interface: kpgforeignkeyconstrproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGFOREIGNKEYCONSTRPROPPAGE_H
#define KPGFOREIGNKEYCONSTRPROPPAGE_H

#include "kpgforeignkeyconstrproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGForeignKeyConstr;


/**
  * Foreign Key Constraint properties
  *
  * @author Lumir Vanek
  */
class KPGForeignKeyConstrPropPage : public KPGForeignKeyConstrPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGForeignKeyConstrPropPage(QWidget *, KPGForeignKeyConstr *);
    ~KPGForeignKeyConstrPropPage();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:
	
	// Display properties of underlying database object
	virtual void displayProperties();
	
protected:
	
	KPGForeignKeyConstr * m_pForeignKeyConstr;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
    	
signals:
	void sigSearchObject(const pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
