/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#ifndef _PACKETS_H_
#define _PACKETS_H_

#include "terrain.h"
#include "../config.h"

#if SIZEOF_CHAR == 1
typedef unsigned char ubyte_pkt;
#else
#error What the hell?  A char is more than one byte?  Email the author!
#endif

#if SIZEOF_SHORT_INT == 2
typedef unsigned short int uint16_pkt;
#else
#error Oops, there seems to be a problem.  You need two-byte short ints!  Email author.
#endif

#if SIZEOF_INT == 4
typedef unsigned int uint32_pkt;
#else
#error Gah, what a pain.  You need 4 byte integers.  Please email the author and help him port to this hardware!
#endif

/* structure definitions for the various packet types */

#define PROTOCOL_VERSION 10 /* increment this every time one of these structures changes! */

struct SetGameMode_pkt
{
    ubyte_pkt type[2];
    ubyte_pkt gamemode;
};

struct PlayerID_pkt
{
    ubyte_pkt type[2];
    uint32_pkt id;
};

struct SetName_pkt
{
    ubyte_pkt type[2];
    uint32_pkt id;
    ubyte_pkt name[256];
};

struct NewPlayer_pkt
{
    ubyte_pkt type[2];
    uint32_pkt id;
	ubyte_pkt color;
    ubyte_pkt ready;
    ubyte_pkt name[256];
};

struct UpdateTerrain_pkt
{
    ubyte_pkt type[2];
    uint16_pkt startpos;
	uint16_pkt length;
    uint16_pkt ter[MAXTERRAINSIZE];    
};

struct Message_pkt
{
    ubyte_pkt type[2];
    ubyte_pkt message[256];
};

struct ColoredMessage_pkt
{
    ubyte_pkt type[2];
	ubyte_pkt color;
    ubyte_pkt message[256];
};

struct SetTank_pkt
{
    ubyte_pkt type[2];
    uint32_pkt id;
    uint32_pkt x;
    uint32_pkt y;
    uint16_pkt a;
    uint16_pkt v;
	uint16_pkt armor;
};

struct FireCmd_pkt
{
	ubyte_pkt type[2];
    uint32_pkt id;
	uint32_pkt gen;
    uint16_pkt a;
    uint16_pkt v;
    ubyte_pkt shottype[256];
};

struct ChangeReady_pkt
{
    ubyte_pkt type[2];
    uint32_pkt id;
    ubyte_pkt r;
};

struct BuyWeapon_pkt
{
	ubyte_pkt type[2];
	uint16_pkt count;
	ubyte_pkt weapontype[256];
};

struct TerrainInfo_pkt 
{
	ubyte_pkt type[2];
	uint16_pkt sizex;
	uint16_pkt sizey;
	uint32_pkt lerp_tweak;
	uint32_pkt grav;
};

struct Score_pkt 
{
	ubyte_pkt type[2];
	uint32_pkt id;
	uint32_pkt roundScore;
	uint32_pkt score;
};    

int pktPack(ubyte_pkt *buf, char *fmt, ...);
int pktUnpack(ubyte_pkt *buf, char *fmt, ...);

int pktPackSetGameMode(ubyte_pkt *buf, struct SetGameMode_pkt *pkt);
int pktUnpackSetGameMode(struct SetGameMode_pkt *pkt, ubyte_pkt *buf);

int pktPackPlayerID(ubyte_pkt* buf, struct PlayerID_pkt *pkt);
int pktUnpackPlayerID(struct PlayerID_pkt *pkt, ubyte_pkt* buf);

int pktPackSetName(ubyte_pkt* buf, struct SetName_pkt *pkt);
int pktUnpackSetName(struct SetName_pkt *pkt, ubyte_pkt* buf);

int pktPackNewPlayer(ubyte_pkt* buf, struct NewPlayer_pkt *pkt);
int pktUnpackNewPlayer(struct NewPlayer_pkt *pkt, ubyte_pkt* buf);

int pktPackMessage(ubyte_pkt* buf, struct Message_pkt *pkt);
int pktUnpackMessage(struct Message_pkt *pkt, ubyte_pkt *buf);

int pktPackSetTank(ubyte_pkt* buf, struct SetTank_pkt *pkt);
int pktUnpackSetTank(struct SetTank_pkt *pkt, ubyte_pkt* buf) ;

int pktPackFireCmd(ubyte_pkt* buf, struct FireCmd_pkt *pkt);
int pktUnpackFireCmd(struct FireCmd_pkt *pkt, ubyte_pkt* buf);

int pktPackChangeReady(ubyte_pkt* buf, struct ChangeReady_pkt *pkt);
int pktUnpackChangeReady(struct ChangeReady_pkt *pkt, ubyte_pkt* buf);

int pktPackBuyWeapon(ubyte_pkt* buf, struct BuyWeapon_pkt *pkt);
int pktUnpackBuyWeapon(struct BuyWeapon_pkt *pkt, ubyte_pkt* buf);

int pktPackUpdateTerrain(ubyte_pkt* buf, struct UpdateTerrain_pkt *pkt);
int pktUnpackUpdateTerrain(struct UpdateTerrain_pkt *pkt, ubyte_pkt *buf);

int pktPackTerrainInfo(ubyte_pkt* buf, struct TerrainInfo_pkt *pkt);
int pktUnpackTerrainInfo(struct TerrainInfo_pkt *pkt, ubyte_pkt* buf);

int pktPackColoredMessage(ubyte_pkt* buf, struct ColoredMessage_pkt *pkt);
int pktUnpackColoredMessage(struct ColoredMessage_pkt *pkt, ubyte_pkt* buf);

int pktPackWindSpeed(ubyte_pkt* buf, struct PlayerID_pkt *pkt);
int pktUnpackWindSpeed(struct PlayerID_pkt *pkt, ubyte_pkt* buf);

int pktPackScore(ubyte_pkt* buf, struct Score_pkt *pkt);
int pktUnpackScore(struct Score_pkt *pkt, ubyte_pkt* buf);

int pktPackWallType(ubyte_pkt* buf, struct PlayerID_pkt *pkt);
int pktUnpackWallType(struct PlayerID_pkt *pkt, ubyte_pkt* buf);

#endif 
