
#include <qapp.h>

#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>
#include <kore/plugin.h>
#include <kore/pluginloader.h>

#include "modulebrowser.h"

int main(int argc, char**argv)
{
    QApplication* app = new QApplication(argc, argv);
    int ret = 0;

    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleManager* mm = dynamic_cast<ModuleManager*> (sm->registeredProvider("Kore/Kernel/Module Manager"));
    PluginLoader* loader = dynamic_cast<PluginLoader*> (sm->registeredProvider("Kore/Kernel/Plugin Loader"));
    if( loader )
    {
        Plugin* plugin = loader->runPlugin("modulebrowserplugin");
        if( plugin )
        {
            if( mm )
                mm->registerModule(plugin);

            ModuleBrowser* browser = dynamic_cast<ModuleBrowser*> (sm->registeredProvider("Kore/UI/Module Browser"));

            app->setMainWidget(browser);
            browser->show();
            ret =  app->exec();
            delete app;

            if( mm )
                mm->unregisterModule(plugin);
            loader->closePlugin(plugin);
        }
        else
            qDebug( loader->lastError() );
    }
    delete Kernel::instance();
    return ret;
}
