#ifndef MODULEBROWSERIMPL_H
#define MODULEBROWSERIMPL_H

#include <qlistview.h>

#include "modulebrowser_qt.h"

namespace kore
{
class Module;
};

class ModuleBrowserImpl : public ModuleBrowserWidget
{
    Q_OBJECT

public:
    ModuleBrowserImpl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~ModuleBrowserImpl();

protected slots:
    void slotClose();
    void slotRefreshColumns(int);
    void slotRefreshModuleList();
    void slotSelectionChanged();
    void slotShowModuleProperties();
    void slotUnregisterModules();

private:
    class ModuleListItem: public QListViewItem
    {
    public:
        ModuleListItem( QListView* parent, kore::Module* mod);

        kore::Module* module() { return _module; };
    private:
        kore::Module* _module;
    };
};

#endif // MODULEBROWSERIMPL_H
