
#include <kore/version.h>
#include <kore/pluginmanager.h>

#define PM_MAJOR 0
#define PM_MINOR 0
#define PM_REVISION 1
#define PM_VERSION "0.0.1"
#define PM_API_MAJOR 0
#define PM_API_MINOR 0
#define PM_API_REVISION 1
#define PM_API_VERSION "0.0.1"
#define PM_NAME "Plugin Manager"
#define PM_TYPE "Plugin Manager"
#define PM_DESCRIPTION "Default Kore Plugin Manager"
#define PM_SERVICE "Kore/Kernel/Plugin Manager"
#define PM_SERVICE_DESCRIPTION "Kore Plugin Manager"

using namespace kore;

PluginManager::PluginManager()
{
    _pmVersion = new Version(PM_MAJOR,PM_MINOR,PM_REVISION,PM_VERSION);
    _pmAPIVersion = new Version(PM_API_MAJOR,PM_API_MINOR,PM_API_REVISION,PM_API_VERSION);
    _pmInfo = new Info(this, PM_NAME, PM_TYPE, PM_DESCRIPTION, _pmVersion, _pmAPIVersion);
    setInfo(_pmInfo);
    _pmService = new Service(this, PM_SERVICE, PM_SERVICE_DESCRIPTION);
    addService(_pmService);
}
PluginManager::~PluginManager()
{
    delete _pmInfo;
    delete _pmVersion;
    delete _pmAPIVersion;
    delete _pmService;
}
