// Copyright(C) 2007,2008 Stefan Siegl <stesie@brokenpipe.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "ui_silcchannelcontactinfo.h"

#include "silcchannelcontactinfowidget.h"
#include "silcchannelcontact.h"
#include "silcaccount.h"

#include <kopeteuiglobal.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>

#include <qlineedit.h>
#include <qcheckbox.h>

SilcChannelContactInfoWidget::SilcChannelContactInfoWidget
(SilcChannelContact *c)
  : passphraseChanged(false), _channel(c)
{
  _dlg = new Ui::SilcChannelContactInfo();
  _dlg->setupUi(this);

  _dlg->chname->setText(c->nickName());
  _dlg->topic->setText(c->topic());

  _dlg->chkAllowRichText->setChecked(c->allowRichText());
  _dlg->chkAutoJoin->setChecked(c->autoJoin());

  // initialize channel config check boxes ...
  _dlg->chkPrivate->setChecked(c->isPrivate());
  _dlg->chkSecret->setChecked(c->isSecret());
  _dlg->chkInviteOnly->setChecked(c->isInviteOnly());
  _dlg->chkSilenceUser->setChecked(c->isSilenceUser());
  _dlg->chkSilenceOperator->setChecked(c->isSilenceOperator());
  _dlg->chkFounderAuth->setChecked(c->isFounderAuth());
  _dlg->chkTopicOperatorOnly->setChecked(c->isTopicOperatorOnly());

  _dlg->userLimit->setValue(c->userLimit());

  


  // possibly disable all widgets, to keep user from editing ...
  SilcBuddyContact *me = _channel->account()->myself();
  bool allowFounderChanges = c->isFounder(me);
  bool allowChanges = c->isOp(me) || allowFounderChanges;

  _dlg->topic->setReadOnly(!allowChanges);
  _dlg->chkPrivate->setEnabled(allowChanges);
  _dlg->chkSecret->setEnabled(allowChanges);
  _dlg->chkInviteOnly->setEnabled(allowChanges);
  _dlg->chkTopicOperatorOnly->setEnabled(allowChanges);
  _dlg->userLimit->setEnabled(allowChanges);
  _dlg->userLimitLabel->setEnabled(allowChanges);

  _dlg->passphrase->setEnabled(allowFounderChanges);
  _dlg->passPhraseLabel->setEnabled(allowFounderChanges);
  _dlg->chkSilenceUser->setEnabled(allowFounderChanges);
  _dlg->chkSilenceOperator->setEnabled(allowFounderChanges);
  _dlg->chkFounderAuth->setEnabled(allowFounderChanges);
  

  // connect buttons ...
  QObject::connect((QObject *) _dlg->buttonOk, SIGNAL(clicked()),
		   this, SLOT(slotOk()));
  QObject::connect((QObject *) _dlg->buttonApply, SIGNAL(clicked()),
		   this, SLOT(slotApply()));
  QObject::connect((QObject *) _dlg->buttonCancel, SIGNAL(clicked()),
		   this, SLOT(slotCancel()));
  QObject::connect((QObject *) _dlg->passphrase, SIGNAL(textChanged(const QString &)),
		   this, SLOT(slotPassphraseChanged(const QString &)));

  show();
}

SilcChannelContactInfoWidget::~SilcChannelContactInfoWidget()
{
  delete _dlg;
}

void
SilcChannelContactInfoWidget::slotPassphraseChanged(const QString &)
{
  passphraseChanged = true;
}

void
SilcChannelContactInfoWidget::slotApply(void)
{
  SilcBuddyContact *me = _channel->account()->myself();

  bool allowFounderChanges = _channel->isFounder(me);
  bool allowChanges = _channel->isOp(me) || allowFounderChanges;

  if(allowChanges) {
    QString newTopic = _dlg->topic->text();
    _channel->setTopic(newTopic);
    _channel->setPrivate(_dlg->chkPrivate->isChecked());
    _channel->setSecret(_dlg->chkSecret->isChecked());
    _channel->setInviteOnly(_dlg->chkInviteOnly->isChecked());
    _channel->setTopicOperatorOnly(_dlg->chkTopicOperatorOnly->isChecked());
    _channel->setUserLimit(_dlg->userLimit->value());
  }

  if(allowFounderChanges) {
    _channel->setSilenceUser(_dlg->chkSilenceUser->isChecked());
    _channel->setSilenceOperator(_dlg->chkSilenceOperator->isChecked());
    _channel->setFounderAuth(_dlg->chkFounderAuth->isChecked());
    if(passphraseChanged)
      _channel->setPassphrase(_dlg->passphrase->text());
  }

  _channel->setAllowRichText(_dlg->chkAllowRichText->isChecked());
  _channel->setAutoJoin(_dlg->chkAutoJoin->isChecked());
}

void
SilcChannelContactInfoWidget::slotOk(void)
{
  slotApply();
  delete this;
}

void
SilcChannelContactInfoWidget::slotCancel(void)
{
  delete this;
}


#include "silcchannelcontactinfowidget.moc"

