/***************************************************************************
                          xmlstream.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef XMLSTREAM_H
#define XMLSTREAM_H

#include <config.h>

#include <unistd.h>

#include <qobject.h>
#include <qsocketnotifier.h>
#include <qstring.h>
#include <qtimer.h>
#include <qstack.h>
#include <qtimer.h>

#include <kmessagebox.h>

#include "xmlnode.h"
#include <expat.h>

// Expat include
#include "xmlparse.h"

/**
  *@author Seth Hartbecke
  */

// Connection Failed error codes
#define DNS_NOT_FOUND		1
#define CONNECTION_REJECTED	2
#define NO_RESPONCE		3			// Class waits 5 minutes for
							// tag before this is returned																								
							// the return of the <stream:stream		

/**
 * This class provides a clean interface beween a network socket streaming XML packets
 * and the Expat class (the XML parser).  You can close and open sockets without having
 * to delete the class, this way you can easily build on top of this class.
 *
 * You definatally want to look at the Expat class or else you may not understand what
 * this is doing.
 *
 * @short XML Streaming class
 * @author Seth Hartbecke (gandalf@netins.net)
 * @see Expat
 */
class XMLStream
	: public Expat
{
	Q_OBJECT
public:
        /**
	 * Default constructor.
	 */
	XMLStream(QObject *parent, const char *name);
	~XMLStream();

	/**
	 * Specified tag to the other end of the connection.  This returns a -1 if there is no active
	 * connection.
	 */
	int sendTag(XMLNode &t);

	/**
	 * Returns true if there is an open and operating XMLStream.
         */
	bool isConnected();

public slots:
        /**
	 * Call this to initalize a stream, it will return an error code if it fails.
	 */
	int connectXMLStream( const char *server, int port, const char *xmlns, const char *xmlnsStream );

	/**
	 * This will close the active stream (if any).
	 */
	void disconnect();

protected:
        /**
	 * This method is called when the connection was lost and the XMLStream class was not
	 * expecting to loose it (ie, when you call disconnect());
	 */
	virtual void connectionLost();

protected slots:
        /**
	 * A timer calles this every 5 minutes, it just sends a newline down the connection.  This
	 * helps my home PC know when jabber.org has lost connection (I connect via a NAT box).
	 */
        void sendKeepalive();

private slots:
	void newData();

private:
	void cleanup();		// Like a distructor in that it cleans many things up
	int writeData(QString s);

	// Info about the server (name, port, xmlns...)
	QString server;
	int port;
	QString xmlns;
	QString xmlnsStream;

	QSocketNotifier *notifier;
        QTimer *keepAlive;

	QString inBuffer;
	int fd;

};

#endif















