/***************************************************************************
                          user.cpp  -  description
                             -------------------
    begin                : Thu Jan 6 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "user.h"
#include <userpresence.h>
#include <group.h>

User::User(JabberID _jid )
  : QTabDialog (0 , _jid.getJID())
  , JabberID( _jid )
{
	isAskingSubscribe = false;
	isAskingUnsubscribe = false;
	tryingToSubscribe = false;
	subscriptionType = subscribedUnknown;

        _realName.sprintf("%s@%s", (const char *)getNode(), (const char *)getDomain());

	pageGeneral = new UserPgGenInfo( this );
	addTab( pageGeneral, "General" );
	connect( this, SIGNAL(presenceChanged(User *, UserPresence *)), pageGeneral, SLOT(reloadInfo(User *, UserPresence *)) );

	pageGroups = new UserPgGroups( this );
	addTab( pageGroups, "Groups" );
	connect( this, SIGNAL(groupsChanged(User *)), pageGroups, SLOT(reloadGroups(User *)) );

	pageSubscription = new UserPgSubscription( this );
	addTab( pageSubscription, "Subscription" );
	connect( this, SIGNAL(subscriptionChangeRequest(User *)), pageSubscription, SLOT(subscriptionChangeRequest(User *)) );
	connect( this, SIGNAL(subscriptionChanged(User *)), pageSubscription, SLOT(subscriptionChanged(User *)) );
	connect( this, SIGNAL(subscriptionCanceled(User *)), pageSubscription, SLOT(subscriptionCanceled(User *)) );


	setCaption(getJID());

        connect( this, SIGNAL(applyButtonPressed()), this, SLOT(saveChanges()) );
}

User::~User()
{
        /* remove this person from all their groups */
        /* this is a GUI update only, we do not send anything back to the server here */
 	/* first inform the group database of the change */

        emit( userDeleted( this ) );

        QString gn;
 	for ( gn=groups.first(); gn != 0; gn=groups.next() )
        {
                jabber->getGroup( gn )->removeUser( this );
               	emit( removedFromGroup( this, gn ) );
        }

	delete pageGeneral;
	delete pageGroups;
	delete pageSubscription;

}

bool User::watingSubscribeConfirm()
{
	return tryingToSubscribe;
}

void User::saveChanges()
{
 	setRealName( pageGeneral->getNewRealname() );
        commitGroups();
}

int User::numberResources()
{
	return presenceList.count();
}

UserPresence *User::getPresence(int n)
{
	return presenceList.at(n);
}

UserPresence *User::getPresence(QString p)
{
 	unsigned int count_i;
	UserPresence *item;

	for (count_i=0; count_i<presenceList.count(); count_i++)
	{
		item = presenceList.at(count_i);
		if (strcmp(item->resourceName(), p) == 0)
			return item;
	}

	return 0;
}

UserPresence *User::getHighestPresence()
{
 	unsigned int count_i;
 	int lastPriority;
	UserPresence *item, *highest;

	highest = 0;
	lastPriority = -99999;

	for (count_i=0; count_i<presenceList.count(); count_i++)
	{
		item = presenceList.at(count_i);
		if (item->priority() > lastPriority)
		{
			lastPriority = item->priority();
			highest = item;
		}
	}

	return highest;
}

int User::getSubscriptionType()
{
 	return subscriptionType;
}

void User::subscribe()
{
	// First check to see if we really need to bother them
	if (subscriptionType == subscribedTo
            || subscriptionType == subscribedBoth)
        { } else
	{
 		XMLNode *subscribe = new XMLNode();
		subscribe->setName("presence");
		subscribe->setAttribute("to", getJID());
		subscribe->setAttribute("type", "subscribe");

		if(jabber->sendTag( *subscribe ) == -1)
		{
			printf("Unable to subscribe because not connected!");
		}
	}
}

void User::unsubscribe()
{
	// First check to see if we really need to bother them
	if (subscriptionType == subscribedFrom
            && subscriptionType == subscribedNone)
        { } else
	{
		XMLNode subscribe;
		QString jid =  getJID();
		subscribe.setName("presence");
		subscribe.setAttribute("to", jid );
		subscribe.setAttribute("type", "unsubscribe");

		if(jabber->sendTag( subscribe ) == -1)
		{
			printf("Unable to unsubscribe because not connected!");
		}
	}
}

void User::removeUser()
{
        /* this is really an IQ, but I don't care about the responce */
        XMLNode remove("iq");
        remove.setAttribute("id", "carenot");
        remove.setAttribute("type", "set" );
        remove.getChildNode("query")->setAttribute("xmlns", "jabber:iq:roster");
        remove.getChildNode("query")->getChildNode("item")->setAttribute("jid", getJID() );
        remove.getChildNode("query")->getChildNode("item")->setAttribute("subscription", "remove");
        jabber->sendTag( remove );

        delete this;
}

bool User::askingSubscribe()
{
 	return isAskingSubscribe;
}

void User::allowSubscribe()
{
	// First check to see if we really need to bother them
	XMLNode *subscribe = new XMLNode();
	subscribe->setName("presence");
	subscribe->setAttribute("to", getJID());
	subscribe->setAttribute("type", "subscribed");

	if(jabber->sendTag( *subscribe ) == -1)
	{
		printf("Unable to allow user to subscribe because not connected!");
	}
	else
		isAskingSubscribe = false;

}
bool User::askingUnsubscribe()
{
 	return isAskingUnsubscribe;
}

void User::allowUnsubscribe()
{
	// First check to see if we really need to bother them
	XMLNode *subscribe = new XMLNode();
	subscribe->setName("presence");
	subscribe->setAttribute("to", getJID());
	subscribe->setAttribute("type", "unsubscribed");

	if(jabber->sendTag( *subscribe ) == -1)
	{
		printf("Unable to allow user to unsubscribe because not connected!");
	}
	else
		isAskingUnsubscribe = false;

}

void User::addGroup( QString group )
{
        /* remove from the special "" (null string) group */
        if (!group.isEmpty())
                removeGroup( "" );

 	/* first inform the group database of the change */
        jabber->getGroup( group )->addUser( this );

        /* ok, now update my object */
        bool reallyNew = true;
        QString gn;
 	for ( gn=groups.first(); gn != 0; gn=groups.next() )
        {
         	if ( gn == group )
                	reallyNew = false;
        }

        if ( reallyNew )
        {
        	groups.append( group );
                emit( addedToGroup( this, group ) );
        }
}

void User::removeGroup( QString group )
{
 	/* first inform the group database of the change */
        jabber->getGroup( group )->removeUser( this );

        QString gn;
 	for ( gn=groups.first(); gn != 0; gn=groups.next() )
        {
         	if ( gn == group )
                {
                	groups.remove();
                	emit( removedFromGroup( this, group ) );
                }
        }

        if (groups.count() == 0 && !group.isEmpty())
        {
                /* add to the spical "" (null string) group */
                addGroup( "" );
        }

}

QStrList User::getGroups()
{
	return groups;
}

void User::commitGroups()
{
	InfoQuery *updateRoster;
 	updateRoster = jabber->queryManager()->createQuery();
 	updateRoster->setNameSpace("jabber:iq:roster");
 	updateRoster->setType("set");
 	XMLNode *item = updateRoster->getChildNode("query")->getChildNode("item");
 	item->setAttribute("jid", getJID());
        item->setAttribute("name", _realName);
 	connect( updateRoster, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(RosterUpdateResults(InfoQuery *, InfoQuery *)) );

 	/* Send the new group list */
 	unsigned int count_i;
 	for(count_i=0; count_i<groups.count(); count_i++)
 	{
                QString groupName = groups.at(count_i);
                if (!groupName.isEmpty())
                {
 		        XMLNode *aGroup;
 		        aGroup = new XMLNode();
 		        aGroup->setName("group");
 		        aGroup->setValue( groupName );

 		        item->addChildNode( aGroup );
                }
 	}

 	updateRoster->send();


}

void User::RosterUpdateResults(InfoQuery *, InfoQuery *)
{
	emit( groupsChanged( this ) );
}

void User::processItemTag(XMLNode *t)
{
	QString newSubscriptionType = "";
	newSubscriptionType = t->getAttribute("subscription");
	if (!newSubscriptionType.isNull())
	{
		if (strcmp(newSubscriptionType, "to") == 0
		    && subscriptionType != subscribedTo)
		{
			subscriptionType = subscribedTo;
			emit( subscriptionChanged( this ) );
		}
		if (strcmp(newSubscriptionType, "from") == 0
		    && subscriptionType != subscribedFrom)
		{
			subscriptionType = subscribedFrom;
			emit( subscriptionChanged( this ) );
		}
		if (strcmp(newSubscriptionType, "both") == 0
		    && subscriptionType != subscribedBoth)
		{
			subscriptionType = subscribedBoth;
			emit( subscriptionChanged( this ) );
		}
		if (strcmp(newSubscriptionType, "none") == 0
		    && subscriptionType != subscribedNone)
		{
			subscriptionType = subscribedNone;
			emit( subscriptionChanged( this ) );
		}
	}

	QString newAsking;
	newAsking = t->getAttribute("ask");
	if (!newAsking.isNull())
	{
	 	if (strcmp(newAsking, "subscribe") == 0
	 	    && isAskingSubscribe == false)
	 	{
	 		tryingToSubscribe = true;
	 		emit( subscriptionChanged( this ) );
	 	}
	 	else
	 	{
	 		tryingToSubscribe = false;
	 		emit( subscriptionChanged( this ) );
	 	}
	}

	/* Now update the groups */
	bool subscriptionChangedRequested = false;
	//groups.clear();
	int count_i;
	for(count_i=0; count_i<t->numberChildNodes(); count_i++)
	{
		if (strcmp(t->getChildNode( count_i )->getName(), "group") == 0)
		{
			QString group;
			group = ( t->getChildNode( count_i )->getValue() );
                	addGroup( qstrdup(group) );
		}

		if (strcmp(t->getChildNode( count_i )->getName(), "subscribe") == 0)
		{
			isAskingSubscribe = true;
			isAskingUnsubscribe = false;
			subscriptionChangedRequested = true;
		}

		if (strcmp(t->getChildNode( count_i )->getName(), "unsubscribe") == 0)
		{
			isAskingSubscribe = false;
			isAskingUnsubscribe = true;
			subscriptionChangedRequested = true;
		}


	}
	emit( groupsChanged( this ) );

	if (subscriptionChangedRequested == true)
		emit( subscriptionChangeRequest( this ) );

        if ( !t->getAttribute("name").isNull()
                && strcmp( t->getAttribute("name"), _realName ) != 0 )
        {
                _realName = t->getAttribute("name");
                emit( informationChanged( this ) );
        }


        /* if they are not in a group by now, we need to put them in the special "" (null string)
           group */
        if (groups.count() == 0)
                addGroup( "" );
}

QString User::getRealName()
{
        return _realName;
}

void User::setRealName(QString realName)
{
        if ( _realName != realName)
        {
                _realName = realName;
                emit( informationChanged( this ) );
        }
}

void User::processPresence(XMLNode *t)
{
	QString type;
	type = t->getAttribute("type");

	if (strcmp(type, "subscribe") == 0
	    && isAskingSubscribe == false)
	{
		isAskingSubscribe = true;
		isAskingUnsubscribe = false;
		emit( subscriptionChangeRequest( this ) );
	}

	if (strcmp(type, "unsubscribe") == 0
	    && isAskingUnsubscribe == false)
	{
		isAskingSubscribe = false;
		isAskingUnsubscribe = true;
		emit( subscriptionChangeRequest( this ) );
	}

	if (strcmp(type, "subscribed") == 0)
	{
		isAskingSubscribe = false;
		isAskingUnsubscribe = false;
		tryingToSubscribe = false;

		emit( subscriptionChanged( this ) );
	}

	if (strcmp(type, "unsubscribed") == 0)
	{
		if (isAskingSubscribe == true
		    || subscriptionType == subscribedTo
		    || subscriptionType == subscribedBoth)
		{
			emit( subscriptionCanceled( this ) );
		}

		isAskingSubscribe = false;
		isAskingUnsubscribe = false;
		tryingToSubscribe = false;

		emit( subscriptionChanged( this ) );
	}

	if (type.isEmpty()
	    || strcmp(type, "unavailable") == 0)
	{
		// Have to send this tag to the resource object
                JabberID tmpJID( t->getAttribute("from") );
		UserPresence *tmp = 0;
                bool newResource = true;
                QString resource = tmpJID.getResource();
                if (resource.isEmpty())
                        resource = "Transport Resource";

		unsigned int count_i;
                unsigned int tmpNum = presenceList.count();
		for (count_i=0; count_i<presenceList.count(); count_i++)
		{
			tmp = presenceList.at(count_i);
			if (strcmp(tmp->resourceName(), resource) == 0)
                        {
                        	newResource = false;
				tmp->processPresence(t);
    			}
		}

		if ( newResource )
		{
                	// Need to create a new one
			tmp = new UserPresence(this, resource);
			tmp->processPresence(t);
			presenceList.append( tmp );

			connect( tmp, SIGNAL(presenceChanged(User *, UserPresence *)), this, SLOT(memberResourceChanged(User *, UserPresence *)) );
                        connect( tmp, SIGNAL(presenceDeleted(User *, UserPresence *)), this, SLOT(memberResourceDeleted(User *, UserPresence *)) );
                        connect( tmp, SIGNAL(presenceDeleted(User *, UserPresence *)), pageGeneral, SLOT(removedResource(User *, UserPresence *)) );
			emit( presenceChanged( this, tmp ) );
		}
	}
}

void User::memberResourceChanged(User *, UserPresence *p)
{
	emit( presenceChanged( this, p ) );
}


void User::memberResourceDeleted(User *, UserPresence *p)
{
	presenceList.removeRef( p );
}

/*
				**********************
				    UserPgGenInfo
				**********************
*/

UserPgGenInfo::UserPgGenInfo(User *u)
	: QWidget(u, "GenInfo")
{
 	user = u;

 	layout = new QGridLayout(this, 4, 4, 5, 5);


 	lblJID = new QLabel( "Jabber ID:", this);
        lblJID->setMaximumHeight( lblJID->sizeHint().height()+4 );
 	layout->addWidget(lblJID, 0, 0);

 	txtJID = new QLabel( u->getJID(), this );
 	layout->addMultiCellWidget(txtJID, 0, 0, 1, 2);

        lblRealName = new QLabel( "Real Name:", this );
        layout->addWidget( lblRealName, 1, 0 );

        txtRealName = new QLineEdit( this, "txtRealName" );
        txtRealName->setMaximumHeight( txtRealName->sizeHint().height()+4 );
        layout->addMultiCellWidget( txtRealName, 1, 1, 1, 2 );
        txtRealName->setText( user->getRealName() );
        connect( user, SIGNAL(informationChanged(User *)), this, SLOT(newRealname(User *)) );

 	resourceList = new QListView( this );
 	resourceList->addColumn( "Resource", 150 );
 	resourceList->addColumn( "Available", 100 );
 	id = resourceList->addColumn( "Status" );
 	resourceList->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
 	layout->addMultiCellWidget( resourceList, 2, 3, 0, 3 );

 	layout->setColStretch( 1, 3 );

 	layout->activate();

        connect( resourceList, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(startChat(QListViewItem *)) );
 }

UserPgGenInfo::~UserPgGenInfo()
{
	delete layout;
	delete lblJID;
	delete txtJID;
	delete resourceList;
        delete lblRealName;
        delete txtRealName;
}

void UserPgGenInfo::resizeEvent( QResizeEvent * )
{
	resourceList->header()->setCellSize(id, resourceList->size().width() - 250 - 5 );
}

void UserPgGenInfo::reloadInfo(User *, UserPresence *)
{
	// First zap all the items in the list
	resourceList->clear();

	int count_i;
	UserPresence *item;

	for (count_i=0; count_i<user->numberResources(); count_i++)
	{
	 	item = user->getPresence( count_i );
	 	QString strAvail;

	 	if (item->available())
	 		strAvail = "Yes";
		else
			strAvail = "No";

   		QListViewItem *tmp = new QListViewItem( resourceList, item->resourceName() );
                tmp->setPixmap( 0, item->getIcon() );
                tmp->setText( 1, strAvail );
                tmp->setText( 2, item->status() );

	 	//(void) new QListViewItem( resourceList, item->getIcon(), item->resourceName(), strAvail, item->status() );
	}
}

void UserPgGenInfo::removedResource(User *, UserPresence *p)
{
	QListViewItem *resource = resourceList->firstChild();

        while (resource != 0)
        {
                if( strcmp( resource->text(0), p->resourceName() ) == 0 )
                {
                 	delete resource;
                        resource = 0;
                }
                else
	        	resource = resource->nextSibling();
        }
}

void UserPgGenInfo::startChat( QListViewItem *item )
{
	if (item != 0)
 		jabber->messageBin()->startChat( user->getJID() + item->text( 0 ) )->show();
}

/*
				**********************
				    UserPgGroups
				**********************
*/
UserPgGroups::UserPgGroups(User *u)
	: QWidget(u, "GenInfo")
{
 	user = u;

 	layout = new QGridLayout(this, 4, 4, 5, 5);

 	groups = new QListView( this );
 	groups->addColumn( "Group" );
 	//groups->setMinimumSize( 250, 300 );
 	layout->addMultiCellWidget( groups, 0, 1, 0, 1 );
 	groups->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );

 	addBox = new QGroupBox( "Add Group", this );
 	addLayout = new QGridLayout( addBox, 3, 2, 5, 0 );

 	btnAdd = new QPushButton( "Add", addBox );
 	btnAdd->setMinimumSize( btnAdd->sizeHint() );
 	btnAdd->setMaximumSize( btnAdd->sizeHint() );
 	connect( btnAdd, SIGNAL(clicked()), this, SLOT(addGroup()) );
 	addLayout->addWidget( btnAdd, 2, 1 );

 	txtNewGroup = new QLineEdit( addBox );
 	txtNewGroup->setMinimumSize( txtNewGroup->sizeHint() );
 	txtNewGroup->setMaximumHeight( txtNewGroup->sizeHint().height() );
 	addLayout->addMultiCellWidget( txtNewGroup, 1, 1, 0, 1 );

 	int maxHeight = btnAdd->sizeHint().height() + ( 2 * txtNewGroup->sizeHint().height() );
 	addBox->setMinimumHeight( maxHeight );
 	layout->addWidget( addBox, 0, 2 );

        /* Populate the groups dialog */
        int i;
        for (i=0; i<jabber->numberGroups(); i++)
        	newAvailGroup( jabber->getGroup( i ) );

        connect( jabber, SIGNAL(newGroup(Group *)), this, SLOT(newAvailGroup(Group *)) );
        connect( jabber, SIGNAL(deletedGroup(Group *)), this, SLOT(removeAvailGroup(Group *)) );
        connect( user, SIGNAL(addedToGroup(User *, QString)), this, SLOT(addToGroup(User *, QString)) );
        connect( user, SIGNAL(removedFromGroup(User *, QString)), this, SLOT(removedFromGroup(User *, QString)) );
        connect( groups, SIGNAL(clicked(QListViewItem *)), this, SLOT(groupItemClicked(QListViewItem *)) );

 	addLayout->activate();
 	layout->activate();
}

UserPgGroups::~UserPgGroups()
{
	delete layout;
	delete groups;
}

void UserPgGroups::groupItemClicked( QListViewItem *gi )
{
	if (gi == 0)
        	return;

 	QCheckListItem *item = (QCheckListItem *)gi;

        if (item->isOn())
        	user->addGroup( item->text( 0 ) );
        else
        	user->removeGroup( item->text( 0 ) );
}

void UserPgGroups::newAvailGroup(Group *g)
{
        if ( !g->getName().isEmpty() )
	        (void) new QCheckListItem( groups, g->getName(), QCheckListItem::CheckBox );
}

void UserPgGroups::removeAvailGroup(Group *g)
{
 	QCheckListItem *p= getItem( g->getName() );
        if (p != 0)
        	delete p;
}

void UserPgGroups::addToGroup(User *, QString group)
{
	QCheckListItem *p= getItem( group );
        if (p != 0)
        	p->setOn( true );
}

void UserPgGroups::removedFromGroup(User *, QString group)
{
	QCheckListItem *p= getItem( group );
        if (p != 0)
        	p->setOn( false );
}

QCheckListItem *UserPgGroups::getItem(QString groupName)
{
 	QListViewItem *p = groups->firstChild();

        while (p != 0)
        {
         	if (p->text( 0 ) == groupName)
                	return (QCheckListItem *)p;

          	p = p->nextSibling();
        }

        return 0;
}

void UserPgGroups::reloadGroups(User *)
{

}

void UserPgGroups::addGroup()
{
	QString newGroupName;
	newGroupName = txtNewGroup->text();

	if (newGroupName.isEmpty() || newGroupName.length() == 0)
	{
	 	KMessageBox *msgBox = new KMessageBox();
	 	msgBox->sorry( this, "Please type something", "Add new group");
	 	delete msgBox;
	}
	else
        {
                user->addGroup( newGroupName );

	 	txtNewGroup->setText( 0 );
	}
}

/*
				**********************
				    UserPgSubscription
				**********************
*/
UserPgSubscription::UserPgSubscription(User *u)
	: QWidget(u, "GenInfo")
{
	user = u;


 	layout = new QGridLayout(this, 4, 1, 5, 0);
 	int height;

 	QString caption;
 	caption.sprintf( "The user %s recieves your status", (const char *)user->getJID() );
 	subscribedFrom = new QCheckBox( (const char *)caption, this );
 	height = subscribedFrom->sizeHint().height();
 	subscribedFrom->setMaximumHeight( height );
 	layout->addWidget( subscribedFrom, 0, 0 );
 	connect( subscribedFrom, SIGNAL(clicked()), this, SLOT(fromClicked()) );

	caption.sprintf( "You recieve %s's status", (const char *)user->getJID() );
	subscribedTo = new QCheckBox( (const char *)caption, this );
	subscribedTo->setMaximumHeight( height );
 	layout->addWidget( subscribedTo, 1, 0 );
 	connect( subscribedTo, SIGNAL(clicked()), this, SLOT(toClicked()) );

 	subscriptionStatus = new QLabel( "", this );
 	subscriptionStatus->setMaximumHeight( height );
 	layout->addWidget( subscriptionStatus, 2, 0);

 	layout->activate();

}

UserPgSubscription::~UserPgSubscription()
{
	delete layout;
	delete subscribedFrom;
	delete subscribedTo;
}

void UserPgSubscription::subscriptionChanged(User *)
{
	refreshCheckboxes();
}

void UserPgSubscription::subscriptionChangeRequest(User *u)
{
	refreshCheckboxes();

	if (user->askingSubscribe() || user->askingUnsubscribe() )
	{
              	KMessageBox *msgBox;
		QString message;
              	int retVal;


		if (user->askingSubscribe())
		{
			message.sprintf("The user %s would like to subscribe to your presence.", (const char *)user->getJID());

                        if( user->getNode().isEmpty() )
                        {
                                // This is a transport, auto subscribe
                                user->allowSubscribe();
                        }
                        else
                        {
        	              	msgBox = new KMessageBox();
                		u->show();
	               	      	retVal = msgBox->questionYesNo(this, message, "Subscription Request" );

              		        if (retVal == KMessageBox::Yes)
        	              		user->allowSubscribe();
                	      	else
              	        		user->allowUnsubscribe();

                                delete msgBox;

                        }
              	}
              	else
              	{
              		message.sprintf("The user %s has unsubscribed from your presence.", (const char *)user->getJID());

              		msgBox = new KMessageBox();
        		u->show();
              		msgBox->sorry(this, message, "Subscription Request");

              		delete msgBox;

              	}
   		refreshCheckboxes();
	}
}

void UserPgSubscription::subscriptionCanceled(User *)
{
	QString message;
	KMessageBox *msgBox;

	user->show();

	message.sprintf("The user %s will not allow you to recieve their presence.", (const char *)user->getJID());

	msgBox = new KMessageBox();
	msgBox->sorry(this, message, "Subscription Notice");

	delete msgBox;
}

void UserPgSubscription::refreshCheckboxes()
{
	//printf("***** *** Here! ***** %d\n", user->getSubscriptionType());
	subscribedFrom->setChecked( false );
	subscribedTo->setChecked( false );

	if (user->getSubscriptionType() == User::subscribedTo
	    || user->getSubscriptionType() == User::subscribedBoth)
	{
		subscribedTo->setChecked( true );
	}

	if (user->getSubscriptionType() == User::subscribedFrom
	    || user->getSubscriptionType() == User::subscribedBoth)
	{
		subscribedFrom->setChecked( true );
	}

	if (user->watingSubscribeConfirm())
		subscriptionStatus->setText("      Waiting for user to confirm");
	else
		subscriptionStatus->setText("");

}

void UserPgSubscription::fromClicked()
{
	if (subscribedFrom->isChecked())
		subscribedFrom->setChecked( false );
	else
		user->allowUnsubscribe();
}

void UserPgSubscription::toClicked()
{
	if (subscribedTo->isChecked())
	{
		user->subscribe();
	}
	else
	{
		user->unsubscribe();
	}

}
