/***************************************************************************
                          dlgconnectinprogress.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Dec 4 1999                                           
    copyright            : (C) 1999 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "dlgconnectinprogress.h"

DlgConnectInProgress::DlgConnectInProgress(QWidget *parent, const char *name )
	: QFrame(parent,name, WStyle_Customize | WStyle_NoBorder | WStyle_Tool)
{
	QSize hintedSize;
	int maxHeight;
	topLayout = new QGridLayout(this, 3, 1, 3, -1, "layoutThingy");

	QPixmap logo;
	logo = KGlobal::iconLoader()->loadIcon("konverse-large", KIcon::NoGroup);
	konverseLogo = new QWidget( this, "Konverse Logo");
	konverseLogo->setBackgroundPixmap( logo );
	konverseLogo->resize( logo.size() );
	konverseLogo->setMaximumSize( logo.size() );
	konverseLogo->setMinimumSize( logo.size() );
	topLayout->addWidget( konverseLogo, 0, 0, AlignHCenter );
	topLayout->setRowStretch( 0, 2);
	
	QString message;
	message.sprintf("Connecting to jabber server...\n");
	connectMessage = new QLabel(message, this, "ConnectTo");
	hintedSize = connectMessage->sizeHint();
	maxHeight = hintedSize.height();
	connectMessage->setMaximumSize(hintedSize.width(), hintedSize.height());
	connectMessage->setMinimumSize(hintedSize.width(), hintedSize.height());
	connectMessage->setBackgroundColor( white );
	connectMessage->setAlignment( AlignHCenter | AlignVCenter );
	topLayout->addWidget(connectMessage, 1, 0);

        cancel = new QPushButton( "&Cancel", this );
        cancel->setDefault( true );
        cancel->setMinimumSize( cancel->sizeHint() );
        cancel->setMaximumHeight( cancel->sizeHint().height() );
        connect( cancel, SIGNAL(clicked()), this, SIGNAL(cancelConnect()) );
        topLayout->addWidget( cancel, 2, 0 );

	topLayout->activate();

	setBackgroundColor( white );
	setFrameStyle( Panel | Plain );
	setLineWidth( 1 );

	hintedSize = sizeHint();	
	
	setGeometry( (QApplication::desktop()->width()/2) -75
		, (QApplication::desktop()->height()/2)-120
		, 150
		, hintedSize.height()); 	
		
	setCaption("Konverse");

}

DlgConnectInProgress::~DlgConnectInProgress()
{
	delete connectMessage;
	delete konverseLogo;
}

void DlgConnectInProgress::setCaption(QString caption)
{
 	connectMessage->setText( caption );
}
