/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : 10/24/2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
	Stores information about an agent
*/

#ifndef _AGENT_H_
#define _AGENT_H_

#include <qstring.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qmap.h>
#include <qlabel.h>
#include <qlist.h>
#include <qlineedit.h>
#include <qbutton.h>
#include <qtextview.h>
#include <qtextbrowser.h>

#include <kmessagebox.h>
#include <kpassdlg.h>


#include <xmlnode.h>
#include <infoquery.h>

class DlgAgentRegister;

/**
 * This stores all the information that the client knows about an agent.
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 */
class Agent
{
public:
 	Agent(XMLNode *n);

        /**
         * Returnst the jid for the specified agent.
         */
        QString jid() { return _jid; };
        /**
         * Returns the name of the agent.
         */
        QString name() { return _name; };
        /**
         * Returns the description of the agent.
         */
        QString description() { return _description; };
        /**
         * Returns the service of the agent.
         */
        QString service() { return _service; };
        QString transport() { return _transport; };
        QString url() { return _url; };
        /**
         * Returns true if the transport supports groupchat.
         */
        bool supportsGroupchat() { return _groupChat; };
        /**
         * Returns true if the transport requires registration.
         */
        bool requiresRegistration() { return _register; };
        /**
         * Returns true if the agent is searchable.
         */
        bool searchable() { return _searchable; };

private:
	QString _jid;
	QString _name;
        QString _description;
        QString _service;
        QString _transport;
        QString _url;
        bool _groupChat;
        bool _register;
        bool _searchable;
};

/**
 * This class is the dialog that lists all the agents that the system knows about.
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 * @see Agent
 */
class DlgAgents
	: public QWidget
{
   Q_OBJECT
public:
	/* dont call this */
 	DlgAgents();
        ~DlgAgents();
        /**
         * Call this if you want the dialog to show.
         */
        static void showDlgAgents();

private slots:
	void clickedAgent(QListViewItem *);
        void dblClickedAgent(QListViewItem *i) { currentItem = i; startRegister(); };

        void registerClicked() { startRegister(); };
        void closeClicked() { delete this; };

        void systemOffline() { delete this; };

private:
	static DlgAgents *currentDlg;

        void closeEvent(QCloseEvent *);
        void startRegister();

	QListView *agents;
        QPushButton *btnRegister, *btnClose;
        QGridLayout *layout;

        QListViewItem *currentItem;
        QMap<QListViewItem *, Agent *> itemAgentXref;
};

/**
 * This is the registration form for agents (it knows how to request them and
 * display the request form).
 */
class DlgAgentRegister
        : public QDialog
{
        Q_OBJECT
public:
        DlgAgentRegister( QWidget *parent, Agent *agent );

private slots:
        void formRecieved(InfoQuery *, InfoQuery *);
        void regReqRecieved(InfoQuery *, InfoQuery *);
        void pushedCancel() { reject(); };
        void pushedRegister();


private:
        void closeEvent(QCloseEvent *);

        Agent *_agent;

        QLabel *fetchingForm;

        QLabel *_instructions;
        QGridLayout *layout;
        QList<QLabel> _labels;
        QList<QLineEdit> _inputBoxes;
        QPushButton *_btnCancel, *_btnRegister;
        QString _key;
};

#endif
