/***************************************************************************
 *   Copyright (C) 2005-2008 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include "kfileitemext.h"

#include "komparatorjob.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

KomparatorJob::KomparatorJob( QWidget *_parent )
	: QObject( _parent), m_parent( _parent )
{
}

KomparatorJob::~KomparatorJob()
{
	m_parent = NULL;
}

bool KomparatorJob::isCanceled()
{
	m_mutex.lock();
	bool ret = m_canceled;
	m_mutex.unlock();

	return ret;
}

void KomparatorJob::emitProgress( QString str, int percent )
{
	std::string *new_str = new std::string( str.ascii() );
	int *new_percent = new int;
	*new_percent = percent;

	QPair< std::string *, int * > *resultpair = new QPair< std::string *, int * >;

	*resultpair = qMakePair( new_str, new_percent );

	QCustomEvent *event = new QCustomEvent( PROGRESS_PROGRESS );
	event->setData( resultpair );
	QApplication::postEvent( m_parent, event );
}

void KomparatorJob::emitMessage( const QString &message, const QString &title )
{
	QString *new_message = new QString( message.ascii() );
	QString *new_title = new QString( title.ascii() );

	QPair< QString *, QString * > *resultpair = new QPair< QString *, QString * >;

	*resultpair = qMakePair( new_message, new_title );

	QCustomEvent *event = new QCustomEvent( MESSAGE_ERROR );
	event->setData( resultpair );
	QApplication::postEvent( m_parent, event );
}

void KomparatorJob::start()
{
	m_mutex.lock();
	m_canceled = false;
	m_mutex.unlock();

	QThread::start();
}

void KomparatorJob::stop()
{
	m_mutex.lock();
	m_canceled = true;
	m_mutex.unlock();
}

void KomparatorJob::run()
{
}

void KomparatorJob::incrementProgress()
{
	m_mutex.lock();
	m_progress++;
	m_mutex.unlock();

	if ( !isCanceled() ) emitProgress( m_status, (int)((m_progress*100)/m_total) );
}
