/***************************************************************************
 *   Copyright (C) 2005-2010 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <KLocale>

#include <string>

#include "kfileitemext.h"

#include "komparatorjob.h"

#include <version.h>
#include <QCustomEvent>

KomparatorJob::KomparatorJob( QWidget *_parent )
	: m_parent( _parent )
{
	connect( this, SIGNAL( emitInteractionMessage( const QString &, const QString & ) ), (QObject *)m_parent, SLOT( slotInteractionMessageError( const QString &, const QString & ) ) );
	connect( this, SIGNAL( emitInteractionProgress( const QString &, const int & ) ), (QObject *)m_parent, SLOT( slotInteractionProgressProgress( const QString &, const int & ) ) );
}

KomparatorJob::~KomparatorJob()
{
	m_parent = NULL;
}

bool KomparatorJob::isCanceled()
{
	m_mutex.lock();
	bool ret = m_canceled;
	m_mutex.unlock();

	return ret;
}

void KomparatorJob::emitProgress( QString str, int percent )
{
	emit emitInteractionProgress( str, percent );
}

void KomparatorJob::emitMessage( const QString &message, const QString &title )
{
	emit emitInteractionMessage( message, title );
}

void KomparatorJob::start()
{
	m_mutex.lock();
	m_canceled = false;
	m_mutex.unlock();

	QThread::start();
}

void KomparatorJob::stop()
{
	m_mutex.lock();
	m_canceled = true;
	m_mutex.unlock();
}

void KomparatorJob::run()
{
}

void KomparatorJob::incrementProgress()
{
	m_mutex.lock();
	m_progress++;
	m_mutex.unlock();

	if ( !isCanceled() ) emitProgress( m_status, (int)((m_progress*100)/m_total) );
}
