/***************************************************************************
 *   Copyright (C) 2005-2006 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>

#include <kcombobox.h>
#include <kconfig.h>
#include <kdialogbase.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <klocale.h>
#include <knuminput.h>
#include <ktabwidget.h>
#include <kurlrequester.h>

#include "kdatecombo.h"
#include "komparatorfilefilter.h"
#include "komparatorwidget.h"

#include "komparatorpreset.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

KomparatorPreset::KomparatorPreset( KomparatorWidget *_parent )
{
	m_parent = _parent;
	m_preset_title = i18n( "default" );

	m_url1 = "";
	m_url2 = "";
	m_regex_contains = "*";
	m_regex_containsnot = "";
	m_size_selection = 0; // 0 = none, 1 = at least, 2 = at most, 3 = equal to.
	m_size = 0; // spin box content
	m_size_multiple = 1; // 0 = bytes, 1 = KB, 2 = MB
	m_modified_or_created = 0; // 0 = any, 1 = between, 2 = during the last
	m_date1.setDate( QDate::currentDate() );
	m_date2.setDate( QDate::currentDate() );
	m_date3_num = 0;
	m_modified_last = 0; // 0 = minutes, 1 = hours, 2 = days, 3 = months, 4 = years
	m_ignore_empty = true;
	m_size_comparison = true;
	m_md5_sum = true;
	m_binary_comparison = false;
	m_binary_comparison_size = 10; // in MB
	m_empty_folders = false;
	m_include_subfolders = true;
	m_include_hidden_items = true;
	m_use_locate = false;
	m_case_sensitive = true;
	m_soft_links = false;
	m_enable_duplicates_search = true;
	m_enable_missing_search = true;
	m_enable_newer_search = true;
	m_reference_folder_left = true;
	int i;
	for ( i=0; i<24; i++ ) m_filter_string.push_back( "" ); // name, path, owner, group from duplicates1, 2, missing1, 2, newer1, 2.
	for ( i=0; i<56; i++ ) m_filter_int.push_back( 0 ); // All other entries. Bool is 1 or 0, Date is Year, Month, Day.
	// set correct default values now:
	m_filter_int[2] = 9999; // duplicates1: 0..9
	m_filter_int[3] = 2;
	m_filter_int[5] = QDate::currentDate().year();
	m_filter_int[6] = QDate::currentDate().month();
	m_filter_int[7] = QDate::currentDate().day();
	m_filter_int[8] = 1;
	m_filter_int[9] = 1;
	m_filter_int[12] = 9999; // duplicates2: 10..17
	m_filter_int[13] = 2;
	m_filter_int[15] = QDate::currentDate().year();
	m_filter_int[16] = QDate::currentDate().month();
	m_filter_int[17] = QDate::currentDate().day();
	m_filter_int[20] = 9999; // missing1: 18..25
	m_filter_int[21] = 2;
	m_filter_int[23] = QDate::currentDate().year();
	m_filter_int[24] = QDate::currentDate().month();
	m_filter_int[25] = QDate::currentDate().day();
	m_filter_int[28] = 9999; // missing2: 26..33
	m_filter_int[29] = 2;
	m_filter_int[31] = QDate::currentDate().year();
	m_filter_int[32] = QDate::currentDate().month();
	m_filter_int[33] = QDate::currentDate().day();
	m_filter_int[36] = 9999; // newer1: 34..44
	m_filter_int[37] = 2;
	m_filter_int[39] = QDate::currentDate().year();
	m_filter_int[40] = QDate::currentDate().month();
	m_filter_int[41] = QDate::currentDate().day();
	m_filter_int[42] = 1;
	m_filter_int[43] = 1;
	m_filter_int[44] = 1;
	m_filter_int[47] = 9999; // newer2: 45..55
	m_filter_int[48] = 2;
	m_filter_int[50] = QDate::currentDate().year();
	m_filter_int[51] = QDate::currentDate().month();
	m_filter_int[52] = QDate::currentDate().day();
	m_filter_int[53] = 1;
	m_filter_int[54] = 1;
	m_filter_int[55] = 1;
}

QString KomparatorPreset::title()
{
	return m_preset_title;
}

bool KomparatorPreset::readConfig( uint preset_number )
{
	KConfig *conf = KGlobal::config();

	if ( !conf ) return false;
	// This allows to create a KomparatorPreset, loadConfig and if it fails, the preset before was the last one.
	if ( !conf->hasGroup( QString( "Preset%1" ).arg( preset_number ) ) ) return false;

	conf->setGroup( QString( "Preset%1" ).arg( preset_number ) );

	// Read the entries
	m_preset_title = conf->readEntry( "preset_title" );
	m_url1 = KURL::fromPathOrURL( conf->readEntry( "url1" ) );
	m_url2 = KURL::fromPathOrURL( conf->readEntry( "url2" ) );
	m_regex_contains = conf->readEntry( "regex_contains" );
	m_regex_containsnot = conf->readEntry( "regex_containsnot" );
	m_size_selection = conf->readNumEntry( "size_selection" ); // 0 = none, 1 = at least, 2 = at most, 3 = equal to.
	m_size = conf->readUnsignedLongNumEntry( "size" ); // spin box content
	m_size_multiple = conf->readUnsignedNumEntry( "size_multiple" ); // 0 = bytes, 1 = KB, 2 = MB
	m_modified_or_created = conf->readUnsignedNumEntry( "modified_or_created" ); // 0 = any, 1 = between, 2 = during the last
	m_date1 = conf->readDateTimeEntry( "date1" );
	m_date2 = conf->readDateTimeEntry( "date2" );
	m_date3_num = conf->readUnsignedNumEntry( "date3_num" );
	m_modified_last = conf->readUnsignedNumEntry( "modified_last" ); // 0 = minutes, 1 = hours, 2 = days, 3 = months, 4 = years
	m_ignore_empty = conf->readBoolEntry( "ignore_empty" );
	m_size_comparison = conf->readBoolEntry( "size_comparison" );
	m_md5_sum = conf->readBoolEntry( "md5_sum" );
	m_binary_comparison = conf->readBoolEntry( "binary_comparison" );
	m_binary_comparison_size = conf->readUnsignedNumEntry( "binary_comparison_size" ); // in MB
	m_empty_folders = conf->readBoolEntry( "empty_folders" );
	m_include_subfolders = conf->readBoolEntry( "include_subfolders" );
	m_include_hidden_items = conf->readBoolEntry( "include_hidden_items" );
	m_use_locate = conf->readBoolEntry( "use_locate" );
	m_case_sensitive = conf->readBoolEntry( "case_sensitive" );
	m_soft_links = conf->readBoolEntry( "soft_links" );
	m_enable_duplicates_search = conf->readBoolEntry( "enable_duplicates_search" );
	m_enable_missing_search = conf->readBoolEntry( "enable_missing_search" );
	m_enable_newer_search = conf->readBoolEntry( "enable_newer_search" );
	m_reference_folder_left = conf->readBoolEntry( "reference_folder_left" );
	m_filter_string = conf->readListEntry( "filter_string" );
	m_filter_int = conf->readIntListEntry( "filter_int" );

	// Sanity check for values
	if ( m_regex_contains.isEmpty() ) m_regex_contains = "*";
	if ( m_size_selection > 3 ) m_size_selection = 0;
	if ( m_size_multiple > 2 ) m_size_multiple = 0;
	if ( m_modified_or_created > 2 ) m_modified_or_created = 0;
	if ( m_modified_last > 4 ) m_modified_last = 0;

	return true;
}

bool KomparatorPreset::saveConfig( uint preset_number )
{
	KConfig *conf = KGlobal::config();

	if ( !conf ) return false;

	conf->setGroup( QString( "Preset%1" ).arg( preset_number ) );

	conf->writeEntry( "preset_title", m_preset_title );
	conf->writeEntry( "url1", m_url1.pathOrURL() );
	conf->writeEntry( "url2", m_url2.pathOrURL() );
	conf->writeEntry( "regex_contains", m_regex_contains );
	conf->writeEntry( "regex_containsnot", m_regex_containsnot );
	conf->writeEntry( "size_selection", m_size_selection );
	conf->writeEntry( "size", m_size );
	conf->writeEntry( "size_multiple", m_size_multiple );
	conf->writeEntry( "modified_or_created", m_modified_or_created );
	conf->writeEntry( "date1", m_date1 );
	conf->writeEntry( "date2", m_date2 );
	conf->writeEntry( "date3_num", m_date3_num );
	conf->writeEntry( "modified_last", m_modified_last );
	conf->writeEntry( "ignore_empty", m_ignore_empty );
	conf->writeEntry( "size_comparison", m_size_comparison );
	conf->writeEntry( "md5_sum", m_md5_sum );
	conf->writeEntry( "binary_comparison", m_binary_comparison );
	conf->writeEntry( "binary_comparison_size", m_binary_comparison_size );
	conf->writeEntry( "empty_folders", m_empty_folders );
	conf->writeEntry( "include_subfolders", m_include_subfolders );
	conf->writeEntry( "include_hidden_items", m_include_hidden_items );
	conf->writeEntry( "use_locate", m_use_locate );
	conf->writeEntry( "case_sensitive", m_case_sensitive );
	conf->writeEntry( "soft_links", m_soft_links );
	conf->writeEntry( "enable_duplicates_search", m_enable_duplicates_search );
	conf->writeEntry( "enable_missing_search", m_enable_missing_search );
	conf->writeEntry( "enable_newer_search", m_enable_newer_search );
	conf->writeEntry( "reference_folder_left", m_reference_folder_left );
	conf->writeEntry( "filter_string", m_filter_string );
	conf->writeEntry( "filter_int", m_filter_int );

	return true;
}

bool KomparatorPreset::readFromInterface( bool reread )
{
	KDialogBase *ask_name_dialog = new KDialogBase( m_parent, "ask_name_dialog", true, i18n( "Add preset" ), KDialogBase::Ok | KDialogBase::Cancel );

	QVBox *page = ask_name_dialog->makeVBoxMainWidget();

	QLabel *preset_label = new QLabel( i18n( "Name of your new preset:" ), (QWidget*)page, "preset_label" );
	QLineEdit *preset_title_LineEdit = new QLineEdit( "", (QWidget*)page, "preset_title_LineEdit" );
	if ( reread )
	{
		preset_label->setText( i18n( "Name of your preset:" ) );
		preset_title_LineEdit->setReadOnly( true );
		preset_title_LineEdit->setText( title() );
	}
	preset_title_LineEdit->setMinimumWidth( ask_name_dialog->fontMetrics().maxWidth()*20 );

	QLabel *url1_label = new QLabel( i18n( "Left URL:" ), (QWidget*)page, "url1_label" );
	KURL url_show = KURL::fromPathOrURL( m_parent->url1_KURLRequester->url() ).prettyURL( -1 ); // no such function as "pathOrURL( int trailing )"!
	QLineEdit *url1_LineEdit = new QLineEdit( url_show.pathOrURL(), (QWidget*)page, "url1_LineEdit" );
	url1_LineEdit->setMinimumWidth( ask_name_dialog->fontMetrics().maxWidth()*20 );
	if ( reread )
	{
		url1_label->setText( url1_label->text() + " (" + i18n( "Old URL:" ) + " \"" + m_url1.pathOrURL() + "\" )" );
	}

	QLabel *url2_label = new QLabel( i18n( "Right URL:" ), (QWidget*)page, "url2_label" );
	url_show = KURL::fromPathOrURL( m_parent->url2_KURLRequester->url() ).prettyURL( -1 ); // no such function as "pathOrURL( int trailing )"!
	QLineEdit *url2_LineEdit = new QLineEdit( url_show.pathOrURL(), (QWidget*)page, "url2_LineEdit" );
	url2_LineEdit->setMinimumWidth( ask_name_dialog->fontMetrics().maxWidth()*20 );
	if ( reread )
	{
		url2_label->setText( url2_label->text() + " (" + i18n( "Old URL:" ) + " \"" + m_url2.pathOrURL() + "\" )" );
	}

	if ( ask_name_dialog->exec() == QDialog::Rejected )
	{
		delete ask_name_dialog;
		ask_name_dialog = NULL;
		return false;
	}

	m_preset_title = preset_title_LineEdit->text();
	m_url1 = KURL::fromPathOrURL( url1_LineEdit->text() );
	m_url2 = KURL::fromPathOrURL( url2_LineEdit->text() );

	delete ask_name_dialog;
	ask_name_dialog = NULL;

	// Set entries from interface
	m_regex_contains = m_parent->regexContains_KLineEdit->text();
	m_regex_containsnot = m_parent->regexContainsNot_KLineEdit->text();
	m_size_selection = m_parent->size_KComboBox->currentItem(); // 0 = none, 1 = at least, 2 = at most, 3 = equal to.
	m_size = m_parent->bytes_KIntNumInput->value(); // spin box content
	m_size_multiple = m_parent->bytes_KComboBox->currentItem(); // 0 = bytes, 1 = KB, 2 = MB
	m_modified_or_created = m_parent->modifiedNoRestriction_RadioButton->isChecked() ? 0 :
												( m_parent->modifiedBetween_RadioButton->isChecked() ? 1 : 2 ); // 0 = any, 1 = between, 2 = during the last
	QDate *tmp_date = new QDate;
	m_date1 = m_parent->modifiedFrom_KDateCombo->getDate( tmp_date );
	m_date2 = m_parent->modifiedTo_KDateCombo->getDate( tmp_date );
	m_date3_num = m_parent->modifiedLastTime_KIntNumInput->value();
	m_modified_last = m_parent->modifiedLastTime_KComboBox->currentItem(); // 0 = minutes, 1 = hours, 2 = days, 3 = months, 4 = years
	m_ignore_empty = m_parent->ignoreEmptyFiles_CheckBox->isChecked();
	m_size_comparison = m_parent->size_CheckBox->isChecked();
	m_md5_sum = m_parent->calculateChecksum_CheckBox->isChecked();
	m_binary_comparison = m_parent->binaryComparison_CheckBox->isChecked();
	m_binary_comparison_size = m_parent->binaryComparison_KIntSpinBox->value(); // in MB
	m_empty_folders = m_parent->findEmptyFolders_CheckBox->isChecked();
	m_include_subfolders = m_parent->includeSubfolders_CheckBox->isChecked();
	m_include_hidden_items = m_parent->includeHiddenItems_CheckBox->isChecked();
	m_use_locate = m_parent->useFilesIndex_CheckBox->isChecked();
	m_case_sensitive = m_parent->caseSensitiveSearch_CheckBox->isChecked();
	m_soft_links = m_parent->followSoftLinks_CheckBox->isChecked();
	m_enable_duplicates_search = m_parent->isEnabled( DUPLICATES );
	m_enable_missing_search = m_parent->isEnabled( MISSING );
	m_enable_newer_search = m_parent->isEnabled( NEWER );
	m_reference_folder_left = m_parent->duplicatesReference1_RadioButton->isChecked();

	QStringList string_list;
	string_list = m_parent->duplicates1_KomparatorFileFilter->getStringList() + m_parent->duplicates2_KomparatorFileFilter->getStringList() +
		m_parent->missing1_KomparatorFileFilter->getStringList() + m_parent->missing2_KomparatorFileFilter->getStringList() +
		m_parent->newer1_KomparatorFileFilter->getStringList() + m_parent->newer2_KomparatorFileFilter->getStringList();
	m_filter_string = string_list;

	QValueList<int> int_list;
	int_list = m_parent->duplicates1_KomparatorFileFilter->getIntList() + m_parent->duplicates2_KomparatorFileFilter->getIntList() +
		m_parent->missing1_KomparatorFileFilter->getIntList() + m_parent->missing2_KomparatorFileFilter->getIntList() +
		m_parent->newer1_KomparatorFileFilter->getIntList() + m_parent->newer2_KomparatorFileFilter->getIntList();
	m_filter_int = int_list;

	return true;
}

void KomparatorPreset::setToInterface()
{
	// Set the entries in the GUI
	if ( !m_url1.isEmpty() ) m_parent->url1_KURLRequester->setKURL( m_url1 );
	if ( !m_url2.isEmpty() ) m_parent->url2_KURLRequester->setKURL( m_url2 );
	m_parent->regexContains_KLineEdit->setText( m_regex_contains );
	m_parent->regexContainsNot_KLineEdit->setText( m_regex_containsnot );
	m_parent->size_KComboBox->setCurrentItem( m_size_selection );
	m_parent->bytes_KIntNumInput->setValue( m_size );
	m_parent->bytes_KComboBox->setCurrentItem( m_size_multiple );
	m_parent->modifiedNoRestriction_RadioButton->setChecked( ( m_modified_or_created == 0 ) ? true : false );
	m_parent->modifiedBetween_RadioButton->setChecked( ( m_modified_or_created == 1 ) ? true : false );
	m_parent->modifiedLastTime_RadioButton->setChecked( ( m_modified_or_created == 2 ) ? true : false );
	m_parent->modifiedFrom_KDateCombo->setDate( m_date1.date() );
	m_parent->modifiedTo_KDateCombo->setDate( m_date2.date() );
	m_parent->modifiedLastTime_KIntNumInput->setValue( m_date3_num );
	m_parent->modifiedLastTime_KComboBox->setCurrentItem( m_modified_last );
	m_parent->ignoreEmptyFiles_CheckBox->setChecked( m_ignore_empty );
	m_parent->size_CheckBox->setChecked( m_size_comparison );
	m_parent->calculateChecksum_CheckBox->setChecked( m_md5_sum );
	m_parent->binaryComparison_CheckBox->setChecked( m_binary_comparison );
	m_parent->binaryComparison_KIntSpinBox->setValue( m_binary_comparison_size );
	m_parent->findEmptyFolders_CheckBox->setChecked( m_empty_folders );
	m_parent->includeSubfolders_CheckBox->setChecked( m_include_subfolders );
	m_parent->includeHiddenItems_CheckBox->setChecked( m_include_hidden_items );
	m_parent->useFilesIndex_CheckBox->setChecked( m_use_locate );
	m_parent->caseSensitiveSearch_CheckBox->setChecked( m_case_sensitive );
	m_parent->followSoftLinks_CheckBox->setChecked( m_soft_links );
	m_parent->main_TabWidget->setTabIconSet( m_parent->main_TabWidget->page( 0 ),
		KGlobal::iconLoader()->loadIconSet( m_enable_duplicates_search ? "ok" : "no", KIcon::Toolbar, KIcon::SizeSmall ) );
	m_parent->main_TabWidget->setTabIconSet( m_parent->main_TabWidget->page( 1 ),
		KGlobal::iconLoader()->loadIconSet( m_enable_missing_search ? "ok" : "no", KIcon::Toolbar, KIcon::SizeSmall ) );
	m_parent->main_TabWidget->setTabIconSet( m_parent->main_TabWidget->page( 2 ),
		KGlobal::iconLoader()->loadIconSet( m_enable_newer_search ? "ok" : "no", KIcon::Toolbar, KIcon::SizeSmall ) );
	m_parent->duplicatesReference1_RadioButton->setChecked( m_reference_folder_left );
	m_parent->duplicatesReference2_RadioButton->setChecked( !m_reference_folder_left );

	if ( m_filter_string.size() == 24 )
	{
		QStringList string_list;
		string_list << m_filter_string[0] << m_filter_string[1] << m_filter_string[2] << m_filter_string[3];
		m_parent->duplicates1_KomparatorFileFilter->setStringList( string_list );
		string_list.clear();
		string_list << m_filter_string[4] << m_filter_string[5] << m_filter_string[6] << m_filter_string[7];
		m_parent->duplicates2_KomparatorFileFilter->setStringList( string_list );
		string_list.clear();
		string_list << m_filter_string[8] << m_filter_string[9] << m_filter_string[10] << m_filter_string[11];
		m_parent->missing1_KomparatorFileFilter->setStringList( string_list );
		string_list.clear();
		string_list << m_filter_string[12] << m_filter_string[13] << m_filter_string[14] << m_filter_string[15];
		m_parent->missing2_KomparatorFileFilter->setStringList( string_list );
		string_list.clear();
		string_list << m_filter_string[16] << m_filter_string[17] << m_filter_string[18] << m_filter_string[19];
		m_parent->newer1_KomparatorFileFilter->setStringList( string_list );
		string_list.clear();
		string_list << m_filter_string[20] << m_filter_string[21] << m_filter_string[22] << m_filter_string[23];
		m_parent->newer2_KomparatorFileFilter->setStringList( string_list );
	}

	if ( m_filter_int.size() == 56 )
	{
		QValueList<int> int_list;
		int_list << m_filter_int[0] << m_filter_int[1] << m_filter_int[2] << m_filter_int[3] << m_filter_int[4] <<
			m_filter_int[5] << m_filter_int[6] << m_filter_int[7] << m_filter_int[8] << m_filter_int[9];
		m_parent->duplicates1_KomparatorFileFilter->setIntList( int_list );
		int_list.clear();
		int_list << m_filter_int[10] << m_filter_int[11] << m_filter_int[12] << m_filter_int[13] << m_filter_int[14] <<
			m_filter_int[15] << m_filter_int[16] << m_filter_int[17];
		m_parent->duplicates2_KomparatorFileFilter->setIntList( int_list );
		int_list.clear();
		int_list << m_filter_int[18] << m_filter_int[19] << m_filter_int[20] << m_filter_int[21] << m_filter_int[22] <<
			m_filter_int[23] << m_filter_int[24] << m_filter_int[25];
		m_parent->missing1_KomparatorFileFilter->setIntList( int_list );
		int_list.clear();
		int_list << m_filter_int[26] << m_filter_int[27] << m_filter_int[28] << m_filter_int[29] << m_filter_int[30] <<
			m_filter_int[31] << m_filter_int[32] << m_filter_int[33];
		m_parent->missing2_KomparatorFileFilter->setIntList( int_list );
		int_list.clear();
		int_list << m_filter_int[34] << m_filter_int[35] << m_filter_int[36] << m_filter_int[37] << m_filter_int[38] <<
			m_filter_int[39] << m_filter_int[40] << m_filter_int[41] << m_filter_int[42] << m_filter_int[43] << m_filter_int[44];
		m_parent->newer1_KomparatorFileFilter->setIntList( int_list );
		int_list.clear();
		int_list << m_filter_int[45] << m_filter_int[46] << m_filter_int[47] << m_filter_int[48] << m_filter_int[49] <<
			m_filter_int[50] << m_filter_int[51] << m_filter_int[52] << m_filter_int[53] << m_filter_int[54] << m_filter_int[55];
		m_parent->newer2_KomparatorFileFilter->setIntList( int_list );
	}
}
