/***************************************************************************
                          sendmessage.cpp  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kdebug.h>

#include "sendmessage.h"

SendMessage::SendMessage (QObject * parent, const QString & the_netname,
			  const QString & the_message):
QObject (parent)
{
  proc = 0;
  out = "";
  err = "";
  netname = the_netname;
  message = the_message;
}

SendMessage::~SendMessage ()
{
}

/** Startet den mount-Process */
void
SendMessage::start ()
{
  proc = new KProcess ();
  kdDebug (7199) << "smbclient -M" << netname << endl;
  (*proc) << "smbclient" << "-M" << netname;
  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)),
	   SLOT (slotStdout (KProcess *, char *, int)));
  connect (proc, SIGNAL (receivedStderr (KProcess *, char *, int)),
	   SLOT (slotStderr (KProcess *, char *, int)));
  connect (proc, SIGNAL (wroteStdin (KProcess *)), this,
	   SLOT (slotWritten (KProcess *)));
  proc->start (KProcess::NotifyOnExit, KProcess::All);
  QCString s = message.local8Bit ();
  proc->writeStdin (s, s.length ());
}

/* Ausgaben werden Abgefangen */
void
SendMessage::slotStdout (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  out += b;
}

/* Ausgaben werden Abgefangen */
void
SendMessage::slotStderr (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  err += b;
  kdDebug (7199) << "sendMessage-errorstream :" << b << endl;
}

/** Wird aufgerufen wenn der Process sich beendet */
void
SendMessage::onProcExit (KProcess * killedproc)
{
  if (killedproc == proc)
    {
      delete proc;
      proc = 0;
    }
  else
    kdWarning (7199) << "sendMessage : Mmmhhh... not my process" << endl;
  if (out.contains ("Unable to resolve name"))
    err += out;
  emit isExited (this, err);
}

void
SendMessage::slotWritten (KProcess * p)
{
  p->closeStdin ();
}
