/***************************************************************************
                          komba2doc.h  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOMBA2DOC_H
#define KOMBA2DOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qstack.h>
#include "myktreelistitem.h"
#include "options.h"

// forward declaration of the Komba2 classes
class Komba2View;
class SendMessage;
class DebugOutput;
/**	Komba2Doc provides a document object for a document-view model.
  *
  * The Komba2Doc class provides a document object that can be used in conjunction with the classes Komba2App and Komba2View
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the Komba2App instance and contains the document structure with the according methods for manipulation of the document
  * data by Komba2View objects. Also, Komba2Doc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KURL;
class Mount;
class Unmount;
class IPLook;
class scan;
class smbConfig;
class MyMaster;
class QListViewItem;
class DebugOutput;
class Socketserver;


class Komba2Doc:public QObject
{
Q_OBJECT public:
  enum CommandOptions
  { optNothing = 0, optMount, optUnmount };
    /** Constructor for the fileclass of the application */
    Komba2Doc (QWidget * parent, const char *name = 0, int option =
	       optNothing);
    /** Destructor for the fileclass of the application */
   ~Komba2Doc ();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
  void addView (Komba2View * view);
    /** removes a view from the list of currently connected views */
  void removeView (Komba2View * view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified (bool _m = true)
  {
    modified = _m;
  };
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified ()
  {
    return modified;
  };
    /** "save modified" - asks the user for saving if the document is modified */
  bool saveModified ();
    /** initializes the document generally */
  bool newDocument ();
    /** closes the acutal document */
  void closeDocument ();
  void toggleAskForPassword ();
  // returns the NetworkItem (first Item in Viewtree)
  MyNetworkItem *getNetwork ()
  {
    return doc_net;
  };
  // looks for a IP of given host
  void LookForIP (MyHostItem * host);
  // scan a host for shares, ohter hosts and workgroups
  void scanHost (MyHostItem * host);

  void searchItem (QListViewItem * item, bool rescan = false);
  // search all Child (only usefull for network and wg)
  void scanAllChilds (QListViewItem * item);
  bool setPassword (QListViewItem * item);
  bool isCommandOptToUnmount ();
  bool isCommandOptToMount ();
	/***************************************************************************
 	 * this mounts the share											 											 			 *
	 ***************************************************************************/
  void Sharemount (MyShareItem * share, bool explore = true, QString dir =
		   QString::null);
	/***************************************************************************
 	 * this mounts the share											 											 			 *
	 ***************************************************************************/
  void Shareumount (MyShareItem * share);
  QString getmountpoint (QString nmb_name, QString sharename);
  bool look_for_mounted_Shares (MyShareItem * share);
  void explore (const char *path);
  void explore ();
  Options *options ()
  {
    return opt;
  };
	/** Mount the selected Share */
  void mountAktShare (bool specPath = false);
	/** Unmount the selected Share */
  void unmountAktShare ();
  /* set Password and Username if stored in options */
  void setOptionsAccount (QListViewItem * item);
  void setAccount ();
  void rescan ();
  void sendMessage ();
  /* try's to send a message to every host in workgroup */
  void sendMessage (MyWorkgroupItem * wg, const QString txtmessage);

  void ping ();
  void traceroute ();
  void emitItemRemoved (QListViewItem * item);
  bool hasOpenProcesses ();
  void initRecentHosts ();
  void setViewSizes (QValueList < int >i);
  QValueList < int >getViewSizes ();
  bool UnmountAll (bool action = false);

  void MountAll ();
  /*  Method allUnmounted
   *      return  true if UnmountAll was used
   */
  bool allUnmounted ();
  public slots:
  /** it send a netbiosmessage (message) to a netbiosname (netname) */
  void sendMessage (const QString & netname, const QString & message);
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
  void slotUpdateAllViews (Komba2View * sender);

  void InsertShare (const QString & host, const QString & workgroup,
		    const QString & share, const QString & comment,
		    MyShareItem::ShareTypes sharetyp);
  void InsertHost (const QString & hostname, const QString & workgroup,
		   const QString & comment, u_long ip, const QString & os,
		   const QString & server);
  void InsertHost (char *hostname, char *workgroup, u_long ip, bool ismaster =
		   false);
  void InsertWorkgroup (const QString & workgroup, const QString & master,
			bool issearched);
  void slotPingIsClosed (DebugOutput * p);
  protected slots:
	/***************************************************************************
	 * this deletes the object																					       *
	 ***************************************************************************/
  void mymasterIsExited (MyMaster * m);
	/***************************************************************************
	 * this deletes the object																					       *
	 ***************************************************************************/
  void iplookIsExited (IPLook * m);
	/***************************************************************************
 	 * Mymaster was found, now search it with smbclient 											 *
	 ***************************************************************************/
  void mymasterFound (const QString & name, const QString & workgroup,
		      ulong ip);
	/***************************************************************************
	 * slot for errorhandling when smbmount exit												       *
	 ***************************************************************************/
  void slotMountIsExited (Mount * m, QString & err, MyShareItem * share);
  void slotUnmountIsExited (Unmount * m, QString & err, MyShareItem * share);
  void slotSendMessageIsExited (SendMessage * sm, QString err);
  void socketserverIsExited (Socketserver * s);
  void scannet ();
  void initPrefHosts ();
  void slotNoProcess ();
public:
    /** the list of the views currently connected to the document */
  static QList < Komba2View > *pViewList;

private:
    /** the modified flag of the current document */
  bool modified;
  MyNetworkItem *doc_net;

  smbConfig *smbconf;
  MyMaster *mymaster;
  scan *scanhost;
  Options *opt;
  bool allunmounted;
  QStack < MyHostItem > *ipltodolist;
  int iplworkingcount;
  int unmountcount;
  int socketservercount;
  int mountcount;
  int comOpt;
signals:
  /** send a signal if share is unmounted correctly */
  void isUnmounted (MyShareItem * share);
  /** send a signal, if share is mounted correctly */
  void isMounted (MyShareItem * share);
  void itemRemoved (QListViewItem * item);
  void noActiveProcess ();
};


#endif // KOMBA2DOC_H
