/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef FORM_DESCRIPTION_H
#define FORM_DESCRIPTION_H

#include <QtCore/QStringList>

namespace Form
{

class Description
{
  public:

    class Entry
    {
      public:
        typedef QList<Entry> List;

        enum Type
        {
          EntryType,
          GroupType
        };

        Entry( Type type = EntryType );

        void setName( const QString &name );
        QString name() const;

        void setType( const QString &type );
        QString type() const;

        void setValidator( const QString &validator );
        QString validator() const;

        void setLabel( const QString &label );
        QString label() const;

        void setHeader( const QString &header );
        QString header() const;

        void setComment( const QString &comment );
        QString comment() const;

        void setDefaultValue( const QString &value );
        QString defaultValue() const;

        bool isGroup() const;

      private:
        QString mName;
        QString mType;
        QString mValidator;
        QString mLabel;
        QString mHeader;
        QString mComment;
        QString mDefaultValue;
        Type mEntryType;
    };

    Description();
    virtual ~Description();

    /**
     * Returns the list of field descriptions.
     */
    virtual Entry::List entries() const;
};

}

#endif
