/* -*- Mode: C++ -*-

  $Id: KDChartHiLoPainter.h,v 1.3.2.1 2001/12/08 12:15:40 khz Exp $

  KDChart - a multi-platform charting engine

  Copyright (C) 2001 by Klarlvdalens Datakonsult AB
*/

#ifndef __KDCHARTHILOPAINTER_H__
#define __KDCHARTHILOPAINTER_H__

#include "KDChartAxesPainter.h"
#include <KDChartTable.h>

#include <qnamespace.h>

class KDChartParams;

class KDChartHiLoPainter : public KDChartAxesPainter, public Qt
{
    friend class KDChartPainter;
protected:
    KDChartHiLoPainter( KDChartParams* params );
    virtual ~KDChartHiLoPainter();

    virtual void paintData( QPainter* painter, KDChartTableData* data,
                            bool paint2nd,
                            KDChartDataRegionList* regions );

    virtual QString fallbackLegendText( uint dataset ) const;
    virtual uint numLegendFallbackTexts( KDChartTableData* data ) const;
};

#endif
