h30657
s 00030/00037/00562
d D 1.38 00/08/26 19:52:48 nitehawk 39 38
c convert all logging calls into logmsg
cC
cK08933
e
s 00005/00010/00594
d D 1.37 00/08/22 20:03:47 nitehawk 38 37
c Converting to new logmsg
cC
cHlocalhost.1ststep.net
cK10119
e
s 00011/00009/00593
d D 1.36 00/05/07 08:36:18 nitehawk 37 36
c Change IPv6 definitions to AFINDEP
cC
cK18510
cZ-07:00
e
s 00000/00000/00602
d D 1.35 00/03/07 11:48:13 nitehawk 36 35
c Turn on SCCS flag
cC
cK00871
cX0xa1
e
s 00000/00000/00602
d D 1.34 00/02/12 10:06:28 nitehawk 35 34
c Rename: lib/network.c -> lib/koala/network.c
cC
cK09809
cPlib/koala/network.c
e
s 00000/00000/00602
d D 1.33 00/02/07 23:57:06 nitehawk 34 33
c Rename: src/network.c -> lib/network.c
cC
cK12766
cPlib/network.c
e
s 00014/00003/00588
d D 1.32 00/02/05 16:54:45 nitehawk 33 32
c netread closes connection on reading EOF
cC
cK06494
e
s 00010/00009/00581
d D 1.31 00/02/05 15:58:17 nitehawk 32 31
c Close socket on error from read or write
cC
cK64450
e
s 00006/00000/00584
d D 1.30 00/02/04 21:27:38 nitehawk 31 30
c netread can now handle nonblocking sockets correctly (handles EAGAIN)
cC
cK64562
e
s 00000/00002/00584
d D 1.29 00/02/04 11:27:10 nitehawk 30 29
c Put sockets in non-block mode while in debug mode
cC
cK60141
e
s 00119/00030/00467
d D 1.28 00/02/04 10:27:40 nitehawk 29 28
c Split netlisten into IP6 version and IP4 version - Flow is now significantly
c different making usage of #ifdefs inside the function painful
cC
cK61461
e
s 00001/00001/00496
d D 1.27 00/02/04 01:25:53 nitehawk 28 27
c Slight fix to IP6-disabled code
cC
cK27153
e
s 00004/00003/00493
d D 1.26 00/01/23 20:39:34 nitehawk 27 26
c Converting descriptor memory allocation to use new functions
cC
cK26271
e
s 00008/00000/00488
d D 1.25 00/01/20 21:32:37 nitehawk 26 25
c null terminate buffer in netread if there is room on the buffer
cC
cK23201
e
s 00012/00000/00476
d D 1.24 00/01/20 09:32:18 nitehawk 25 24
c Lookup hostname information in netuplink
cC
cK10153
e
s 00001/00003/00475
d D 1.23 00/01/20 09:20:36 nitehawk 24 23
c Removed initializers for 'close' member of descriptor
c error in read now sets status
cK44850
e
s 00012/00000/00466
d D 1.22 00/01/19 23:18:43 nitehawk 23 22
c Initialed 'close' to false everywhere that new descriptors are handled
c Setup netread to mark a descriptor for close if there
c is an error reading on it.
cK48673
e
s 00027/00006/00439
d D 1.21 00/01/19 23:11:53 nitehawk 22 21
c netaccept is now IP6 portable
c netaccept looks up hostname and stores it in the descriptor structure
c (IP6 only)
cK29986
e
s 00042/00026/00403
d D 1.20 00/01/18 13:32:10 nitehawk 21 20
c Converted to usage of getaddrinfo for IPv6 enabled
c machines.  All AF_INET code is in one branch and will
c be purged at such a time as IPv4 machines become pointless
c to support
cC
cK44594
e
s 00005/00002/00424
d D 1.19 00/01/17 23:55:24 nitehawk 20 19
c Two small touchups - error connecting does not mean
c   refusal to run, protocol negotiation handled in
c   uplinkprotocol.c.
cK07859
e
s 00037/00005/00389
d D 1.18 00/01/16 18:18:59 nitehawk 19 18
c Plugged memory leak in netaccept
c Setup status and type of newly accepted connection
c Added netread function
cC
cK60504
e
s 00002/00002/00392
d D 1.17 00/01/11 12:27:33 nitehawk 18 17
c Converted RCS tags to SCCS tags
cC
cK13587
e
s 00004/00004/00390
d D 1.16 00/01/09 17:59:46 nitehawk 17 16
c Remove pointer assignements for next and prev
cC
cHwinghove.1ststep.net
cK20030
cZ-08:00
e
s 00037/00001/00357
d D 1.15 00/01/02 23:21:02 nitehawk 16 15
c IPV6 portability fixed with uplink code and new listen bind code
cC
cHparanor.1ststep.net
cK19674
cZ+00:00
e
s 00002/00001/00356
d D 1.14 00/01/01 16:32:29 nitehawk 15 14
c Fix small bug with specific bind paramerter
cC
cK14379
e
s 00033/00007/00324
d D 1.13 00/01/01 12:52:40 nitehawk 14 13
c Convert uplink and listen to use address and port in
c function call
cK11009
e
s 00008/00003/00323
d D 1.12 99/12/29 21:32:45 nitehawk 13 12
c Finished portability work
cC
cK36333
e
s 00065/00035/00261
d D 1.11 99/12/29 20:59:33 nitehawk 12 11
c netuplink converted to be portable across systems
cK28526
cZ-08:00
e
s 00001/00000/00295
d D 1.10 99/12/21 17:37:00 nitehawk 11 10
c patched small memory leak in netuplink
cC
cK21114
e
s 00052/00002/00243
d D 1.9 99/12/20 07:59:47 nitehawk 10 9
c Uplink creation working - Protocol negotiation pending
cC
cK19496
e
s 00035/00002/00210
d D 1.8 99/12/19 17:55:39 nitehawk 9 8
c Added uplink magic creation.
cC
cK28980
e
s 00014/00005/00198
d D 1.7 99/12/15 01:44:19 nitehawk 8 7
c Adding startup function
c Moving Socket listen code to 'netlisten'
c Fixing non-block bug
cC
cK18780
e
s 00013/00007/00190
d D 1.6 99/12/15 00:00:52 nitehawk 7 6
c Added netuplink function - currently empty
cC
cK09562
e
s 00016/00002/00181
d D 1.5 99/12/15 00:00:16 nitehawk 6 5
c Added configure option for IP6 support
cK62871
e
s 00059/00002/00124
d D 1.4 99/12/14 05:46:04 nitehawk 5 4
c Added close and write functions
c Added accept function
cC
cK41557
e
s 00013/00004/00113
d D 1.3 99/12/14 05:45:32 nitehawk 4 3
c Adding logging
cK02724
e
s 00071/00010/00046
d D 1.2 99/12/14 05:44:44 nitehawk 3 2
c Added full startup and option setting functions
cK45297
e
s 00056/00000/00000
d D 1.1 99/12/14 05:44:10 nitehawk 2 1
cF1
cK40204
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 99/12/14 05:44:10 nitehawk 1 0
c BitKeeper file /home/nitehawk/src/koalamud/src/network.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK50942
cPsrc/network.c
cR9cd20af346835bb8
cV3
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 3
/* $Id: network.c,v 1.1 1999/11/23 06:07:40 nitehawk Exp $ */
E 3
I 3
D 4
/* $Id: network.c,v 1.2 1999/11/25 06:20:13 nitehawk Exp $ */
E 4
I 4
D 5
/* $Id: network.c,v 1.3 1999/11/27 07:34:17 nitehawk Exp $ */
E 5
I 5
D 6
/* $Id: network.c,v 1.4 1999/12/04 04:25:09 nitehawk Exp $ */
E 6
I 6
D 7
/* $Id: network.c,v 1.5 1999/12/08 00:28:31 nitehawk Exp $ */
E 7
I 7
D 18
/* $Id: network.c,v 1.6 1999/12/08 05:12:03 nitehawk Exp $ */
E 18
I 18
/* %Z% %M% %I% %Z% */
E 18
E 7
E 6
E 5
E 4
E 3
/***************************************************************\
D 7
*	Copyright (c) 1999 First Step Internet Services, Inc.	*
*		All Rights Reserved				*
*	Distributed under the BSD Licenese			*
*								*
*	Module: NETWORK						*
E 7
I 7
D 22
*	Copyright (c) 1999 First Step Internet Services, Inc.
E 22
I 22
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
E 22
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: NETWORK
E 7
\***************************************************************/

D 3
#define _KOALAMUD_CLISRVNETWORK_C "$Id: network.c,v 1.1 1999/11/23 06:07:40 nitehawk Exp $"
E 3
I 3
D 4
#define _KOALAMUD_CLISRVNETWORK_C "$Id: network.c,v 1.2 1999/11/25 06:20:13 nitehawk Exp $"
E 4
I 4
D 5
#define _KOALAMUD_CLISRVNETWORK_C "$Id: network.c,v 1.3 1999/11/27 07:34:17 nitehawk Exp $"
E 5
I 5
D 6
#define _KOALAMUD_CLISRVNETWORK_C "$Id: network.c,v 1.4 1999/12/04 04:25:09 nitehawk Exp $"
E 6
I 6
D 7
#define _KOALAMUD_CLISRVNETWORK_C "$Id: network.c,v 1.5 1999/12/08 00:28:31 nitehawk Exp $"
E 7
I 7
D 18
#define _KOALAMUD_NETWORK_C "$Id: network.c,v 1.6 1999/12/08 05:12:03 nitehawk Exp $"
E 18
I 18
#define _KOALAMUD_NETWORK_C "%Z% %K% %Z%"
E 18
E 7
E 6
E 5
E 4
E 3

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
I 27
#include "memory.h"
E 27
#include "network.h"
I 4
#include "log.h"
I 29
#include "llist.h"
E 29
E 4

I 9
/* module local prototypes */
daemonmagic magic;
koalaerror netcreatemagic(void);
E 9
I 8

E 8
/* netstartup
I 8
 * 	Startup networking
 */
koalaerror netstartup(void)
{
D 9
		return KESUCCESS;
E 9
I 9
	netcreatemagic();
	return KESUCCESS;
E 9
}

/* netlisten
E 8
 *    Startup network listen sockets
 *    Returns negative on error.
 *    Returns listen socket on success
 */
I 29
D 37
/* IP6 Version */
#if IPV6
/* With IP6 code, we can create more then one descriptor. */
E 37
I 37
/* AF Independant Version */
#if AFINDEP
/* With the AF Independant code, we can create more then one descriptor.  This
 *	happens when IPv6 is enabled and configured on the system
 */
E 37
koalaerror netlisten(listnodeptr list, char *bindaddr, int port)
{
D 39
	char errbuff[80];
E 39
	struct addrinfo hints, *res, *tmp;
	char portstr[PORTSTRLEN];
	pdescriptor desc = NULL;
	int socketcount = 0;
	int error = 0;
	char *name = NULL;  // If bindaddr is not any, we will point there before
						// doing the lookups
	
	if (!list)
	{
D 39
		logerr("Caught NULL list pointer!");
E 39
I 39
		logmsg(LOGERR, "Caught NULL list pointer!");
E 39
		return -KEMISSINGARG;
	}
E 29

D 8
int netstartup(descriptor *desc, int port)
E 8
I 8
D 14
koalaerror netlisten(descriptor *desc, int port)
E 14
I 14
D 29
koalaerror netlisten(descriptor *desc, char *bindaddr, int port)
E 29
I 29
	/* Prepare hints struct */
	memset(&(hints), 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_flags = AI_PASSIVE;
	hints.ai_socktype = SOCK_STREAM;

	if (bindaddr != NULL)
	{
		/* If the addr is *not* any, resolve it */
		if (strcasecmp(bindaddr, "any"))
		{
			name = bindaddr;
		}
	}

	/* Get a string version of the port */
	snprintf(portstr, PORTSTRLEN, "%d", port);

	/* Get address information */
	if ((error = getaddrinfo(name, portstr, &hints, &res)) != 0)
	{
D 39
		logerr("Error looking up address info");
E 39
I 39
		logmsg(LOGERR, "Error looking up address info");
E 39
		return KEBIND;
	}

	/* Now we need to loop through the 'res' list and bind and listen */
	tmp = res;	// Need to hold the head pointer to free later 
	while(tmp)
	{
		/* Allocate memory for new descriptor */
		if ((desc = allocdescriptor()) == NULL)
		{
D 39
			logerr("Unable to allocate memory for descriptor");
E 39
I 39
			logmsg(LOGCRIT, "Unable to allocate memory for descriptor");
E 39
			return KENOMEM;
		}
		desc->type = DESCRIPTOR_LISTEN;

		/* Create listen socket */
		desc->socket = socket(tmp->ai_family, tmp->ai_socktype,
				tmp->ai_protocol);
		if (desc->socket == -1)
		{
D 39
			sprintf(errbuff, "Error %d creating listen socket", errno);
			logerr(errbuff);
E 39
I 39
			logmsg(LOGERR, "Error %d creating listen socket", errno);
E 39
			return -KENOPROTO;
		}

		ksetsocketopts(desc->socket);

		/* Bind to the ip6 addresses */
		if (bind(desc->socket, tmp->ai_addr, tmp->ai_addrlen) < 0)
		{
D 39
			logerr("Error binding port");
E 39
I 39
			logmsg(LOGERR, "Error binding port");
E 39
			close(desc->socket);
			return -KEBIND;
		}

		/* Start listening */
		listen(desc->socket, LISTENBACKQUEUE);

		/* Add the descriptor to the list */
		listaddnode(list, desc);
		
		/* We have another listener */
		socketcount++;
		
		/* Move to the next ai struct */
		tmp = tmp->ai_next;
	}

D 38
	sprintf(errbuff, "Daemon now listening with %d sockets on port %d",
			socketcount, port);
	logmsg(errbuff);
E 38
I 38
	logmsg(LOGINFO, "Daemon now listening with %d sockets on port %d",
		socketcount, port);
E 38

	freeaddrinfo(res);
	
	return desc->socket;
}
D 37
#else /* Non-IP6 version */
E 37
I 37
#else /* Non-AF Independant version */
E 37
koalaerror netlisten(listnodeptr list, char *bindaddr, int port)
E 29
E 14
E 8
{
I 4
D 39
	char errbuff[80];
E 39
E 4
	struct protoent *protoentry = NULL;
I 14
	struct hostent *hp = NULL;
E 14
I 6
D 29
#if IPV6
E 6
D 3
	struct sockaddr_in addr;
E 3
I 3
	struct sockaddr_in6 addr;
I 6
#else
E 29
	struct sockaddr_in addr;
D 29
#endif
E 29
I 29
	pdescriptor desc;
E 29
E 6
E 3
	
D 29
	if (!desc)
E 29
I 29
	if (!list)
E 29
	{
I 4
D 29
		logerr("Caught NULL descriptor pointer!");
E 29
I 29
D 39
		logerr("Caught NULL list pointer!");
E 39
I 39
		logmsg(LOGERR, "Caught NULL list pointer!");
E 39
E 29
E 4
		return -KEMISSINGARG;
	}

I 29
	/* Allocate memory */
	if ((desc = allocdescriptor()) == NULL)
	{
D 39
		logerr("Unable to allocate memory for descriptor");
E 39
I 39
		logmsg(LOGCRIT, "Unable to allocate memory for descriptor");
E 39
		return KENOMEM;
	}

E 29
	desc->type = DESCRIPTOR_LISTEN;
D 29
	desc->socket = 0;
E 29

	/* Get Protocol information */
	if ((protoentry = getprotobyname("tcp")) == NULL)
	{
D 3
		printf("No IP6 support, Attempting IP4\n");
		/* Must not have IP6 support - Try setting up tcp only */
		if ((protoentry = getprotobyname("ipv6")) == NULL)
		{
			/* No protocol information available - Time to die */
			return -KENOPROTO;
		}
E 3
I 3
		/* No protocol information available - Time to die */
I 4
D 39
		logerr("Unable to get tcp protocol information");
E 39
I 39
		logmsg(LOGCRIT, "Unable to get tcp protocol information");
E 39
E 4
		return -KENOPROTO;
E 3
	}

	/* Create listen socket */
I 6
D 29
#if IPV6
E 6
	desc->socket = socket(AF_INET6, SOCK_STREAM, protoentry->p_proto);
I 6
#else
E 29
	desc->socket = socket(AF_INET, SOCK_STREAM, protoentry->p_proto);
D 29
#endif
E 29
E 6
	if (desc->socket == -1)
	{
D 4
		printf("Error %d creating listen socket\n", errno);
E 4
I 4
D 39
		sprintf(errbuff, "Error %d creating listen socket", errno);
		logerr(errbuff);
E 39
I 39
		logmsg(LOGERR, "Error %d creating listen socket", errno);
E 39
E 4
		return -KENOPROTO;
	}
I 3

	ksetsocketopts(desc->socket);

I 6
D 29
#if IPV6
E 6
	addr.sin6_family = AF_INET6;
	addr.sin6_port = htons(port);
	memset(&(addr.sin6_addr), 0, sizeof(addr.sin6_addr));
I 6
#else
E 29
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = htons(INADDR_ANY);
D 29
#endif
E 29
I 14

	if (bindaddr != NULL)
	{
D 15
		if (!strcasecmp(bindaddr, "any"))
E 15
I 15
		/* If the addr is *not* any, resolve it */
		if (strcasecmp(bindaddr, "any"))
E 15
		{
I 16
D 29
#if IPV6
			inet_pton(AF_INET6, bindaddr, (void *)&addr.sin6_addr);
			if ((addr.sin6_addr.s6_addr[5] & 0xffffffff) == 0xffffffff) {
#else
E 29
E 16
			addr.sin_addr.s_addr = inet_addr(bindaddr);
			if ((addr.sin_addr.s_addr & 0xffffffff) == 0xffffffff) {
I 16
D 29
#endif
E 29
E 16
				/* Resolve hostname to the ipaddress */
				hp = gethostbyname(bindaddr);
				if (!hp)
				{
D 39
					logerr("Unable to lookup hostname");
E 39
I 39
					logmsg(LOGERR, "Unable to lookup hostname");
E 39
I 29
					close(desc->socket);
					freedescriptor(desc);
E 29
					return -KENOHOST;
				}
				if (!hp->h_addr_list[0]) {
D 39
					logerr("Host has no addresses");
E 39
I 39
					logmsg(LOGERR, "Host has no addresses");
E 39
I 29
					close(desc->socket);
					freedescriptor(desc);
E 29
					return -KENOHOST;
				}

				/* Set the address to connect to */
I 16
D 29
#if IPV6
				addr.sin6_family = hp->h_addrtype;
				memcpy(&addr.sin6_addr, hp->h_addr_list[0],
						sizeof(addr.sin6_addr));
#else
E 29
E 16
				addr.sin_family = hp->h_addrtype;
				memcpy(&addr.sin_addr, hp->h_addr_list[0],
						sizeof(addr.sin_addr));
I 16
D 29
#endif
E 16

E 29
			}
		}
	}
E 14
E 6
	
	/* Bind to the ip6 addresses */
D 13
	if (bind(desc->socket, &addr, sizeof(addr)) < 0)
E 13
I 13
	if (bind(desc->socket, (struct sockaddr *)&addr, sizeof(addr)) < 0)
E 13
	{
I 4
D 39
		logerr("Error binding port");
E 39
I 39
		logmsg(LOGERR, "Error binding port");
E 39
E 4
		close(desc->socket);
I 29
		freedescriptor(desc);
E 29
		return -KEBIND;
	}

	listen(desc->socket, 5);
I 4

D 38
	sprintf(errbuff, "Daemon now listening on port %d", port);
	logmsg(errbuff);
E 38
I 38
	logmsg(LOGINFO, "Daemon now listening on port %d", port);
E 38
E 4
	
I 29
	/* Add descriptor to list */
	listaddnode(list, desc);

E 29
	return desc->socket;
}
I 29
#endif /* netlisten versions */
E 29

D 8
/* setsocketopts
E 8
I 8
/* ksetsocketopts
E 8
 *	Set socket options for a network socket
 */
D 8
int ksetsocketopts(int sock)
E 8
I 8
koalaerror ksetsocketopts(int sock)
E 8
{
#ifdef SO_LINGER
	// Turn off linger
	{
		struct linger l;
		l.l_onoff = 0;
		l.l_linger = 0;

		setsockopt(sock, SOL_SOCKET, SO_LINGER, &l, sizeof(l));
	}
#endif

I 31
#if GONONBLOCK
E 31
I 9
D 30
#if (!DEBUG)
E 30
E 9
#if HAVE_FCNTL_H
#ifndef O_NONBLOCK
#ifdef O_NDELAY
#define O_NONBLOCK O_NDELAY
I 8
#endif
#endif
E 8
	{
		int sockflags;
		int result;

		sockflags = fcntl(sock, F_GETFL, 0);

		sockflags |= O_NONBLOCK;

		result = fcntl(sock, F_SETFL, sockflags);
		if (result == -1)
		{
D 4
			// logmsg("Error switching socket to Non-Blocking");
E 4
I 4
D 39
			logerr("Error switching socket to Non-Blocking");
E 39
I 39
			logmsg(LOGCRIT, "Error switching socket to Non-Blocking");
E 39
E 4
		}
	}
D 8
#endif
#endif
E 8
D 30
#endif
E 30
I 9
#endif
I 31
#endif
E 31
E 9

#ifdef SO_REUSEADDR
	{
		int optval = 1;
		setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &optval,
				sizeof(optval));
	}
#endif

I 5
	return KESUCCESS;
}

/* Accept new connection to server */
koalaerror netaccept(pdescriptor desc, pdescriptor *newconnection)
{
I 13
D 37
#if IPV6
E 37
I 37
#if AFINDEP
E 37
E 13
D 22
	struct sockaddr_in6 addr;
E 22
I 22
	struct sockaddr_storage addr;
	char portstr[PORTSTRLEN];
E 22
D 13
        socklen_t addrlen;
E 13
I 13
#else
	struct sockaddr_in addr;
I 22
	char *addrbuffer;
E 22
#endif
D 22
	int addrlen = sizeof(addr);
E 22
I 22
	size_t addrlen = sizeof(addr);
D 38
	char logbuf[MAXLOGLINELEN];
E 38
E 22
E 13

D 27
	*newconnection = malloc(sizeof(descriptor));
E 27
I 27
	*newconnection = allocdescriptor();
E 27
	if (*newconnection == NULL)
	{
D 39
		logerr("Error allocating new descriptor");
E 39
I 39
		logmsg(LOGCRIT, "Error allocating new descriptor");
E 39
		return KENOMEM;
	}

D 13
	(*newconnection)->socket = accept(desc->socket, &addr, &addrlen);
E 13
I 13
D 22
	(*newconnection)->socket = accept(desc->socket, (struct sockaddr *)&addr,
			&addrlen);
E 22
I 22
	(*newconnection)->socket = accept(desc->socket,
			(struct sockaddr *)&(addr),
			&(addrlen));
E 22
E 13
	if ((*newconnection)->socket < 0)
	{
D 39
		logerr("Error accepting connection");
E 39
I 39
		logmsg(LOGERR, "Error accepting connection");
E 39
I 19
D 27
		free(newconnection);
E 27
I 27
		freedescriptor(*newconnection);
E 27
E 19
		return KENOACCEPT;
	}

	ksetsocketopts((*newconnection)->socket);

D 22
	logmsg("Accepted new connection");
E 22
I 22
D 37
#if IPV6
E 37
I 37
#if AFINDEP
E 37
	getnameinfo((struct sockaddr *)&addr, addrlen, (*newconnection)->hostname,
			MAXHOSTNAMELEN, portstr, PORTSTRLEN, NI_NUMERICSERV);
#else
	addrbuffer = inet_ntoa(addr.sin_addr);
	strncpy((*newconnection)->hostname, addrbuffer,
			MAXHOSTNAMELEN > strlen(addrbuffer) ? MAXHOSTNAMELEN :
			strlen(addrbuffer));
I 25
	free(addrbuffer);
E 25
#endif

D 38
	snprintf(logbuf, MAXLOGLINELEN, "Accepted new connection from %s",
E 38
I 38
	logmsg(LOGINFO, "Accepted new connection from %s",
E 38
			(*newconnection)->hostname);

D 38
	logmsg(logbuf);
E 22

E 38
D 19
	/* Link new connection into the list */
D 17
	(*newconnection)->next = desc;
E 17
I 17
	/*(*newconnection)->next = desc;
E 17
	(*newconnection)->prev = desc->prev;
	desc->prev = (*newconnection);
D 17
	(*newconnection)->prev->next = (*newconnection);
E 17
I 17
	(*newconnection)->prev->next = (*newconnection);*/
E 19
I 19
	(*newconnection)->status = STATUS_CONNECTING;
	(*newconnection)->type = DESCRIPTOR_UNKNOWN;
I 23
D 24
	(*newconnection)->close = FALSE;
E 24
E 23
E 19
E 17

	return KESUCCESS;
}

/* Close an open descriptor */
koalaerror netclose(pdescriptor desc)
{
	/* Unlink the descriptor from the list */
D 17
	desc->prev->next = desc->next;
	desc->next->prev = desc->prev;
E 17
I 17
	/*desc->prev->next = desc->next;
	desc->next->prev = desc->prev;*/
E 17

	/* close the network socket */
	close(desc->socket);

D 27
	free(desc);
E 27
I 27
	freedescriptor(desc);
E 27

D 38
	logmsg("Closing connection");
E 38
I 38
	logmsg(LOGINFO, "Closing connection");
E 38

	return KESUCCESS;
}

I 19
/* netread -
 * 		Read data from the network
I 26
 * 		if the number read is less then the number available, we will append a
 * 		null terminator
E 26
 */
koalaerror netread(pdescriptor desc, char *buffer, unsigned int *len)
{
	int numread;

	/* Validate parameters */
	if (!desc || !buffer || !len)
	{
D 39
		logerr("Invalid pointer caught in netread");
E 39
I 39
		logmsg(LOGERR, "Invalid pointer caught in netread");
E 39
		return KEMISSINGARG;
	}

	if (desc->type == DESCRIPTOR_NULL || desc->type == DESCRIPTOR_DUMMY
			|| desc->type == DESCRIPTOR_LISTEN)
	{
D 39
		logerr("Cannot read from this descriptor type");
E 39
I 39
		logmsg(LOGERR, "Cannot read from this descriptor type");
E 39
		return KEBADDESCRIPTORTYPE;
	}

	numread = read(desc->socket, buffer, *len);
I 23
D 33
	if (numread < 0)
E 33
I 33
	if (numread == 0)
E 33
	{
D 33
		/* If there was an IO error, we just mark the socket to be closed in
		 * the next loop pass */
E 33
D 32
		if (errno == EIO || errno == EBADF)
		{
D 24
			desc->close = TRUE;
E 24
I 24
			desc->status = STATUS_CLOSE;
I 31
		}
		if (errno == EAGAIN)
		{
			numread = 0;
E 31
E 24
		}
E 32
I 32
		desc->status = STATUS_CLOSE;
I 33
	}
	if (numread < 0)
	{
		if (errno == EAGAIN)
		{
			numread = 0;
		}
		else
		{
			/* If there was an IO error, we just mark the socket to be closed in
			 * the next loop pass */
			desc->status = STATUS_CLOSE;
		}
E 33
E 32
I 26
	}

	if (numread < *len)
	{
		buffer[numread] = '\0';
		numread++;
E 26
	}

E 23
	*len = numread;
	
	return KESUCCESS;
}

E 19
/* Write data to a descriptor */
koalaerror netwrite(pdescriptor desc, char *data, unsigned int len)
{
I 32
	int retval;

E 32
I 19
	/* Validate parameters */
	if (!desc || !data)
	{
D 39
		logerr("Invalid pointer caught in netwrite");
E 39
I 39
		logmsg(LOGERR, "Invalid pointer caught in netwrite");
E 39
		return KEMISSINGARG;
	}

E 19
D 32
	write(desc->socket, data, len);
E 32
I 32
	retval = write(desc->socket, data, len);

	if (retval < 0)
	{
		desc->status = STATUS_CLOSE;
	}

E 32
I 7
	return KESUCCESS;
}

/* Build a connection to a hub or zone server */
D 9
koalaerror netuplink(pdescriptor uplink, const char *uplinkhost, int port)
E 9
I 9
D 14
koalaerror netuplink(pdescriptor uplink)
E 14
I 14
koalaerror netuplink(pdescriptor uplink, char *bindaddr, int port)
E 14
{
D 10
	daemonmagic	magic;
E 10
I 10
D 39
	char errbuff[80];
E 39
D 21
	struct protoent *protoentry = NULL;
E 21
I 16
D 37
#if IPV6
E 37
I 37
#if AFINDEP
E 37
D 21
	struct sockaddr_in6 hostaddr;
E 21
I 21
	struct addrinfo hints, *ai;
	char portstr[PORTSTRLEN];
E 21
#else
E 16
D 12
	struct addrinfo hints, *ai;
	char port[PORTSTRLEN], ntop[MAXHOSTNAMELEN];
E 12
I 12
	struct sockaddr_in hostaddr;
I 16
D 21
#endif
E 21
E 16
	struct hostent *hp = NULL;
I 21
	struct protoent *protoentry = NULL;
I 25
	char *namebuf;
E 25
#endif
E 21
E 12
E 10

I 10
	/* Make sure we got a pointer */
E 10
	if (uplink == NULL)
	{
D 39
		logerr("Caught null pointer in netuplink!");
E 39
I 39
		logmsg(LOGERR, "Caught null pointer in netuplink!");
E 39
		return -KEMISSINGARG;
	}

I 21
	/* Get address information */
D 37
#if IPV6
E 37
I 37
#if AFINDEP
E 37
	/* Separate the two versions of uplink code.  AF_INET specific code will
	 * be removed at a later date */
	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	snprintf(portstr, PORTSTRLEN, "%d", port);
	if (getaddrinfo(bindaddr, portstr, &hints, &ai) != 0)
	{
D 39
		logerr("Error getting address information, bail out.");
E 39
I 39
		logmsg(LOGERR, "Error getting address information, bail out.");
E 39
		return -KENOHOST;
	}

	/* Create a socket for the uplink */
	uplink->socket = socket(ai->ai_family, ai->ai_socktype, ai->ai_protocol);
	if (uplink->socket == -1)
	{
D 39
		sprintf(errbuff, "Error %d creating uplink socket", errno);
		logerr(errbuff);
E 39
I 39
		logmsg(LOGERR, "Error %d creating uplink socket", errno);
E 39
		return -KENOPROTO;
	}

	/* We have the socket - lets connect to our uplink */
	if (connect(uplink->socket, ai->ai_addr, ai->ai_addrlen) == -1)
	{
D 39
		logerr("Error connecting to uplink");
E 39
I 39
		logmsg(LOGERR, "Error connecting to uplink");
E 39
		close(uplink->socket);
		return -KENOUPLINK;
	}

I 25
	/* Get hostname and port information */
	getnameinfo(ai->ai_addr, ai->ai_addrlen, uplink->hostname, MAXHOSTNAMELEN,
			portstr, PORTSTRLEN, NI_NUMERICSERV);
	uplink->port = atoi(portstr);

E 25
	/* Make sure we don't leak memory */
	freeaddrinfo(ai);

D 37
#else /* IPV6 not enabled */
E 37
I 37
#else /* AF Independant code not enabled */
E 37
E 21
D 10
	logmsg(magic.daemonmagic);
E 10
I 10
	/* Get Protocol information */
	if ((protoentry = getprotobyname("tcp")) == NULL)
	{
		/* No protocol information available - Time to die */
D 39
		logerr("Unable to get tcp protocol information");
E 39
I 39
		logmsg(LOGCRIT, "Unable to get tcp protocol information");
E 39
		return -KENOPROTO;
	}

D 21
	/* Get address information */
E 21
D 12
	memset(&hints, 0, sizeof(hints));
#if IPV6
	hints.ai_family = AF_UNSPEC;
#else
	hints.ai_family = AF_INET;
#endif
	hints.ai_socktype = SOCK_STREAM;
	snprintf(port, PORTSTRLEN, "%d", koptions.uplinkopts.uplinkport);
	if (getaddrinfo(koptions.uplinkopts.uplinkhost, port, &hints, &ai) != 0)
	{
		logerr("Error in getaddrinfo - Aborting");
		return -KENOHOST;
	}
E 12
I 12
	memset(&hostaddr, 0, sizeof(hostaddr));
I 16
D 21
#if IPV6
	hostaddr.sin6_family = AF_INET6;
	hostaddr.sin6_port = htons(port);
	inet_pton(AF_INET6, bindaddr, hostaddr.sin6_addr.s6_addr);
	if ((hostaddr.sin6_addr.s6_addr[5] & 0xffffffff) != 0xffffffff) {
#else
E 21
E 16
	hostaddr.sin_family = AF_INET;
D 14
	hostaddr.sin_port = htons(koptions.uplinkopts.uplinkport);
	hostaddr.sin_addr.s_addr = inet_addr(koptions.uplinkopts.uplinkhost);
E 14
I 14
	hostaddr.sin_port = htons(port);
	hostaddr.sin_addr.s_addr = inet_addr(bindaddr);
E 14
D 21
	if ((hostaddr.sin_addr.s_addr & 0xffffffff) != 0xffffffff) {
I 16
#endif
E 21
I 21
	if ((hostaddr.sin_addr.s_addr & 0xffffffff) != 0xffffffff)
	{
E 21
E 16
		/* At this point, the addr struct should be fully populated */
		/* Create a socket to use for the uplink */
I 16
D 21
#if IPV6
		uplink->socket = socket(AF_INET6, SOCK_STREAM, protoentry->p_proto);
#else
E 21
E 16
		uplink->socket = socket(AF_INET, SOCK_STREAM, protoentry->p_proto);
I 16
D 21
#endif
E 21
E 16
		if (uplink->socket == -1)
		{
D 39
			sprintf(errbuff, "Error %d creating uplink socket", errno);
			logerr(errbuff);
E 39
I 39
			logmsg(LOGERR, "Error %d creating uplink socket", errno);
E 39
			return -KENOPROTO;
		}
E 12

D 12
	getnameinfo(ai->ai_addr, ai->ai_addrlen, ntop, sizeof(ntop),
					port, sizeof(port),
					NI_NUMERICHOST | NI_NUMERICSERV);
	
	/* At this point, the addr struct should be fully populated */
	/* Create a socket to use for the uplink */
	uplink->socket = socket(ai->ai_family, SOCK_STREAM, protoentry->p_proto);
	if (uplink->socket == -1)
	{
		sprintf(errbuff, "Error %d creating uplink socket", errno);
		logerr(errbuff);
		return -KENOPROTO;
E 12
I 12
		/* We have the socket - lets connect to our uplink */
		if (connect(uplink->socket, (struct sockaddr *)&hostaddr,
				 sizeof(hostaddr)) == -1)
		{
D 14
			perror("connect()");
E 14
D 39
			logerr("Error connecting to uplink - refusing to run disconnected");
E 39
I 39
			logmsg(LOGCRIT, "Error connecting to uplink -"
					" refusing to run disconnected");
E 39
			close(uplink->socket);
			return -KENOUPLINK;
		}
E 12
	}
D 12

	/* We have the socket - lets connect to our uplink */
	if (connect(uplink->socket, ai->ai_addr, ai->ai_addrlen) == -1)
E 12
I 12
	else
E 12
	{
D 12
		perror("connect()");
		logerr("Error connecting to uplink - refusing to run disconnected");
		close(uplink->socket);
		return KENOUPLINK;
E 12
I 12
		/* Resolve hostname to the ipaddress */
D 14
		hp = gethostbyname(koptions.uplinkopts.uplinkhost);
E 14
I 14
D 16
		hp = gethostbyname(bindaddr);
E 16
I 16
D 21
#if IPV6
		hp = gethostbyname2(bindaddr, AF_INET6);
#else
E 21
		hp = gethostbyname2(bindaddr, AF_INET);
D 21
#endif
E 21
E 16
E 14
		if (!hp)
		{
D 39
			logerr("Unable to lookup hostname");
E 39
I 39
			logmsg(LOGERR, "Unable to lookup hostname");
E 39
			close(uplink->socket);
			return -KENOUPLINK;
		}
		if (!hp->h_addr_list[0])
		{
D 39
			logerr("Host has no addresses");
E 39
I 39
			logmsg(LOGERR, "Host has no addresses");
E 39
			close(uplink->socket);
			return -KENOUPLINK;
		}

		/* Set the address to connect to */
I 16
D 21
#if IPV6
		hostaddr.sin6_family = hp->h_addrtype;
		memcpy(&hostaddr.sin6_addr, hp->h_addr_list[0],
				sizeof(hostaddr.sin6_addr));
#else
E 21
E 16
		hostaddr.sin_family = hp->h_addrtype;
		memcpy(&hostaddr.sin_addr, hp->h_addr_list[0],
				sizeof(hostaddr.sin_addr));
I 16
D 21
#endif
E 21
E 16

		/* At this point, the addr struct should be fully populated */
		/* Create a socket to use for the uplink */
		uplink->socket = socket(AF_INET, SOCK_STREAM, protoentry->p_proto);
		if (uplink->socket == -1)
		{
D 39
			sprintf(errbuff, "Error %d creating uplink socket", errno);
			logerr(errbuff);
E 39
I 39
			logmsg(LOGERR, "Error %d creating uplink socket", errno);
E 39
			return -KENOPROTO;
		}

		/* We have the socket - lets connect to our uplink */
		if (connect(uplink->socket, (struct sockaddr *)&hostaddr,
				 sizeof(hostaddr)) == -1)
		{
D 14
			perror("connect()");
E 14
D 20
			logerr("Error connecting to uplink - refusing to run disconnected");
E 20
I 20
D 39
			logerr("Error connecting to uplink");
E 39
I 39
			logmsg(LOGERR, "Error connecting to uplink");
E 39
E 20
			close(uplink->socket);
			return -KENOUPLINK;
		}
E 12
	}
I 25

	/* Get hostname and port information */
D 28
	namebuf = inet_ntoa(hostaddr);
E 28
I 28
	namebuf = inet_ntoa(hostaddr.sin_addr);
E 28
	strncpy(uplink->hostname, namebuf, MAXHOSTNAMELEN);
	free(namebuf);
E 25
I 21
#endif
I 22

	/* Set the type and status of the new uplink */
	uplink->type = DESCRIPTOR_UNKNOWN; 
	uplink->status = STATUS_CONNECTING;
I 23
D 24
	uplink->close = FALSE;
E 24
E 23
E 22
E 21
I 11
D 12
	freeaddrinfo(ai);
E 12
E 11

D 20
	/* Do protocol negotiation here */
E 20
I 20
	/* Now that the socket is connected, we leave it up to the daemon loop to
	 * make calls on partially connected uplinks to do the protocol
	 * negotiation as there is data on the socket.  See uplinkprotocol.c
	 */
E 20
E 10

	return KESUCCESS;
}

/* netcreatemagic -
 * 		This function creates 'magic' strings that are used during uplink
 * 		creation to determine the type of daemon that is connecting and to
 * 		ensure that the daemons are of compatible versions.  This function
 * 		should not be changed unless changes are made that invalidate the
 * 		linkage protocol.  If in doubt, ask Matthew first.
 */
koalaerror netcreatemagic(void)
E 9
{
I 9
	strncpy(magic.daemonmagic, "KOALA-PROTOCOL-101001-UPLINK", MAGICLEN);
	strncpy(magic.clientmagic, "KOALA-CLIENT-DAEMON-112412", MAGICLEN);
	strncpy(magic.zonemagic, "KOALA-ZONE-DAEMON-112412", MAGICLEN);
	strncpy(magic.hubmagic, "KOALA-HUB-DAEMON-112412", MAGICLEN);
	
E 9
E 7
E 5
	return KESUCCESS;
E 3
}
E 2
I 1
E 1
