/* @(#) .del-dbinternal.h 1.10 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: db
\***************************************************************/

#ifndef _KOALAMUD_LIB_DBINTERNAL_H
#define _KOALAMUD_LIB_DBINTERNAL_H "@(#) nitehawk@winghove.1ststep.net|BitKeeper/deleted/.del-dbinternal.h|20000308020900|17216 @(#)"

/* We need all the other database includes */
#include "lib/fstypes.h"
#include "lib/fs.h"
#include "lib/dnode.h"
#include "lib/dir.h"
#include "dbmem.h"

/* Memory tracking */
typedef struct TAG_DBMEMSTATE
{
	int				fd;			/* File descriptor */
	void *			chunkbase;	/* Base address of mapping */
	kdbfs_blockid_t	mapstart;	/* First block in the mapping */
	kdbfs_blockid_t	maplen;		/* Total blocks in this mapping */
	int				refcount;	/* Number of references to blocks in this map */
	struct TAG_DBMEMSTATE *next;/* Pointer to the next mapping block */
} dbmemstate_t;

/* Database state */
typedef struct TAG_DBSTATE
{
	int pagesize;
	pmountstat	mountlist;
	kvnode *	rootvnode;
	dbmemstate_t *dbmap;
	size_t	qmapped;
} dbstate_t;

extern dbstate_t dbstate;

/* In fs.c */
koalaerror zeroblock(int dbfd, kdbfs_blockid_t block);
kdbfs_blockid_t allocateblock(int dbfd, superblock *sb);

/* In dbmemops.c */
void *mmapblockaligned(int dbfd, kdbfs_blockid_t blockstart,
		kdbfs_blockid_t len);
void unmapfreeblocks(void);
void mapfree(void *blkaddr);
void closemapfile(int dbfd);

/* In dbfsmount.c */
void dbinitstate(void);

#endif
