<?php

$KNOWLEDGEROOTDB = 'PGSQL';

class db {
	var $connection = "";
	var $dbtype = "pgsql";

	function connect($host,$user,$pass,$db,$schema="public",$encoding="LATIN1") {
		$this->connection = pg_connect("host=$host dbname=$db user=$user password=$pass");
		$this->schema($schema);
		$this->set_client_encoding($enconding);
	}

	function close() {
		if(!pg_close($this->connection)) {
			print "Failed to close connection to " . pg_host($this->connection) . ": " . pg_last_error($this->connection) . "<br/>\n";
		} else {
			//print "Successfully disconnected from database";
		}
	}
	
	function schema($schema = "") {
		if($schema != "") {
			$res = $this->query("SET search_path TO ".$schema);
			return $res;
		}
		
		return 1;
	}

	function set_client_encoding($encoding = "") {
		if($encoding != "") {
			return pg_set_client_encoding($this->connection, $encoding);
		}
		
		return 0;
	}

	function query($query) {
		$res = pg_query($this->connection, $query);
		
		if(!$res) {
			echo $query;
		}
		
		return $res;
	}
	
	function num_rows($result) {
		$anz = pg_num_rows($result);
		return $anz;
	}
	
	function fetch_object($result) {
		$row = pg_fetch_object($result);
		return $row;
	}

	function fetch_row($result) {
		$row = pg_fetch_row($result);
		return $row;
	}

	function fetch_assoc($result) {
		$row = pg_fetch_assoc($result);
		return $row;
	}

	function affected_rows($result) {
		$anz = pg_affected_rows($this->connection, $result);
		return $anz;
	}

	function error() {
		return pg_last_error($this->connection);
	}
	
	function lo_open($oid,$mode) {
		return pg_lo_open($this->connection,$oid,$mode);
	}
	
	function lo_close($handle) {
		return pg_lo_close($handle);
	}
	
	function lo_read_all($handle) {
		return pg_lo_read_all($handle);
	}
	
	function lo_create() {
		return pg_lo_create($this->connection);
	}
	
	function lo_write($handle,$buffer) {
		return pg_lo_write($handle,$buffer);
	}
	
	function lo_unlink($oid) {
		return pg_lo_unlink($this->connection,$oid);
	}
	
	function last_id($name) {
		$res = $this->query("select last_value FROM $name");
		$row = $this->fetch_assoc($res);
		
		return $row['last_value'];
	}
}

?>
