// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.50 $
#include <hk_datasource.h>
#include <qbrush.h>
#include <hk_kdememo.h>
#include <hk_kdememo.moc>
#include <hk_form.h>
#include <klocale.h>
#include "hk_kdefinddialog.h"
#include <hk_dsgridcolumn.h>
#include <qcombobox.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qcheckbox.h>
#include <qtooltip.h>

hk_kdememo::hk_kdememo(QWidget* wid,hk_form* f):QTextEdit(wid,NULL), hk_dsmemo(f)
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug("hk_kdememo::constructor");
#endif
    has_changed=false;
    QObject::connect(this,SIGNAL(textChanged()),this,SLOT(slot_data_changed()));
    QObject::connect(this,SIGNAL(clicked(int,int)),this,SLOT(slot_mouse_clicked()));
    QObject::connect(this,SIGNAL(doubleClicked(int,int)),this,SLOT(slot_mouse_doubleclicked()));
    p_widget_specific_row_change=true;
    setEnabled(false);
    setTabChangesFocus(true);
    if (f!=NULL) setWordWrap(WidgetWidth);
    set_alignment(hk_dsmemo::alignment(),false);
    setTextFormat(PlainText);
    QColor qcolor=paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=palette().active().text();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);
    findpopupid=0;

    widget_specific_font_changed();
    p_widget_specific_row_change=false;
    p_finddialog=NULL;
}


hk_kdememo::~hk_kdememo()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::destructor");
#endif
   if (has_changed)before_store_changed_data();
}


void hk_kdememo::slot_data_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::slot_data_changed");
#endif
    if (!p_widget_specific_row_change)
    {
        has_changed=true;
/*	        if (column()!=NULL)
                   column()->set_asstring(text().local8Bit().data(),true,true);*/

    }
}


bool hk_kdememo::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::coordinates");
#endif
    blockSignals(true);
    setGeometry(px,py,pwidth,pheight);
    blockSignals(false);
    return true;
}


bool hk_kdememo::widget_specific_row_change(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::widget_specific_row_change");
#endif
    hk_column* c=column();
    p_widget_specific_row_change=true;
    if (c!=NULL)
    {
#ifdef HK_DEBUG
        hkdebug("hk_kdememo::widget_specific_row_change default");
#endif
        setText(QString::fromLocal8Bit (c->has_changed()?c->changed_data_asstring().c_str():c->asstring(true).c_str()));
    }

    p_widget_specific_row_change=false;
    has_changed=false;
    return true;
}


void hk_kdememo::widget_specific_enable_disable()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::widget_specific_enable_disable");
#endif
    if ((datasource()!=NULL)&&(column()!=NULL))
    {
#ifdef HK_DEBUG
        hkdebug("hk_kdememo::if ((datasource()!=NULL)&&(column()!=NULL))");
#endif
        bool r=p_widget_specific_row_change;
        p_widget_specific_row_change=true;
        if (datasource()->is_enabled()>0)
        {
            setEnabled(true);
            widget_specific_row_change();
        }
        else setEnabled(false);
        p_widget_specific_row_change=r;
    }
    else
    {
        if (p_presentation ) setEnabled(p_presentation->mode()==hk_presentation::viewmode);
	else
	setEnabled(true);
	if (datasource()&&!datasource()->is_enabled()) setEnabled(false);
        blockSignals(true);
        setText("");
        blockSignals(false);
    }
/*  if (p_presentation!=NULL) if (p_presentation->state()==hk_form::design)
 {
    setFocusPolicy(NoFocus);
    setEnabled(true);
  }
  else*/
    setFocusPolicy(StrongFocus);

}


bool hk_kdememo::datasource_disable()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::datasource_disable");
#endif
    bool erg=hk_dsdatavisible::datasource_disable();
    widget_specific_enable_disable();
    return erg;
}


bool hk_kdememo::datasource_enable()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::datasource_enable");
#endif
    bool erg=hk_dsdatavisible::datasource_enable();
    widget_specific_enable_disable();
    return erg;
}


void hk_kdememo::datasource_delete(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::datasource_delete");
#endif
    setText("");
    hk_dsdatavisible::datasource_delete();
    has_changed=false;
}


void hk_kdememo::before_row_change()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::datasource_before_row_change");
#endif
   hk_dsmemo::before_row_change();
    before_store_changed_data();

}


void hk_kdememo::before_store_changed_data()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdememo::datasource_before_store_changed_data");
#endif
    if ((!p_widget_specific_row_change)&&(has_changed))
    {
        if (column()!=NULL)
        {
            column()->set_asstring(text().local8Bit().data(),true,true);
            has_changed=false;
        }
    }
}


void hk_kdememo::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("kdememo::resizeEvent");
#endif
    QTextEdit::resizeEvent(event);
    reposition();

}


void  hk_kdememo::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kdememo::resizeEvent");
#endif
    QTextEdit::moveEvent(event);
    reposition();
}


void hk_kdememo::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kdememo::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QTextEdit::x()):QTextEdit::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QTextEdit::y()):QTextEdit::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QTextEdit::height()):QTextEdit::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QTextEdit::width()):QTextEdit::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}


void hk_kdememo::widget_specific_font_changed(void)
{
    setFont(QFont(QString::fromLocal8Bit (hk_dsmemo::font().fontname().c_str())
                  ,hk_dsmemo::font().fontsize(),hk_dsmemo::font().bold()?QFont::Bold:QFont::Normal,
		   hk_dsmemo::font().italic()));
}


void    hk_kdememo::widget_specific_insert_mode(void)
{
    blockSignals(true);
    setText(QString::fromLocal8Bit (use_defaultvalue()?defaultvalue().c_str():""));
    blockSignals(false);
}


void hk_kdememo::keyPressEvent( QKeyEvent * e )
{
   //p_while_keyaction=true;
    hk_key nk=hk_key(e->key(),e->state(),(e->text().isNull()?"":e->text().local8Bit().data()));
    hk_key* k=NULL;
    if (p_gridcolumn)
      {
         p_gridcolumn->set_key(nk);
	 p_gridcolumn->action_on_key();
	 k=p_gridcolumn->key();
      }
      else
      {
      
       set_key(nk);
       action_on_key();
       k=key();
       }
    if (!k->accept_key())
    {
      e->ignore();
      //p_while_keyaction=false;
      return;
    
    }
    
    
    

    if (column()==NULL)
    {
         QTextEdit::keyPressEvent(e);
         return;
    } 
    
    if (e->key()==Key_F && e->state()&ControlButton) find_clicked(findpopupid);
            else
        if (column()->is_readonly()||is_readonly())
        {
        switch (e->key())
          {
            case Key_Left:
            case Key_Right:
            case Key_Home:
            case Key_End:
            case Key_Return: break;
            default: return;
          }
        }
    
    if (e->key()==Key_Escape)
       {
         if (column() && column()->has_changed()) column()->reset_changed_data();
	 else
	 if (datasource() && datasource()->has_changed()) 
	 {
	    datasource()->reset_changed_data();
	    datasource()->store_changed_data();
	 }   
	 widget_specific_row_change();
	   
       }
    else  QTextEdit::keyPressEvent(e);
}


void hk_kdememo::widget_specific_row_added(void)
{
    widget_specific_row_change();
}


void hk_kdememo::widget_specific_row_deleted(void)
{
    widget_specific_row_change();
}


void hk_kdememo::widget_specific_alignment(void)
{
    Qt::AlignmentFlags f;
    switch (hk_dsmemo::alignment())
    {
        case alignright  : f= Qt::AlignRight;
        break;
        case aligncenter  : f= Qt::AlignHCenter;
        break;
        default       : f= Qt::AlignLeft;

    }
    setAlignment(f);
// cout <<" hk_kdememo::widget_specific_alignment "<<f<<endl;

}


void    hk_kdememo::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    QBrush brush;
    brush.setColor(newcolour);
    brush.setStyle(QBrush::SolidPattern);
    setPaper(brush);
}


void    hk_kdememo::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    hk_colour c=foregroundcolour();

    QColor newcolour(c.red(),c.green(),c.blue());
    setColor(newcolour);
}

void  hk_kdememo::slot_mouse_clicked()
{
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
          action_on_click();

}

void  hk_kdememo::slot_mouse_doubleclicked()
{
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
          action_on_doubleclick();

}

QPopupMenu* hk_kdememo::createPopupMenu(const QPoint& p)

{
    QPopupMenu* popup=QTextEdit::createPopupMenu(p);
    hk_column* c=column();
    if (c  && !c->is_readonly()&&!c->is_notnull())
    {
        findpopupid=popup->insertItem(i18n("Find"));
        popup->insertSeparator();
        NULLpopupid=popup->insertItem( i18n( "set 'NULL' value" ) ,CTRL+Key_0 );
        connect( popup, SIGNAL(activated(int)), SLOT(NULLselected(int)) );
        connect( popup, SIGNAL(activated(int)), SLOT(find_clicked(int)) );

    }

    return popup;

}


void hk_kdememo::find_clicked(int r)
{
#ifdef HK_DEBUG
    hkdebug("kdememo::find_clicked");
#endif
    if (!column()||findpopupid!=r) return;
    if (p_finddialog==NULL)
    {
        p_finddialog=new hk_kdefinddialog(this,0,false);
        connect(p_finddialog, SIGNAL(signal_findbutton_clicked()),this,SLOT(find_next()));
        connect(p_finddialog, SIGNAL(signal_findargument_changed()),this,SLOT(findargument_changed()));
    }

    p_findfirstview=true;
    findargument_changed();
    p_finddialog->show();
}


void    hk_kdememo::find_next(void)
{
#ifdef HK_DEBUG
    hkdebug("kdememo::find_next");
#endif
    bool search=true;
    if (p_finddialog==NULL)return;
    while (search)
    {
        if (p_finddialog->all_columnsbox->isChecked())
        {
            cout <<"noch nicht eingebaut"<<endl;
            search=false;
        }

        else
        {
            hk_column* c= column();
            if (c==NULL) return;
            unsigned int from=0;
            unsigned int to=0;
            if (p_finddialog->find_backwardsbox->isChecked())
            {

                from=0;
                to=((datasource()->row_position()>0)&&!p_findfirstview)?
                    datasource()->row_position()-1:
                (p_findfirstview?datasource()->row_position():datasource()->max_rows()-1);
            }
            else
            {
                from=((datasource()->row_position()<datasource()->max_rows()-2)&&!p_findfirstview)?
                    datasource()->row_position()+1:
                (p_findfirstview?datasource()->row_position():0);
                to=datasource()->max_rows()-1;
            }

            unsigned int r=c->find( from,
                to,
                p_finddialog->searchfield->currentText().local8Bit().data(),
                !p_finddialog->part_of_columnbox->isChecked(),
                p_finddialog->case_sensitivebox->isChecked(),
                p_finddialog->find_backwardsbox->isChecked()
                );
            if (r<datasource()->max_rows())
            {
                datasource()->goto_row(r);
                search=false;
            }
            else
            {
                if (!p_findfirstview)
                {
                    show_warningmessage(hk_translate("Not found."));
                    search=false;
                    return;
                }
                else
                {
                    datasource()->goto_first();
                }

            }
        }

        p_findfirstview=false;
    }

}


void hk_kdememo::findargument_changed(void)
{
    p_findfirstview=true;

}

void    hk_kdememo::NULLselected( int r )
{

    hk_column* c=column();
    if (c  && NULLpopupid==r)
    {
        c->set_asnullvalue();
        widget_specific_row_change();
    }

}




void hk_kdememo::set_value(const hk_string&v)
{
 hk_column* c=column();
 if (c)c->set_asstring(v);
 else setText(QString::fromLocal8Bit (v.c_str()));

}

hk_string hk_kdememo::value(void)
{
  if (!column()) return text().local8Bit().data();
  else return hk_dsmemo::value();
}


void	hk_kdememo::presentationmode_changed(void)
{
hk_dsmemo::presentationmode_changed();
if (!p_presentation) return;
if (p_presentation->mode()==hk_presentation::designmode)
   {
    setEnabled(false);
        blockSignals(true);
        setText("");
        blockSignals(false);
   }
 else
 {
   setEnabled(true);
 }

}

void  hk_kdememo::widget_specific_tooltip_changed(void)
{
 QToolTip::add(this,QString::fromLocal8Bit (tooltip().c_str()));
}




void hk_kdememo::focusInEvent ( QFocusEvent * e)
{
  action_on_getfocus();
  QTextEdit::focusInEvent(e);
}

void hk_kdememo::focusOutEvent ( QFocusEvent * e)
{
  action_on_loosefocus();
  QTextEdit::focusOutEvent(e);

}


