/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "devicestatdialog.h"
#include "querydev.h"
#include "knetdockif.h"

#include <kconfig.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>
#include <kaction.h>
#include <kapplication.h>
#include <kstdaccel.h>
#include <kiconloader.h>
#include <qlayout.h>

extern QueryDev *dev;

extern double getScaleString(const Q_ULLONG value, QString& c);

DeviceStatDialog::DeviceStatDialog(QWidget* parent, const char* name, WFlags fl)
: QWidget(parent,name,fl), dev_name(name)
{
	dock=0;
	
	alarms = new AlarmsDialog(0,dev_name);

	setCaption("Details: "+dev_name);


	//resize(510,240);
	QGridLayout *grid = new QGridLayout(this, 1,2, 10,10);

//     grid->setColStretch( 0, 2);
//     grid->setColStretch( 1, 1 );


	
	
	tabs = new QTabWidget(this);
	
	traffic_pane = new TrafficPane();
	tabs->addTab(traffic_pane, "Traffic");

	props_pane = new PropsPane();
	tabs->addTab(props_pane,"Properties");

	tabs->setMinimumSize(300,200);

	grid->addWidget(tabs,0,0);

	QVBoxLayout *vlay = new QVBoxLayout(this,10);
	QLabel *label = new QLabel(this);
	vlay->addWidget(label);

	c = new ChartFrame(5,this);
	c->resize(180,100);
	c->setMinimumSize(c->size());
	c->setMaximumSize(c->size());

	vlay->addWidget(c);
	s = new SpeedFrame(this);
	vlay->addWidget(s,Qt::AlignCenter);

	chkdock = new QCheckBox(this);
	chkdock->setText("Monitor in systray");
	chkdock->resize(180,20);
	//chkdock->move(c->x()+25,s->y()+s->height()+15);
	connect(chkdock, SIGNAL(toggled(bool)), this, SLOT(toggleDock(bool)));
	vlay->addWidget(chkdock);

	grid->addLayout(vlay,0,1);

	adjustSize();
	setMinimumSize(size());
	setMaximumSize(size());
	
	t = new QTimer(this);
	connect(t, SIGNAL(timeout()), this, SLOT(update()));
	t->start(1000);

}

DeviceStatDialog::~DeviceStatDialog()
{
	t->stop();
	if (alarms)delete alarms;
	alarms=0;
}
void DeviceStatDialog::toggleDock(bool mode)
{

	QString dev_name = name();

	showdock(mode);
	
	emit dockVisible(dev_name, mode);

}

void DeviceStatDialog::showdock(bool mode)
{

	if (mode)
	{
		if (!dock){
			dock = new DockIf(this,name());

			KConfig *cfg = kapp->config();
			cfg->setGroup(name());
			bool useChart =  cfg->readBoolEntry("useChart",false);
			bool useToolTip = cfg->readBoolEntry("useToolTip",false);
			dock->setUseChart(useChart);
			if (!useToolTip)dock->toggleTip();


			KPopupMenu *menu = dock->contextMenu();	
			
			dock->resize(24,24);
			dock->show();
			menu->clear();
			
			

			KHelpMenu *mHelpMenu = new KHelpMenu( dock, kapp->aboutData() );
			KPopupMenu *help = mHelpMenu->menu();
			
			connect(c, SIGNAL(chartStyleChange(int)),dock,SLOT(updateChartStyle(int)));


			menu->insertItem(UserIcon("if_ether"),"Show &all devices", 
				this, SLOT(showAllEmitter()));	
			menu->insertSeparator();
			menu->insertItem(QIconSet(SmallIcon("find")),"&Toggle details", 
				dock, SLOT(toggleActive()) );
			menu->insertItem(QIconSet(SmallIcon("fileclose")),"&Stop monitor", 
				this, SLOT(quitDock()));
			menu->insertSeparator();
		
			KPopupMenu *cnf = new KPopupMenu(dock);
			cnf->setCheckable(true);
			tipMenuID = cnf->insertItem( "Enable &tooltip",  this,  SLOT(toggleTip()) );
			cnf->setItemChecked(tipMenuID, dock->isTipEnabled());

			chartMenuID = cnf->insertItem("Use chart as dock icon",this,SLOT(toggleUseChart()));
			cnf->setItemChecked(chartMenuID, dock->isUseChart());		

			cnf->insertItem("Choose led color", dock, SLOT(chooseLedColor()));
	
		
			cnf->insertSeparator();
			cnf->insertItem("&Alarm",this,SLOT(alarmsConfig()));

			menu->insertItem(QIconSet(SmallIcon("configure")),"&Settings",cnf); 
			menu->insertSeparator();
			menu->insertItem(QIconSet(SmallIcon("help")),"&Help",help);
			
			menu->insertItem(QIconSet(SmallIcon("exit")),"&Quit", 
				this, SLOT (quitAllEmitter()), KStdAccel::quit());
			
		}
	}
	else {
		if (dock){
			dock->hide();
			delete dock;
			dock=0;
		}
	}
}
void DeviceStatDialog::hide()
{
	QWidget::hide();
	if (!dock) {
		emit removeDetails(dev_name);
	}
}


void DeviceStatDialog::update()
{
	if (!dev)return;

	KNetDockIf *nif	= dev->update(dev_name);
	if (!nif) return;
	
	Q_ULLONG in = nif->total.speed_in;
	Q_ULLONG out = nif->total.speed_out;
	c->appendValue(in,out);
	c->repaint();

	if (nif->useBPS)
		s->update(nif->total.speed*8,true);
	else
		s->update(nif->total.speed);
	
	traffic_pane->update(nif);
	props_pane->update(nif);

	alarms->update(nif);

	if (!dock) return;
	dock->update(nif);


}

bool DeviceStatDialog::isDockShown()
{
	if (dock) return true;
	else return false;
}

void DeviceStatDialog::quitDock()
{
	chkdock->setChecked(false);
	emit removeDetails(dev_name);
}

void DeviceStatDialog::showAllEmitter()
{
	emit showAllDevices();
}

void DeviceStatDialog::quitAllEmitter()
{
	emit quitAllDevices();
}

void DeviceStatDialog::toggleCheckbox(bool mode)
{
	chkdock->setChecked(mode);
}
void DeviceStatDialog::toggleTip()
{
	if (!dock)return;
	dock->toggleTip();
	bool useToolTip = dock->isTipEnabled();
	dock->contextMenu()->setItemChecked(tipMenuID, useToolTip);
	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	cfg->writeEntry("useToolTip",useToolTip);
	cfg->sync();
}

void DeviceStatDialog::toggleUseChart()
{
	if (!dock)return;
	bool useChart = !dock->contextMenu()->isItemChecked(chartMenuID);
	dock->contextMenu()->setItemChecked(chartMenuID,useChart);
	dock->setUseChart(useChart);
	dock->repaint();

	KConfig *cfg = kapp->config();
	cfg->setGroup(dev_name);
	cfg->writeEntry("useChart",useChart);
	cfg->sync();

}

void DeviceStatDialog::alarmsConfig()
{
	
	alarms->show();
}


