/***************************************************************************
                          napsterconnection.h  -  description
                             -------------------
    begin                : Sun Dec 5 1999
    copyright            : (C) 1999-2000 by jade
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NAPSTERCONNECTION_H
#define NAPSTERCONNECTION_H

/**
  *@author jade
  */

#include <iostream.h>
//#include <string>

#include <ksock.h>  // FIXME
#include <qobject.h>
#include <qlist.h>

//#include <sys/types.h>
//#include <netinet/in.h>
//#include <arpa/inet.h>


// check for endianism
#if __BYTE_ORDER == __LITTLE_ENDIAN
// i386 type
 #define NAP_TO_SHORT(x) (x)
 #define NAP_TO_LONG(x)  (x)
 #define SHORT_TO_NAP(x) (x)
 #define LONG_TO_NAP(x)  (x)
#else
 // PPC  etc
 #define FIX_S(x) ( ((x&0xFF)<<8) | (x>>8) )
 #define FIX_L(x) ( ((x&0xFF)<<24) | ((x&0xFF00)<<8) | ((x&0xFF0000)>>8) | (x>>24) )

 #define NAP_TO_SHORT(x) FIX_S(x)
 #define NAP_TO_LONG(x)  FIX_L(x)
 #define SHORT_TO_NAP(x) FIX_S(x)
 #define LONG_TO_NAP(x)  FIX_L(x)

#endif

// default server for besthost
#define SERVER_ADDR "server.napster.com" 
#define SERVER_PORT 8875

// server msg numbers
#define NAP_ERROR          0

#define NAP_LOGIN_REQ      2
#define NAP_LOGIN_RESULT   3
#define NAP_NEWUSERLOGIN_REQ  6
#define NAP_CREATEUSER_REQ 7
#define NAP_CREATEUSER_OK  8
#define NAP_CREATEUSER_ERROR 9    // couldn't create user
#define NAP_CREATEUSER_INVALIDNAME 10  // crap name given ie invalid chars & etc
#define NAP_ADDTOSONGLIST_REQ 100
//#define NAP_DELETEFROMSONGLIST_REQ 101

#define NAP_SEARCH_REQ     200
#define NAP_SEARCH_RESULT   201
#define NAP_SEARCH_COMPLETE 202

#define NAP_DOWNLOAD_REQ   203
#define NAP_DOWNLOAD_RESULT 204

#define NAP_USER_MSG  205  // used for both send and retrieve

#define NAP_DOWNLOAD_ERROR 206

#define NAP_ADDTOHOTLIST 207
#define NAP_HOTLISTUSER_LOGGEDON 209
#define NAP_HOTLISTUSER_LOGGEDOFF 210

#define NAP_BROWSE_ERROR   210 // NOTE: used also as hotlist user loggoff

#define NAP_BROWSE_REQ     211
#define NAP_BROWSE_RESULT   212
#define NAP_BROWSE_COMPLETE 213

// num files/songs etc on server
#define NAP_SERVER_STATS   214

#define NAP_DOWNLOAD_STARTED  218 // sent to notify the server
#define NAP_DOWNLOAD_FINISHED 219 // sent to notify the server

#define NAP_UPLOAD_STARTED  220 // sent to notify the server
#define NAP_UPLOAD_FINISHED 221 // sent to notify the server

#define NAP_ADDTOHOTLIST_RESULT 301
#define NAP_ADDTOHOTLIST_ERROR  302
#define NAP_DELETEFROMHOTLIST  303


#define NAP_IGNORELIST_REQ 320
#define NAP_IGNORELIST_RESULT 321
#define NAP_ADDTOIGNORELIST_REQ 322
#define NAP_REMOVEFROMIGNORELIST_REQ 323
#define NAP_IGNORELIST_NOTIGNORED 324
#define NAP_IGNORELIST_ALREADYIGNORED 325
#define NAP_IGNORELIST_CLEAR 326


#define NAP_JOINCHAN_REQ   400
#define NAP_PARTCHAN_REQ   401
#define NAP_SENDCHAN_MSG   402
#define NAP_CHAN_MSG       403

#define NAP_ERROR_MSG		 	 404

#define NAP_JOINCHAN_RESULT 405

#define NAP_CHAN_USERJOINED 406
#define NAP_CHAN_USERLEFT 407

#define NAP_CHAN_USERINFO 408

#define NAP_CHAN_USERINFO_COMPLETE 409

#define NAP_CHAN_TOPIC 410 // topik data?? also used to change the topic

#define NAP_ADVERTISMENT   425 // actually sent on connection to a channel

#define NAP_DOWNLOAD_REQ_NEW 500
#define NAP_UPLOAD_REQ_NEW 501    // some one has requested a song from us

#define NAP_WHOIS_REQ      603
#define NAP_WHOIS_RESULT   604
#define NAP_WHOIS_NOTLOGGEDON 605

// ** #define NAP_CHANGE_USER_LEVEL 606

#define NAP_UPLOAD_REQ     607
#define NAP_UPLOAD_ALLOWED 608

#define NAP_GET_ERROR 609

#define NAP_KILL_USER      610

#define NAP_BAN_USER   612
#define NAP_UNBAN_USER 614

#define NAP_BANLIST_REQ    615
#define NAP_BANLIST_RESULT 616


#define NAP_CHANLIST_REQ    617
#define NAP_CHANLIST_RESULT 618

// server can send this message back - same as NAP_CHANLIST_REQ
#define NAP_CHANLIST_COMPLETE 617

#define NAP_QUEUE_LIMIT     619

#define NAP_REMOTEQUEUEFULL 620
//#define NAP_NOT_CONNECTED  620 // ***** user not connected !!!!!!
                               // or is  206 the one??

#define NAP_OPSAY           627

#define NAP_GLOBALMSG       629 //TODO - implement send for this


#define NAP_SYSTEM_MSG     621

//** #define NAP_MUZZLE_USER  622
//** #define NAP_UNMUZZLE_USER  623


// ** #define NAP_CHANGE_SPEED 625
// ** #define NAP_PORT_ERROR 626

// ** #define NAP_HIDE_USER 652


#define NAP_ANOTHER_LOGIN  748

#define NAP_PING_REQ       751
#define NAP_PING_RESULT    752

// ** #define NAP_CHANGE_PASSWORD 753

#define NAP_SERVERVERSION_REQ 801

// TODO  #define NAP_CHANUSER_MSG     824
#define NAP_CHANACTION_MSG     824

#define NAP_CHANUSERS_RESULT 825

#define NAP_KICKCHAN_USER        829

#define NAP_CHANUSERS_REQ 830

// napster blocks of data
typedef struct _NapBlock {
  unsigned short size;
  unsigned short type;
  char data[2];
} __attribute__ ((packed)) NapBlock, *NAPBLOCKPTR;

class NapsterDownload;
class SongInfo;
class KSocket;
class IncomingConnection;

class NapsterConnection
: public QObject
{
  Q_OBJECT
signals:
  void onRead(NAPBLOCKPTR); // signal called on recieval of data
  void onClosed();          // signal called when connection was closed
  // signal called on getting a download/upload connection
  void onTransferConnection(KSocket *,SongInfo *song,bool isdload);
public slots:
   void sendSearch(const char *s);
   void sendHotlistUser(const char *s);
   void sendRemoveHotlistUser(const char *s);
   void sendBrowseUser(const char *s);
   void sendWhoisUser(const char *s);
   void sendChannellist(bool showall);
   void sendJoinChannel(const char *s);
   void sendPartChannel(const char *s);

   void sendIgnoreUser(const char *s);
   void sendUnignoreUser(const char *s);
   
   void sendChannelMessage(const char *chan,const char *msg);
   void sendUserMessage(const char *user,const char *msg);

   void sendDownloadRequest(const char *user,const char *song);
   void sendDownloadRequest2(const char *user,const char *song);

   void sendUploadAllowed(const char *user,const char *song);

   void sendIncUploads();
   void sendDecUploads();
   void sendIncDownloads();
   void sendDecDownloads();
   
   void sendQueueFull(const char *user,const char *song,int max);

   void sendVersionRequest();

   void sendPingRequest(const char *name);
   void sendPong(const char *user);

   void sendKillUser(const char *user,const char *reason);
private slots:
  void napsterRead(KSocket *);
  void napsterClose(KSocket *);
  void timeout();
  //void napsterTransferConnectionRead(KSocket *);
public:

  #define MAX_NAP_BLOCK 2048
  #define MIN_NAP_BLOCK 4
  
  typedef enum 
  {
         NAP_OK=0,NAP_TIMEOUT,
         NAP_BAD_PORT,NAP_BAD_IP,NAP_NO_CONNECT,
         NAP_NO_READ,NAP_NO_WRITE,
         NAP_SERVER_BUSY,NAP_NOSERVER_CONNECT,
         NAP_BAD_RECV_DATA,NAP_BAD_SEND_DATA,NAP_NO_LOGIN,
         NAP_NO_DOWNLOAD, NAP_NO_SOCKET,NAP_NO_BIND,
         NAP_NO_CREATEUSER,NAP_BAD_USERNAME,
	 NAP_EXTENDED_ERROR,
         NAP_LAST
  } NapError;

  NapsterConnection(QObject *parent=0, const char *name=0);
  virtual ~NapsterConnection();

  bool getBestHost(const char *server=SERVER_ADDR);
  bool parseBestHostString(const char *str); // set besthost from a hostip:port string
  bool open(int port=6699); // assumes getBestHost was called
  bool login(const char *username,const char *password,
        const char *email,int speed=0,bool new_user=false);

  void close();

  QString getUser() const;
  // status/info  funcs
  QString getIPAddressString() const;
  int getIPPort() const;

  int getSocket() const;

  int getListener() const;

  bool isOpen() const { return (_connected==true); }
  bool haveBestHost() const { return _havehost==true; }

  const NAPBLOCKPTR getLastBlock() const; 
  
  NapError getLastError() const { return _lasterror; }

  const char *getLastErrorStr() const;

  // spawn a download session
//  NapsterDownload *startDownload(long ip,int port,const char *filename,
//       const char *user,int speed,const char *dest);

  void receiveData(bool yes);
  
private:  
  // r/w functions
  NAPBLOCKPTR readBlock(bool waitfordata=true);
//  int writeBlock(int type,const char *data,int size);
  int writeBlock(int type,const QString &data);

  const char *getBuffer();

public:

  bool share(const SongInfo *s);

/*  
  // shortcuts to do certain functions

  bool queuefull(const char *u);

  bool search(const char *name);

  bool search_user(const char *user);

  bool download(const char *name,const char *user);

  bool whois(const char *user);
  bool ping(const char *user);
  bool sendUserMessage(const char *user,const char *message);

  bool list();  // list channels available
  bool join(const char *chan);
  bool part(const char *chan);
  bool users(const char *chan);


  bool sendChanMessage(const char *chan,const char *message);

  bool version();

  bool download_started_signal();
  bool download_finished_signal();

  bool upload_started_signal();
  bool upload_finished_signal();

  bool addHotListUser(const char *user);
  bool delHotListUser(const char *user);

  bool killUser(const char *user);
  bool kickChanUser(const char *chan,const char *user);

  bool banUser(const char *user);
  bool unbanUser(const char *user);
  bool listBans();

  bool opSay(const char *msg);

  bool changeChannelTopic(const char *channel,const char *topic);
*/
private:
  int readComm(char *buffer,int size);
  int writeComm(const char *buffer,int size);
  bool setupListener(int _port);

private: // data
  char _buffer[MAX_NAP_BLOCK+2];

  int _block_pos;

  bool _connected;
  bool _havehost;

  KSocket *_napster;

  KSocket *_listener;

  QString username;
  
  QString _napsteraddr;
  int _napsterport;

  QList<IncomingConnection> incominglist;
  // napster port etc and file handle
  //struct sockaddr_in _sockaddr;
  //int _napster;

  // the local listener for downloads
  //int _local;
  int _listenerport;

  NapError _lasterror;

  static const char *errorstr[];

};

#endif
