//
// C++ Interface: kmfnetzone
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFNETZONE_H
#define KMFNETZONE_H

#include "netfilterobject.h"

// QT includes
#include <qptrlist.h>
#include <qguardedptr.h>
#include <qstring.h>

// KDE includes
#include <kdemacros.h>

// Project includes
#include "ipaddress.h"


class KMFGenericDoc;
class KMFProtocol;
class KMFError;
class KMFCheckInput;
class IPAddress;
class KMFNetHost;

//############ KMFNetZone #############
class KDE_EXPORT KMFNetZone : public NetfilterObject {
public:
	KMFNetZone( QObject *parent, const QString& name );

	~KMFNetZone();

	IPAddress* address() const {
		return m_address;
	};


	IPAddress* mask() const {
		IPAddress *addr = new IPAddress();
		addr->setAddress( IPAddress::calcNetworkMaskFromLength( m_maskLen ).toString() );
		return addr;
	};
	
	int maskLength() const {
		return m_maskLen;
	}
	
	KMFGenericDoc* doc() const;
	KMFNetZone* zone() const;

	int getZoneType() const {
		return m_zoneType;
	};

	const QString& guiName() const {
		return m_guiName;
	};

// 	bool deadEnd() const {
// 		return m_deadEnd;
// 	};

	void clear();

	void setGuiName( const QString& );
	void setDeadEnd( bool );
	bool setZone( const IPAddress& , int );
	
	
	void setMaskLength( int );
	
	bool protocolInherited( const QString& ) const;

	const QDomDocument& getDOMTree();
	void loadXML(const QDomDocument& );

	KMFNetZone* addZone( const QString& , KMFError* );
	void delZone( KMFNetZone*, bool desructive = true );

	KMFProtocol* addProtocol( const QString& name, const QDomDocument& xml );
	void delProtocol( KMFProtocol* );

	KMFNetHost* addHost( const QString& name, const QDomDocument& xml );
	void delHost( KMFNetHost*, bool desructive = true );

	QPtrList<KMFProtocol>& protocols() const;
	QPtrList<KMFNetZone>& zones() const;
	QPtrList<KMFNetHost>& hosts() const;

	KMFProtocol* findProtocol( const QString& name ) const;
	KMFNetHost* placeHostInZone( KMFNetHost* host );

	enum { ROOT, NODE } Type;

private:
	QGuardedPtr<KMFGenericDoc> m_doc;
	QGuardedPtr<KMFNetZone> m_zone;
	IPAddress *m_address;
	QPtrList<KMFProtocol> m_protocols;
	QPtrList<KMFNetZone> m_zones;
	QPtrList<KMFNetHost> m_hosts;
	KMFError *m_err;
	int m_zoneType;
	int m_maskLen;
// 	bool m_deadEnd;
	QString m_guiName;
};



#endif
