//
// C++ Interface: kmfnethost
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFNETHOST_H
#define KMFNETHOST_H

#include "netfilterobject.h"

// QT includes
#include <qptrlist.h>
#include <qguardedptr.h>
#include <qstring.h>
#include <qdom.h>

// KDE includes
#include <kdemacros.h>

// Project includes

class KMFGenericDoc;
class KMFProtocol;
class KMFError;
class KMFCheckInput;
class KMFNetZone;
class IPAddress;
/**
@author Christian Hubinger
*/
class KDE_EXPORT KMFNetHost : public NetfilterObject {
public:
	KMFNetHost( QObject *parent, const QString& name );
	~KMFNetHost();

	KMFNetZone* zone() const {
		return m_zone;
	}


	const QString& guiName() const {
		return m_guiName;
	};
	void setGuiName( const QString& );

	IPAddress* address() const {
		return m_address;
	};
	
	void setAddress( const QString& );

	void setMaskLength( int );
	
	void setParentZone( KMFNetZone* );
	
	bool logIncoming() {
		return m_logIncoming;
	}
	void setLogIncoming( bool );

	bool logOutgoing() {
		return m_logOutgoing;
	}
	void setLogOutgoing( bool );

	void setLimit( int num, const QString& scale );
	
	bool limit() const;
	int limitRate() const;
	const QString& limitScale() const;
	
	const QDomDocument& getDOMTree();
	void loadXML(const QDomDocument& );

	KMFProtocol* addProtocol( const QString& name, const QDomDocument& xml );
	KMFProtocol* addProtocol( const QString& name );
	void delProtocol( KMFProtocol* );
	bool protocolInherited( const QString& ) const;
	KMFProtocol* findProtocol( const QString& name ) const;
	QPtrList<KMFProtocol>& protocols() const;

private: // Data
	QGuardedPtr<KMFNetZone> m_zone;
	IPAddress *m_address;
// 	int m_maskLen;
	QPtrList<KMFProtocol> m_protocols;
	QString m_guiName;
	bool m_logIncoming, m_logOutgoing;
	QString m_limitScale;
	int m_limitNum;
};

#endif
