/***************************************************************************
                          kmfruleinfo.cpp  -  description
                             -------------------
    begin                : Thu Apr 24 2003
    copyright            : (C) 2003 by animal
    email                : animal@shit
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleinfo.h"
#include "kmfruleinfo.moc"

// KDE Includes
#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>

// QT includes
#include <qstring.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtextedit.h>

// Project includes
#include "../core/iptrule.h"
#include "../core/iptchain.h"
#include "../core/iptable.h"
#include "../core/kmfdoc.h"

KMFRuleInfo::KMFRuleInfo(QWidget *parent, const char *name ) : KMyFirewallRuleInfo(parent,name) {
}
KMFRuleInfo::~KMFRuleInfo(){
}

void KMFRuleInfo::loadRule( IPTRule* rule ) {
	if ( rule == 0 )
		return;
	m_rule = rule;
	te_desc->setText( m_rule->description() );
}

void KMFRuleInfo::accept() {
	if ( m_rule->description() != te_desc->text() ) {
		m_rule->setDescription( te_desc->text() );
		m_rule->chain()->table()->kmfDoc()->changed();
		kdDebug()  << "Description Changed: " << te_desc->text() <<  endl;
	}
	emit sigDocumentChanged();
}

void KMFRuleInfo::reject() {
	emit sigHideMe();
}

void KMFRuleInfo::slotHelp() {
	kapp->invokeHelp( "rule_documentation" );
}


