/***************************************************************************
                       kmfruleeditortos.h  -  description
                          -------------------
 begin                : Wed Mar 27 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORTOS_H
#define KMFRULEEDITORTOS_H

#include <qwidget.h>
#include <kmyfirewallruleeditortos.h>
#include <qptrlist.h>
#include <qstring.h>
class IPTRule;

/**
  *@author Christian Hubinger
  */

class KMFRuleEditorTos : public KMyFirewallRuleEditorTos {
	Q_OBJECT
public:
	KMFRuleEditorTos( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorTos();
	IPTRule* curr_rule;
	QPtrList<QString>* options;

	void loadRule( IPTRule* );
	void setType( const QString& type );

public slots:
	void accept();
	void reject();
	void slotHelp();

private:    // data
	QString m_option_type;
	void setItems();
	int getItemNum( const QString& option );
signals:
	void sigAddRuleOpt( QString *, QPtrList<QString> * );
	void sigDelRuleOpt( QString * );
	void sigAddTargetOpt( QString*, QPtrList<QString>* );
	void sigDelTargetOpt( QString * );
	void sigDocumentChanged();
	void sigHideMe();
};

#endif
