/* -*- c++ -*-
 *
 * shareinfo.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "shareinfo.h"
#include "donkeymessage.h"

#include <qfile.h>

ShareInfo::ShareInfo(DonkeyMessage* msg, int)
{
    num = msg->readInt32();
    network = msg->readInt32();
    QByteArray ba = msg->readByteArray();
    ba.resize(ba.size() + 1); ba[ba.size()-1] = 0;
    name = QFile::decodeName( QCString( ba.data(), ba.size() ) ); // the file is locally encoded
    size = msg->readInt64();
    uploaded = msg->readInt64();
    requests = msg->readInt32();
    md4 = QByteArray(16);
    if (msg->opcode() >= 48)
        for (int i = 0; i < 16; i++)
            md4[i] = msg->readInt8();
}

ShareInfo::ShareInfo(const ShareInfo& si)
{
    num = si.shareNo();
    network = si.shareNetwork();
    name = si.shareName();
    size = si.shareSize();
    uploaded = si.shareUploaded();
    requests = si.shareRequests();
    md4 = si.shareMD4();
}

ShareInfo::~ShareInfo()
{
}

void ShareInfo::updateShare(DonkeyMessage* msg, int)
{
    uploaded = msg->readInt64();
    requests = msg->readInt32();
}

const int ShareInfo::shareNo() const { return num; }
const int ShareInfo::shareNetwork() const { return network; }
const QString& ShareInfo::shareName() const { return name; }
const int64 ShareInfo::shareSize() const { return size; }
const int64 ShareInfo::shareUploaded() const { return uploaded; }
const int ShareInfo::shareRequests() const { return requests; }
const QByteArray& ShareInfo::shareMD4() const { return md4; }
