/* -*- c++ -*-
 *
 * closabletab.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_closabletab_h__
#define __kmldonkey_closabletab_h__

#include <qtabbar.h>
#include <qtabwidget.h>

class ClosableTabBar : public QTabBar
{
    Q_OBJECT

public:
    ClosableTabBar(QWidget *parent = 0, const char *name = 0);

signals:
    void iconPressed();

protected:
    void mouseReleaseEvent(QMouseEvent *e);

private:
    bool withinIcon(const QTab * t, const QPoint & point);

};

class ClosableTabWidget : public QTabWidget 
{
    Q_OBJECT

public:
    ClosableTabWidget(QWidget *parent = 0, const char *name = 0);

    virtual void addTab(QWidget* child, const QIconSet& iconset, const QString& label);

signals:
    void closeRequest(QWidget*);
    void sigCurrentChanged(QWidget*);

public slots:
    void slotCurrentChanged(QWidget*);
    void slotIconPressed();

};

#endif // __kmldonkey_closabletab_h__
