/* -*- c++ -*-
 *
 * giftdownload.cpp
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "giftdownload.h"
//#include "giftdownload.moc"

GiftDownloadInfo::GiftDownloadInfo(GiftMessage* message) : InfoInterface()
{
    update(message);
}

GiftDownloadInfo::~GiftDownloadInfo()
{
}

void GiftDownloadInfo::update(GiftMessage* message)
{
    m_file = message->getArgumentValue("file");
    m_hash = message->getArgumentValue("hash");
    m_size = message->getArgumentValue("size").toInt();
    m_transmit = message->getArgumentValue("transmit").toInt();
    m_isshared = message->getArgumentValue("shared") == "1";

    QString s_state = message->getArgumentValue("state").lower();
    if (s_state == "active")
        m_state = Active;
    else if (s_state == "paused")
        m_state = Paused;
    else if (s_state == "completed")
        m_state = Completed;
    else
        m_state = Unknown;

    //TODO
    //info->addSource();
    //message->getArgumentValue("SOURCE");
    //  user (username)
    //  url (url)
    //  statusgrl (status
    //  status (protocol status)
    //  start (chunk start)
    //  transmit (chunk transmit)
    //  total (chunk total)
}
