/***************************************************************************
                          settingsdialog.cpp  -  description
                             -------------------
    begin                : Sun Feb 17 2002
    copyright            : (C) 2002 by Olaf Lueg
    email                : olueg@olsd.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "settingsdialog.h"
#include "base.h"
#include "blocked.h"
#include "accountdlg.h"
#include "alert.h"
#include "kmsnapp.h"
#include "imservice.h"

#include <qvariant.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qobject.h>
#include <qbutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kmessagebox.h>

SettingsDialog::SettingsDialog(QWidget *parent, const char *name )
			: KDialogBase( IconList, i18n("Settings"), Help | Ok | Cancel, Ok, parent, name, false, true )
{
	QFrame *baseSettingFrame    = addPage( i18n( "Accounts" ) ,i18n( "Accounts" ) ,
						KGlobal::instance()->iconLoader()->loadIcon( "identity" ,KIcon::NoGroup , KIcon::SizeMedium ) );
	QFrame *blockedSettingFrame = addPage( i18n( "Blocked Contacts" ) ,i18n( "Blocked Contacts" ) ,
						KGlobal::instance()->iconLoader()->loadIcon( "stop" ,KIcon::NoGroup , KIcon::SizeMedium ) );
	QFrame *alertSettingFrame = addPage( i18n( "Alerts" ) ,i18n( "Alerts" ) ,
						KGlobal::instance()->iconLoader()->loadIcon( "date" ,KIcon::NoGroup , KIcon::SizeMedium ) );	
	
	QVBoxLayout *baseSettingLayout    = new QVBoxLayout( baseSettingFrame );
	QVBoxLayout *blockedSettingLayout = new QVBoxLayout( blockedSettingFrame );
	QVBoxLayout *alertSettingLayout    = new QVBoxLayout( alertSettingFrame );
	
	baseSetting    = new BaseSetting( baseSettingFrame , "base" );
	blockedSetting = new BlockedSetting( blockedSettingFrame, "blocked" );
	alertSetting = new AlertSetting( alertSettingFrame, "alert" );
	
	baseSettingLayout->addWidget(baseSetting);
	blockedSettingLayout->addWidget(blockedSetting);
	alertSettingLayout->addWidget(alertSetting);
	
	baseSetting->ListView->setColumnWidth(0,baseSetting->ListView->width()-5);
	blockedSetting->BlockedList->setColumnWidth(0,blockedSetting->BlockedList->width()-5);
	
	// connections from baseSetting
	accountList.setAutoDelete(true);
	readConfig();

	connect((QObject*)baseSetting->btnAdd,SIGNAL( clicked()), this, SLOT(slotAddAccount()));
	connect((QObject*)baseSetting->btnEdit,SIGNAL( clicked()), this, SLOT(slotEditAccount()));
	connect((QObject*)baseSetting->btnRemove,SIGNAL( clicked()), this, SLOT(slotRemoveAccount()));
	connect((QObject*)blockedSetting->btnRemove,SIGNAL( clicked()),this, SLOT(slotAllowContact()));
}
SettingsDialog::~SettingsDialog()
{
}

void SettingsDialog::init(KMsnApp *thisApp)
{
	theApp = thisApp;
	if(theApp->isConnected())
	{
		baseSetting->strPublicName->setEnabled(true);
		baseSetting->strPublicName->setText(theApp->imService->getPublicName());
		baseSetting->strHandle->setText(theApp->imService->getHandle());
		connect(this,SIGNAL(changePublicName(QString)),theApp,SLOT(slotChangePublicName(QString)));
		blockedSetting->BlockedList->clear();
		const QStringList list = theApp->imService->getBlockedContacts();
		for( int i =0; i < list.count(); i++)
		{
			(void*) new QListViewItem(blockedSetting->BlockedList,list[i]);
		}
	}
	else
	{
		// nothing to do
	}
}
// read the config file
void SettingsDialog::readConfig()
{
	QStringList profiles;
	KConfig *config = KGlobal::config();
	config->setGroup("Profiles");
	profiles = config->readListEntry( "Profiles" );
	for(uint i =0; i < profiles.count(); i++)
	{
		Account *account = new Account();
		account->name = profiles[i];
		config->setGroup("Profile_"+profiles[i]);
		account->password = config->readEntry("password",QString::null);
		account->handle = config->readEntry("name",QString::null);
		accountList.append(account);
		QListViewItem *item = new QListViewItem(baseSetting->ListView,profiles[i]);
		item->setPixmap(0,KGlobal::instance()->iconLoader()->loadIcon( "identity" ,KIcon::NoGroup , KIcon::SizeSmall ));
		baseSetting->LoginCombo->insertItem(KGlobal::instance()->iconLoader()->loadIcon( "identity" ,KIcon::NoGroup , KIcon::SizeSmall ),profiles[i]);
		
	}
	config->setGroup("Profiles");
	QString autoConnect = config->readEntry("DefaultUser",i18n("No auto connect"));
	for(int j =0; j < baseSetting->LoginCombo->count(); j++)
	{
		if(baseSetting->LoginCombo->text(j) == autoConnect)
		{
			baseSetting->LoginCombo->setCurrentItem(j);
		}
	}
	config->setGroup("General");
	alertSetting->checkIdle->setChecked(config->readBoolEntry("Idle Detection",true) );
	alertSetting->spinIdle->setValue(config->readNumEntry("MaxIdle",15));
	
	alertSetting->checkAlert->setChecked(config->readBoolEntry("Enable Alert",true) );
	alertSetting->spinAlert->setValue(config->readNumEntry("Notification Timeout",10));
	

}

// save to config file
void SettingsDialog::saveConfig()
{
	QStringList profiles;
	Account *account;
	KConfig *config = KGlobal::config();
	for(int i =0; i < accountList.count(); i++)
	{
		account = accountList.at(i);
		config->setGroup("Profile_"+account->name);
		config->writeEntry("name",account->handle);
		config->writeEntry("password",account->password);
		profiles.append(account->name);
	}
	config->setGroup("Profiles");
	config->writeEntry("Profiles",profiles);
	config->writeEntry("DefaultUser",baseSetting->LoginCombo->currentText());
	
	config->setGroup("General");
	config->writeEntry("Idle Detection",alertSetting->checkIdle->isChecked() );
	config->writeEntry("MaxIdle",alertSetting->spinIdle->text().toInt());
	config->writeEntry("Enable Alert",alertSetting->checkAlert->isChecked() );
	config->writeEntry("Notification Timeout",alertSetting->spinAlert->text().toInt());

	
	config->sync();
	if(baseSetting->strPublicName->edited())
	{
		emit changePublicName(baseSetting->strPublicName->text());
		baseSetting->strPublicName->setEdited(false);
	}
}

//////////// BaseSetting //////////////////

void SettingsDialog::slotAddAccount()
{
	AccountDlg dlg(0,"Settings",true,0);
	int ret = dlg.exec();
	if(ret == 1)
	{
		// OK pressed, create account
		Account *account  = new Account();
		account->name     = dlg.strName->text();
		account->handle   = dlg.strHandle->text();
		account->password = dlg.strPassword->text();
		accountList.append(account);
		
		QListViewItem *item = new QListViewItem(baseSetting->ListView,dlg.strName->text());
		item->setPixmap(0,KGlobal::instance()->iconLoader()->loadIcon( "identity" ,KIcon::NoGroup , KIcon::SizeSmall ));
		baseSetting->LoginCombo->insertItem(KGlobal::instance()->iconLoader()->loadIcon( "identity" ,KIcon::NoGroup , KIcon::SizeSmall ),dlg.strName->text());

	}
}

void SettingsDialog::slotEditAccount()
{
	if(baseSetting->ListView->currentItem() != 0)
	{
		QString profile = baseSetting->ListView->currentItem()->text(0); // get selected itemText
		AccountDlg dlg(0,"Settings",true,0);
		dlg.setCaption(i18n("Edit Account"));
		dlg.strName->setText(profile);
		Account *account;
		uint item;
		for(uint i =0; i < accountList.count(); i++)
		{
			account = accountList.at(i);
			if(account->name == profile )
			{
				dlg.strHandle->setText(account->handle); // update the dialog
				dlg.strPassword->setText(account->password);
				item = i;  // save current position
			}
			
		}
		int ret = dlg.exec();
		if(ret == 1)
		{
			// OK pressed, update account
			account = accountList.at(item); // get the current account
			for(int j = 0; j < baseSetting->LoginCombo->count(); j++)
			{
				if(baseSetting->LoginCombo->text(j) == account->name)
				{       // update the combobox
					baseSetting->LoginCombo->changeItem(KGlobal::instance()->iconLoader()->loadIcon( "identity" ,KIcon::NoGroup , KIcon::SizeSmall ),dlg.strName->text(),j);
				}
			}
			account->handle = dlg.strHandle->text();
			account->name   = dlg.strName->text();
			baseSetting->ListView->currentItem()->setText(0,account->name); // update ListView
			account->password = dlg.strPassword->text();
		}
	}

}

void SettingsDialog::slotRemoveAccount()
{
	if(baseSetting->ListView->currentItem() != 0)
	{
		QString profile = baseSetting->ListView->currentItem()->text(0); // get selected itemText
		// Create KMessageBox and ask
		uint item;
		Account *account;
		for(uint i =0; i < accountList.count(); i++)
		{
			account = accountList.at(i);
			if(account->name == profile )
			{
				item = i;
			}
			
		}
		int ret =KMessageBox::questionYesNo(this,i18n("Do you realy want to remove this account:") + " <b>" + profile + "</b>",i18n("Remove Account"));
		if(ret == KMessageBox::Yes)
		{
			// delete it
			account = accountList.at(item);
			for(int j = 0; j < baseSetting->LoginCombo->count(); j++)
			{
				if(baseSetting->LoginCombo->text(j) == account->name)
				{       // update the combobox
					baseSetting->LoginCombo->removeItem(j);
				}
			}
			delete baseSetting->ListView->currentItem(); // delete in ListView
			accountList.remove(item); // delete from list
		}
	}
}

void SettingsDialog::slotOk()
{
	saveConfig();
	hide();
	emit closed();
}

void SettingsDialog::slotCancel()
{
	hide();
	emit closed();
}

void SettingsDialog::slotAllowContact()
{
	if(theApp->isConnected())
	{
		if(blockedSetting->BlockedList->currentItem() != 0)
		{
			theApp->slotContactAllow(blockedSetting->BlockedList->currentItem()->text(0));
			delete blockedSetting->BlockedList->currentItem();
		}
	}
}





