/***************************************************************************
                          kmsnapp.cpp  -  description
                             -------------------
    begin                : Mon Jul 23 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Must be included before idle.h since X11 declares weird defines. /hpj
#include <qvariant.h>

// my include
#include "kmsnapp.h"
#include "imservice.h"
#include "onlineview.h"
#include "settingsdialog.h"
#include "idle.h"
#include "chatwindow.h"
#include "chatviewimpl.h"
#include "kmsn.h"
#include "systemnotifier.h"
#include "kmsnaction.h"
#include "imchatservice.h"
#include "adduserimpl.h"
#include "newuserimpl.h"

// kde include
#include <klocale.h>
#include <kapp.h>
#include <kaccel.h>
#include <kglobal.h>
#include <kstdaction.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <knotifyclient.h>
#include <klineeditdlg.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>

// qt include
#include <qtooltip.h>
#include <qlist.h>
#include <qlineedit.h>
#include <qinputdialog.h>

#define ID_STATUS_MSG 1023

KMsnApp::KMsnApp(QWidget *parent, const char *name ) : KMainWindow(parent,name)
{
	imService = new IMService( );
	widgetList.setAutoDelete(false);
	userSettings = false;
	connected = false;
	settings = NULL;
	currentStatus = FLN;
	viewWidget = new OnlineView(this);
	viewWidget->theApp = this;
	systemTrayWidget = new KMsn(this);
	initActions();
	readOptions();
	statusBar()->show();
	statusBar()->insertItem(i18n("Ready."),ID_STATUS_MSG);
	// create the main view
	setCentralWidget(viewWidget);
	fileDisconnector->setEnabled(false);
	mailTimer = 0L;

	connect(imService,SIGNAL(startChat(IMChatService*,QString)),this,SLOT(slotOpenChatWindow(IMChatService*,QString)));
	// new protocoll
	connect(imService, SIGNAL( connectedToService(bool)), this, SLOT(slotConnectedToMsn(bool)));
	connect(imService, SIGNAL( connectedToService(bool)), viewWidget, SLOT(slotConnected(bool )));

	connect(imService, SIGNAL( updateContact(QString, uint )), viewWidget, SLOT(slotUpdateContact(QString, uint)));
	connect(imService, SIGNAL( updateContact(QString, uint )), this, SLOT(slotShowNotifierWidget(QString, uint )));
	
	connect(imService, SIGNAL( contactAdded(QString, QString, QString )), viewWidget, SLOT(slotContactAdded(QString, QString, QString)));
	connect(imService, SIGNAL( contactRemoved(QString, QString)), viewWidget, SLOT(slotContactRemoved(QString, QString)));
	
	connect(viewWidget, SIGNAL( chatToUser(QString)), imService, SLOT( slotStartChatSession( QString)));
	connect(viewWidget, SIGNAL( selectionChanged()), this, SLOT(slotUpdateMenu()));

	connect(imService, SIGNAL( statusChanged( uint )), this, SLOT(slotUpdateStatus( uint )));
	connect(imService, SIGNAL( newContact( QString )), this, SLOT(slotAuthenticate( QString )));
	
	connect(imService, SIGNAL( groupRenamed( QString, QString)), viewWidget, SLOT(slotUpdateGroup( QString, QString)));
	connect(imService, SIGNAL( groupAdded( QString )), viewWidget, SLOT(slotInsertGroup( QString)));
	connect(imService, SIGNAL( groupRemoved( QString )), viewWidget, SLOT(slotRemoveGroup( QString )));
	
	connect(imService, SIGNAL( newMail(QString, uint )), this, SLOT(slotIncomingMail(QString, uint)));
	connect(imService, SIGNAL( publicNameChanged( QString )), this, SLOT(slotPublicNameChanged( QString )));

	connect(this,SIGNAL(connectToService()),imService, SLOT(slotConnectToService()));
	
	idleTimer = new IdleTimer(15);
	if(!idleTimer->isIdleDetectionPossible())
	{
		kdDebug() << "Idle detection is not possible" << endl;
	}
	idleTimer->toggleOverAllIdleDetection(true);
	connect(idleTimer,SIGNAL(idleDetected(bool)),this,SLOT(slotToggleIdle(bool)));

	notifierWidget = new SystemNotifier(notificationTimeout,0);
	notifierWidget->hide();
	
	_workTimer = 0L;
	_autoConnectTimer = 0L;

	if (autoConnect)
	{
		_silent = true;
		slotConnector(defaultUser);
		_silent = false;
	}
	slotUpdateMenu();
}

KMsnApp::~KMsnApp()
{
	delete notifierWidget;
	saveOptions();
}

// only for test, needs a better way
void KMsnApp::slotAutoConnect()
{
	slotConnector(curProfile);
}

void KMsnApp::closeEvent(QCloseEvent*)
{
	if(fileAddToPanel->isChecked())
	{
		hide();
	}
	else
	{
		visible = !isHidden();
		delete this;
	}
}
/** create the menu and toolbar */
void KMsnApp::initActions()
{
	fileConnector = new KActionMenu( i18n("&Connect...") , "connect_no" , actionCollection() , "connector" );
	connect(fileConnector->popupMenu(),SIGNAL(activated(int)),this,	SLOT(slotConnectorClicked(int)));
	fileDisconnector = new KAction( i18n("&Disconnect") ,"connect_no", 0, this,
					SLOT( slotDisconnector() ), actionCollection(), "disconnector" );
	fileStatus    = new KSelectAction(i18n("&My Status"),"exec", 0, this,
					SLOT(slotStatus()), actionCollection(),"fileStatus");
	// seperator
        fileAddToPanel = new KToggleAction(i18n("Add to Panel"),"panel", 0, this, SLOT(slotAddToPanel()),actionCollection(),"addToPanel");
	// separator
	fileHide      = new KAction(i18n("&Hide Window"),"attach",CTRL+Key_H, this, SLOT(slotHide()), actionCollection(),"fileHide");
	fileQuit      = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection(),"quit");

	viewToolBar   = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
	viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
	viewEmailCheck= new KToggleAction(i18n("&Hide email check"), 0, this, SLOT(slotHideEmail()),actionCollection(),"hideEmail");
	viewSettings  = new KAction(i18n("&Settings"),"configure", 0, this, SLOT(slotSettings()), actionCollection(),"viewSettings");
	
	contactCopy   = new KActionMenu(i18n("C&opy Contact"), "copy", actionCollection(),"contactCopy");
	contactMove   = new KActionMenu(i18n("&Move Contact"), "move", actionCollection(),"contactMove");
	connect(contactCopy->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotContactCopy(int)));
	connect(contactCopy->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(slotContactCopy()));
	connect(contactMove->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotContactMove(int)));
	connect(contactMove->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(slotContactMove()));
	
	contactAdd    = new KAction(i18n("&Add Contact"),"bookmark_add",0, this, SLOT(slotContactAdd()), actionCollection(),"contactAdd");
	contactRemove = new KAction(i18n("&Remove Contact"),"eraser",0, this, SLOT(slotContactRemove()), actionCollection(),"contactRemove");
	contactDelete = new KAction(i18n("&Delete Contact"),"eraser",0, this, SLOT(slotContactDelete()), actionCollection(),"contactDelete");
	contactBlock  = new KAction(i18n("&Block Contact"),"stop",0, this, SLOT(slotContactBlock()), actionCollection(),"contactBlock");
	contactUnBlock = new KAction(i18n("A&llow Contact"),"stop",0, this, SLOT(slotContactAllow()), actionCollection(),"contactunBlock");
	contactChat   = new KAction(i18n("&Chat"),"history", CTRL+Key_C, this, SLOT(slotContactChat()), actionCollection(),"contactChat");
	
	groupAdd    = new KAction(i18n("A&dd Group"), "help", 0, this, SLOT(slotGroupAdd()), actionCollection(), "groupAdd");
	groupRename = new KAction(i18n("&Rename Group"), "help", 0, this, SLOT(slotGroupRename()), actionCollection(), "groupRename");
	groupDelete = new KAction(i18n("Remo&ve Group"), "help", 0, this, SLOT(slotGroupDelete()), actionCollection(), "groupRemove");
	
	createGUI("kmerlinbaseui.rc");

	// insert Status items
	id_online    = fileStatus->popupMenu()->insertItem(i18n("Online"));
	id_busy      = fileStatus->popupMenu()->insertItem(i18n("Busy"));
	id_back      = fileStatus->popupMenu()->insertItem(i18n("Be right back"));
	id_away      = fileStatus->popupMenu()->insertItem(i18n("Away from Computer"));
	id_phone     = fileStatus->popupMenu()->insertItem(i18n("On the phone"));
	id_lunch     = fileStatus->popupMenu()->insertItem(i18n("Out to lunch"));
	id_invisible = fileStatus->popupMenu()->insertItem(i18n("Invisible"));



	// create menu in systemTrayWidget
	fileConnector->plug(systemTrayWidget->menu);
	fileDisconnector->plug(systemTrayWidget->menu);
	systemTrayWidget->menu->insertSeparator();
	viewSettings->plug(systemTrayWidget->menu);
	systemTrayWidget->menu->insertSeparator();
	systemTrayWidget->menu->insertItem(viewWidget->execPixmap,i18n("Online state"),fileStatus->popupMenu());
	fileQuit->plug(systemTrayWidget->menu);
	// end systemTrayWidget

	// create menu in viewWidget
/*	fileConnector->plug(viewWidget->menu);
	fileDisconnector->plug(viewWidget->menu);
	viewWidget->menu->insertSeparator();
	viewWidget->menu->insertItem(viewWidget->execPixmap,i18n("Online state"),fileStatus->popupMenu());
	contactChat->plug(viewWidget->menu);
	contactAdd->plug(viewWidget->menu);
	contactDelete->plug(viewWidget->menu);
	contactBlock->plug(viewWidget->menu); */

	// connections for status menu
	connect(fileStatus->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotChangeStatus(int)));
	// disable Status menu
	fileStatus->popupMenu()->setEnabled(false);

	contextMenu = new KPopupMenu(this);
	contextMenu->setTitle("KMerlin");

}

// show the context menu
void KMsnApp::slotShowContextMenu(const QPoint& point)
{
	contactAdd->unplug(contextMenu);
	contactRemove->unplug(contextMenu);
	contactBlock->unplug(contextMenu);
	contactUnBlock->unplug(contextMenu);
	contactCopy->unplug(contextMenu);
	contactMove->unplug(contextMenu);
	contactChat->unplug(contextMenu);

	groupAdd->unplug(contextMenu);
	groupDelete->unplug(contextMenu);
	groupRename->unplug(contextMenu);

	if(connected)
	{
		groupAdd->plug(contextMenu);
		contactAdd->plug(contextMenu);
		if(viewWidget->getParent() == 0L)
		{
			groupDelete->plug(contextMenu);
			groupRename->plug(contextMenu);
		}
		else
		{
			contactRemove->plug(contextMenu);
			contactBlock->plug(contextMenu);
			contactUnBlock->plug(contextMenu);
			contactCopy->plug(contextMenu);
			contactMove->plug(contextMenu);
			contactChat->plug(contextMenu);
		}
	}
	contextMenu->popup(point);
}
// update the Contact and Group Menu
void KMsnApp::slotUpdateMenu()
{
	if(!connected)
	{
		groupAdd->setEnabled(false);
		groupRename->setEnabled(false);
		groupDelete->setEnabled(false);
		contactAdd->setEnabled(false);
		contactRemove->setEnabled(false);
		contactDelete->setEnabled(false);
		contactBlock->setEnabled(false);
		contactUnBlock->setEnabled(false);
		contactChat->setEnabled(false);
		contactCopy->setEnabled(false);
		contactMove->setEnabled(false);
		return;
	}
	if(viewWidget->getParent() == 0L)
	{
		groupAdd->setEnabled(true);
		groupRename->setEnabled(true);
		groupDelete->setEnabled(true);
		contactAdd->setEnabled(false);
		contactRemove->setEnabled(false);
		contactDelete->setEnabled(false);
		contactBlock->setEnabled(false);
		contactUnBlock->setEnabled(false);
		contactChat->setEnabled(false);
		contactCopy->setEnabled(false);
		contactMove->setEnabled(false);

	}
	else
	{
		groupAdd->setEnabled(false);
		groupRename->setEnabled(false);
		groupDelete->setEnabled(false);
		
		contactAdd->setEnabled(true);
		contactRemove->setEnabled(true);
		contactDelete->setEnabled(true);
		if(imService->isBlocked(viewWidget->getHandle() ) )
		{
			contactBlock->setEnabled(false);
			contactUnBlock->setEnabled(true);
		}
		else
		{
			contactBlock->setEnabled(true);
			contactUnBlock->setEnabled(false);
		}
		contactChat->setEnabled(true);
		contactCopy->setEnabled(true);
		contactMove->setEnabled(true);
	}
}

void KMsnApp::slotAddToPanel()
{
	if(fileAddToPanel->isChecked())
	{
		systemTrayWidget->show();
	}
	else
	{
		systemTrayWidget->hide();
	}
}
void KMsnApp::slotContactAdd()
{
	bool ok = FALSE;
	QString text = KLineEditDlg::getText( i18n( "Please enter the contact name" ), QString::null, &ok, this );
	if ( ok && !text.isEmpty() )
	{
		if(_workTimer != 0L)
			killTimer(_workTimer);
		_workTimer = startTimer(30000);
		imService->contactAdd(text);
	}
	else
		return;
}

void KMsnApp::slotContactCopy()
{
	QString curGroup = viewWidget->getParent();
	QStringList list = imService->getGroups();
	contactCopy->popupMenu()->clear();
	if( curGroup == 0L ) return;
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		if((*it).latin1() != curGroup )
		{
			if(_workTimer != 0L)
				killTimer(_workTimer);
			_workTimer = startTimer(30000);
			contactCopy->popupMenu()->insertItem((*it).latin1() );
		}
	}
}

void KMsnApp::slotContactCopy(int i)
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->contactCopy( viewWidget->getHandle(), contactCopy->popupMenu()->text(i) );
}

void KMsnApp::slotContactMove(int i)
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->contactMove( viewWidget->getHandle(), viewWidget->getGroup(), contactMove->popupMenu()->text(i) );
}


void KMsnApp::slotContactMove()
{
	QString curGroup = viewWidget->getParent();
	QStringList list = imService->getGroups();
	contactMove->popupMenu()->clear();
	if( curGroup == 0L ) return;
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		if((*it).latin1() != curGroup )
		{
			if(_workTimer != 0L)
				killTimer(_workTimer);
			_workTimer = startTimer(30000);
			contactMove->popupMenu()->insertItem((*it).latin1() );
		}
	}
}

void KMsnApp::slotContactRemove()
{
	QString curGroup = viewWidget->getGroup();
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->contactRemove( viewWidget->getHandle(), curGroup );
}

void KMsnApp::slotContactDelete()
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->contactDelete(viewWidget->getHandle() );
}

void KMsnApp::slotContactBlock()
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->contactBlock( viewWidget->getHandle() );
}

void KMsnApp::slotContactAllow()
{
	const QString _handle = viewWidget->getHandle();
	if(handle != 0L)
	{
		if(_workTimer != 0L)
			killTimer(_workTimer);
		_workTimer = startTimer(30000);
		imService->contactUnBlock( _handle );
	}
}

void KMsnApp::slotContactAllow(QString _handle)
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->contactUnBlock( _handle );
}

void KMsnApp::slotContactChat()
{
	imService->slotStartChatSession(viewWidget->getHandle() );
}

void KMsnApp::slotGroupAdd()
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	imService->groupAdd( );
}

void KMsnApp::slotGroupRename()
{
	bool ok = FALSE;
	QString text = QInputDialog::getText( i18n( "Rename Group" ), i18n( "Please enter the group name" ), QLineEdit::Normal, QString::null, &ok, this );
	if ( ok && !text.isEmpty() )
	{
		// user entered something and pressed ok
		if(_workTimer != 0L)
			killTimer(_workTimer);
		_workTimer = startTimer(30000);
		imService->groupRename( viewWidget->getGroup(), text );
	}
	else
	{
		// user entered nothing or pressed cancel
	}

}

void KMsnApp::slotGroupDelete()
{
	if( viewWidget->isEmpty()  )
	{
		if(_workTimer != 0L)
			killTimer(_workTimer);
		_workTimer = startTimer(30000);
		imService->groupDelete( viewWidget->getGroup() );
	}
	else
	{
		KMessageBox::error(0,i18n("Group not Empty!"));
	}
	
}


void KMsnApp::slotStatus()
{
// empty slot
}

/** exit kmsn*/
void KMsnApp::slotFileQuit()
{
	visible = !isHidden();
	delete this;
}

/** slotConnectorClicked */
void KMsnApp::slotConnectorClicked(int)
{
	//imService->enableAutoConnect(false); // disable auto connect and silent mode
	//slotConnector(0);
}

/**slotConnector()**/
void KMsnApp::slotConnector( int i )
{
	//If we're currently not connected
	if (!connected)
	{
		_autoConnect = true;
		if(_autoConnectTimer != 0L)
			killTimer(_autoConnectTimer);
		KConfig *config = KGlobal::config();
		config->setGroup( "Profile_" + profiles[i] );
		handle = config->readEntry( "name" , QString::null );
		password = config->readEntry( "password" , QString::null );
		publicName = config->readEntry( "publicname" , QString::null );

		if ( handle == QString::null || password == QString::null )
		{
			kdDebug() << "Some empty things in profile: " << profiles[i] << endl;
			slotSettings();
			return;
		}
		fileDisconnector->setIcon("connect_creating");
		fileDisconnector->setText(i18n("Cancel"));
		slotStatusMsg(i18n("Connecting to MSN as:")+ " " +handle);
		imService->setMyContactInfo(handle, password);
		imService->setSilent(_silent);
		_workTimer = startTimer(60000);
		emit connectToService();
		fileConnector->setEnabled( false );
		fileDisconnector->setEnabled( true );
		//Keep track of the current profile, in order to change public name settings without reconnecting
		curProfile = i;
		curProfileName = profiles[i];
	}
}

/** No descriptions */
void KMsnApp::slotViewToolBar()
{
	slotStatusMsg(i18n("Toggling toolbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if(!viewToolBar->isChecked())
	{
		toolBar("mainToolBar")->hide();
	}
	else
	{
		toolBar("mainToolBar")->show();
	}
	slotStatusMsg(i18n("Ready."));
}

/** toggle the statusbar */
void KMsnApp::slotViewStatusBar()
{
	slotStatusMsg(i18n("Toggle the statusbar..."));
	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off
	if(!viewStatusBar->isChecked())
	{
		statusBar()->hide();
	}
	else
	{
		statusBar()->show();
	}
	slotStatusMsg(i18n("Ready."));
}

/** disconnect or cancel from MSN service */
void KMsnApp::slotDisconnector()
{
	_autoConnect = false; // user has clicked disconnect, disable autoconnect;
	if(fileDisconnector->text() == i18n("Cancel"))
	{
		fileDisconnector->setIcon("connect_no");
		fileDisconnector->setText(i18n("&Disconnect"));
		fileDisconnector->setEnabled( false );
		fileConnector->setEnabled( true );
		connected = false;
		slotStatusMsg(i18n("Disconnecting from MSN"));
		if(_workTimer != 0L)
		{
			killTimer(_workTimer);
			_workTimer = 0L;
		}
		imService->cancelConnect();
		return;
	}
	else
	{ // connected close connection
		fileDisconnector->setIcon("connect_creating");
		fileDisconnector->setText(i18n("Disconnect"));
		slotStatusMsg(i18n("Disconnecting from MSN"));
		if(_workTimer != 0L)
			killTimer(_workTimer);
		_workTimer = startTimer(30000);
		imService->disconnect();
	}
}


/** No descriptions */
void KMsnApp::slotHide()
{
	if(fileAddToPanel->isChecked())
	{
		hide();
	}
	else
	{
		systemTrayWidget->show();
		fileAddToPanel->setChecked(true);
		hide();
	}
}
/** change the status */
void KMsnApp::slotChangeStatus(int i)
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = startTimer(30000);
	if(fileStatus->popupMenu()->text(i) == i18n("Online"))
	{
		imService->changeStatus(NLN);
	}
	if(fileStatus->popupMenu()->text(i) == i18n("Busy"))
	{
		imService->changeStatus(BSY);
	}
	if(fileStatus->popupMenu()->text(i) == i18n("Be right back"))
	{
		imService->changeStatus(BRB);
	}
	if(fileStatus->popupMenu()->text(i) == i18n("Away from Computer"))
	{
		imService->changeStatus(AWY);
	}
	if(fileStatus->popupMenu()->text(i) == i18n("On the phone"))
	{
		imService->changeStatus(PHN);
	}
	if(fileStatus->popupMenu()->text(i) == i18n("Out to lunch"))
	{
		imService->changeStatus(LUN);
	}
	if(fileStatus->popupMenu()->text(i) == i18n("Invisible"))
	{
		imService->changeStatus(HDN);
	}
}

/** No descriptions */
void KMsnApp::readProperties(KConfig* _cfg)
{}

/** No descriptions */
void KMsnApp::saveProperties(KConfig* _cfg)
{}

/** No descriptions */
void KMsnApp::readOptions()
{
	KConfig *config = KGlobal::config();
	
	config->setGroup("General");
	KToolBar *aToolBar = toolBar();
	aToolBar->applySettings( config, "MainWindowToolbar" );
	bool toolbarHidden = config->readBoolEntry( "Hidden" );
	viewToolBar->setChecked( !toolbarHidden );
	KToolBar::BarPosition toolBarPos;
	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("MainWindowToolbarPos", KToolBar::Top);
	toolBar("MainWindowToolbar")->setBarPos(toolBarPos);

	visible = config->readBoolEntry("Visible",true);
	QSize size          = config->readSizeEntry("Geometry");
	enableIdleDetection = config->readBoolEntry("Idle Detection",false);
	maxIdle             = config->readNumEntry("MaxIdle",15);
	notificationTimeout = config->readNumEntry("Notification Timeout",10);
	enableAlert         = config->readBoolEntry("Enable Alert",true);
	if(config->readBoolEntry("Add To Panel",false))
	{
		fileAddToPanel->setChecked(true);
		slotAddToPanel();
	}
	else
	{
		visible = true;
	}
	
	//imService->enableBlockedUsers  = config->readBoolEntry("Blocked Activity",true); // show blocked users in onlinelist
	if (config->readBoolEntry("Hide Email",false))
	{
		viewEmailCheck->setChecked(true);
		viewWidget->slotHideEmail(true);
	}

	if(!size.isEmpty())
	{
		resize(size);
	}
	QPoint pos=config->readPointEntry("Position");
	if(!pos.isNull())
	{
		move(pos);
	}
	// read the last profile for auto connect
	curProfile = config->readNumEntry("Current Profile",0);
	//NIELX: Profiles ...
	config->setGroup("Profiles");
	profiles = config->readListEntry( "Profiles" );
	QString defaultStr = config->readEntry( "DefaultUser", i18n("No auto login") );
	if(defaultStr == i18n("No auto login") )
	{
		autoConnect = false;
	}
	else
	{
		autoConnect = true;
	}
	defaultUser=-1;

	if ( profiles.count() == 0 )
		slotSettings();
	else
	{
		//Construct menu...
		for ( int i = 0 ; i < profiles.count() ; i++ )
		{
			KAction *tmpaction = new KMsnAction( profiles[i] , //Name
                                        0           , //Accel
                                        this        , //Receiver
                                        SLOT(slotConnector( int ) ),
                                        actionCollection(),//Parent (not sure...)
                                        profiles[i] , //Internal name
                                        i );          //ID, needed for connecting
			//Add actions to the submenu
			fileConnector->insert( tmpaction );
			//And add them to our list...
			actions.append( tmpaction );
			//.. and make sure that they're deleted when we delete them
			actions.setAutoDelete( true );
			if (defaultStr == profiles[i])
				defaultUser=i;
		}
	}
}

/** No descriptions */
void KMsnApp::saveOptions()
{
	KConfig *config = KGlobal::config();
	config->setGroup("General");
	KToolBar *aToolBar = toolBar();
	aToolBar->saveSettings( config, "MainWindowToolbar" );
	config->writeEntry("MainWindowToolbarPos", (int) toolBar("MainWindowToolbar")->barPos());
	
	config->writeEntry("Geometry", size());
	config->writeEntry("Position", pos());
	// save the current profile nr.
	config->writeEntry("Current Profile",curProfile);
	config->writeEntry("Visible",visible);
	config->writeEntry("Hide Email",viewEmailCheck->isChecked());
	config->writeEntry("Add To Panel",fileAddToPanel->isChecked());
}

/** No descriptions */
void KMsnApp::slotStatusMsg(const QString &text)
{
	///////////////////////////////////////////////////////////////////
	// change status message permanently
	statusBar()->clear();
	statusBar()->changeItem(text,ID_STATUS_MSG);
}


/** No descriptions */
void KMsnApp::slotSettings()
{
	if( settings == NULL)
	{
		settings = new SettingsDialog(0,"Setting");
		settings->init(this);
		settings->show();
		connect(settings,SIGNAL(closed()),this,SLOT(slotSettingsDialogClosed()));
	}
	else
	{
		settings->show();
	}
}

/** No descriptions */
void KMsnApp::slotHideEmail()
{
	KConfig *config = KGlobal::config();
	config->setGroup("General");
	// show blocked users in onlinelist?
	viewWidget->slotHideEmail(viewEmailCheck->isChecked());
}

/** No descriptions */
void KMsnApp::slotSettingsDialogClosed()
{
	delete settings;
	settings = NULL;
	//Change settings
	KConfig *config = KGlobal::config();
	config->sync();
	config->setGroup("Profiles");
	profiles = config->readListEntry( "Profiles" );
	// TODO: New menu entry: Change Public Name
	// check if public name is changed - only when connected
	QString dummy;
	int i = curProfile;
	userSettings = true;
	//Delete the profiles currently in the menu
	int tmp;  // To store the number of profiles to delete
	tmp = actions.count();
	for( int i = 0 ; i < tmp ; i++ )
	{
		fileConnector->remove( actions.first() );
		actions.removeFirst();
	}
	for ( int i = 0 ; i < profiles.count() ; i++ )
	{
		KAction *tmpaction = new KMsnAction( profiles[i] , //Name
                                        0           , //Accel
                                        this        , //Receiver
                                        SLOT(slotConnector( int ) ),
                                        actionCollection(),//Parent (not sure...)
                                        profiles[i] , //Internal name
                                        i );          //ID, needed for connecting
		//Add actions to the submenu
		fileConnector->insert( tmpaction );
		//And add them to our list...
		actions.append( tmpaction );
	}
	// setting for idle timer
	config->setGroup("General");
	// show blocked users in onlinelist?
	//imService->enableBlockedUsers  = config->readBoolEntry("Blocked Activity",true);
	enableIdleDetection = config->readBoolEntry("Idle Detection",true);
	maxIdle             = config->readNumEntry("MaxIdle",15);
	enableAlert         = config->readBoolEntry("Enable Alert",true);
	notificationTimeout = config->readNumEntry("Notification Timeout",10);
	
	delete notifierWidget;
	notifierWidget = new SystemNotifier(notificationTimeout,0);
	notifierWidget->hide();
	if(connected)
	{
		idleTimer->setMaxIdle(maxIdle);
		if(enableIdleDetection)
		{
			idleTimer->startIdleDetection();
		}
		else
		{
			idleTimer->stopIdleDetection();
		}
	}
}

/** No descriptions */
void KMsnApp::slotOpenChatWindow(IMChatService *board,QString handle)
{
	if(widgetList.isEmpty())
	{
		ChatWindow *chatWindow = new ChatWindow();
		chatWindow->theApp = this;
		chatWindow->show();
		chatWindow->chatWith = handle;
		connect(chatWindow,SIGNAL(sendMsg(QString)),board,SLOT(slotSendMsg(QString)));
		connect(chatWindow,SIGNAL(closeSession()),board,SLOT(slotCloseSession()));
		connect(chatWindow,SIGNAL(inviteContact(QString)),board,SLOT(slotInviteContact(QString)));
		connect(chatWindow,SIGNAL(typingMsg()),board,SLOT(slotTypingMsg()));
		connect(chatWindow,SIGNAL(createSession(QString)),imService,SLOT(slotStartChatSession(QString)));
		connect(board,SIGNAL(msgReceived(QString,QString,QString)),chatWindow,SLOT(slotMsgReceived(QString,QString,QString)));
		connect(board,SIGNAL(userTypingMsg(QString)),chatWindow,SLOT(slotContactTyping(QString )));
		connect(board,SIGNAL(msgAcknowledgement(bool)),chatWindow,SLOT(slotMsgAcknowledgement(bool)));
		connect(board,SIGNAL(switchBoardIsActive(bool)),chatWindow,SLOT(slotSwitchBoardIsActive(bool)));
		connect(board,SIGNAL(updateChatMember(QString,QString,bool)),chatWindow,SLOT(slotUpdateChatMemberList(QString,QString,bool)));
		widgetList.append(chatWindow);
		return;
	}
	else
	{
		ChatWindow *chatWindow;
		for( chatWindow = widgetList.first(); chatWindow != 0; chatWindow = widgetList.next() )
			{
				if(chatWindow->chatWith == handle && chatWindow->chatMemberList.count() == 0)
				{
					chatWindow->theApp = this;
					chatWindow->show();
					chatWindow->disconnect();
					connect(chatWindow,SIGNAL(sendMsg(QString)),board,SLOT(slotSendMsg(QString)));
					connect(chatWindow,SIGNAL(closeSession()),board,SLOT(slotCloseSession()));
					connect(chatWindow,SIGNAL(inviteContact(QString)),board,SLOT(slotInviteContact(QString)));
					connect(chatWindow,SIGNAL(typingMsg()),board,SLOT(slotTypingMsg()));
					connect(chatWindow,SIGNAL(createSession(QString)),imService,SLOT(slotStartChatSession(QString)));
					connect(board,SIGNAL(msgReceived(QString,QString,QString)),chatWindow,SLOT(slotMsgReceived(QString,QString,QString)));
					connect(board,SIGNAL(userTypingMsg(QString)),chatWindow,SLOT(slotContactTyping(QString )));
					connect(board,SIGNAL(msgAcknowledgement(bool)),chatWindow,SLOT(slotMsgAcknowledgement(bool)));
					connect(board,SIGNAL(switchBoardIsActive(bool)),chatWindow,SLOT(slotSwitchBoardIsActive(bool)));
					connect(board,SIGNAL(updateChatMember(QString,QString,bool)),chatWindow,SLOT(slotUpdateChatMemberList(QString,QString,bool)));
					return;
				}
			}
	}
	ChatWindow *chatWindow = new ChatWindow();
	chatWindow->theApp = this;
	chatWindow->show();
	chatWindow->chatWith = handle;
	connect(chatWindow,SIGNAL(sendMsg(QString)),board,SLOT(slotSendMsg(QString)));
	connect(chatWindow,SIGNAL(closeSession()),board,SLOT(slotCloseSession()));
	connect(chatWindow,SIGNAL(inviteContact(QString)),board,SLOT(slotInviteContact(QString)));
	connect(chatWindow,SIGNAL(typingMsg()),board,SLOT(slotTypingMsg()));
	connect(chatWindow,SIGNAL(createSession(QString)),imService,SLOT(slotStartChatSession(QString)));
	connect(board,SIGNAL(msgReceived(QString,QString,QString)),chatWindow,SLOT(slotMsgReceived(QString,QString,QString)));
	connect(board,SIGNAL(userTypingMsg(QString)),chatWindow,SLOT(slotContactTyping(QString )));
	connect(board,SIGNAL(msgAcknowledgement(bool)),chatWindow,SLOT(slotMsgAcknowledgement(bool)));
	connect(board,SIGNAL(switchBoardIsActive(bool)),chatWindow,SLOT(slotSwitchBoardIsActive(bool)));
	connect(board,SIGNAL(updateChatMember(QString,QString,bool)),chatWindow,SLOT(slotUpdateChatMemberList(QString,QString,bool)));
	widgetList.append( chatWindow );
}

/** No descriptions */
void KMsnApp::slotConnectedToMsn(bool f)
{
	slotStatusMsg(i18n("Ready."));
	if(_workTimer != 0L)
	{
		killTimer(_workTimer);
		_workTimer = 0L;
	}
	if(_autoConnectTimer != 0L)
	{
		killTimer(_autoConnectTimer);
		_autoConnectTimer = 0L;
	}
	connected = f;
	slotUpdateMenu();
	if(f)
	{
		KNotifyClient::event("online","Connected");
		currentStatus = NLN;                         // current status is online
		contactAdd->setEnabled(true);                 // enable add contact
		fileStatus->popupMenu()->setEnabled(true); // enable status menu
		systemTrayWidget->setPixmap(systemTrayWidget->onlinePixmap);
		QToolTip::add(systemTrayWidget,i18n("<center>Connected to<br><b>MSN</b></center>"));
		// onlineview
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Online")+")");
		// menu and toolbar
		fileDisconnector->setIcon("connect_established");
		fileDisconnector->setText(i18n("Go Offline"));
		fileStatus->setEnabled(true);
		fileStatus->popupMenu()->setItemChecked(id_online,true);
		//imService->enableAutoConnect(true);	// enable auto connect
		// start the IdleTimer
		idleTimer->setMaxIdle(maxIdle);
		kdDebug() << "Idle detection enabled: " << enableIdleDetection << " Timer: " << maxIdle << endl;
		if(enableIdleDetection)
		{
			idleTimer->toggleOverAllIdleDetection(true);
			idleTimer->startIdleDetection(); // only start it its enabled
		}
	}
	else
	{
		KNotifyClient::event("offline","Disconnected");
		currentStatus = FLN; 	                        // current status is offline
		
		contactAdd->setEnabled(false);                 // disable add contact
		fileStatus->popupMenu()->setEnabled(false); // disable status menu
		
		//	systemtray
		systemTrayWidget->setPixmap(systemTrayWidget->offlinePixmap);
		QToolTip::add(systemTrayWidget,i18n("<center>Not connected with<br><b>MSN</b></center>"));
		// onlineView
		viewWidget->setOnlineLabelText(i18n("Offline"));
		viewWidget->setMailLabelText(i18n("You have no E-Mails"));
		// menu and toolbar
		fileDisconnector->setIcon("connect_no");
		fileDisconnector->setText(i18n("Go Offline"));
		fileDisconnector->setEnabled( false );
		fileConnector->setEnabled( true );
		fileStatus->setEnabled(false);
		
		contactChat->setEnabled(false);
		contactAdd->setEnabled(false);
		contactRemove->setEnabled(false);
		contactBlock->setEnabled(false);
		fileStatus->popupMenu()->setItemChecked(id_online,false);
		//stop the IdleTimer
		idleTimer->stopIdleDetection();
		kdDebug() << "Idle detection enabled: " << enableIdleDetection << " Timer: " << maxIdle << endl;
		groupAdd->setEnabled(false);
		groupRename->setEnabled(false);
		groupDelete->setEnabled(false);
		contactAdd->setEnabled(false);
		contactRemove->setEnabled(false);
		contactDelete->setEnabled(false);
		contactBlock->setEnabled(false);
		contactUnBlock->setEnabled(false);
		contactChat->setEnabled(false);
		contactCopy->setEnabled(false);
		contactMove->setEnabled(false);
		if(_autoConnect)
			_autoConnectTimer = startTimer(180000);

	}
}
/** No descriptions */
void KMsnApp::timerEvent(QTimerEvent *ev)
{
	if(ev->timerId() == _workTimer)
	{
		stopWorkTimer();
		imService->cancelConnect();
		kdDebug() << "Call cancelConnect()" << endl;
	}
	if(ev->timerId() == _autoConnectTimer)
	{
		if (autoConnect && defaultUser >= 0)
		{
			_silent = true;
			slotConnector(defaultUser);
			_silent = false;
		}
	}
}
/** No descriptions */
void KMsnApp::slotIncomingMail(QString addy,uint count)
{
  QString m_count;
  m_count = m_count.setNum(count);
  //	m_count = ("%1").arg(count);
  if(addy.isEmpty())
  {
    // only update online view
    if(count != 0)
    {
      viewWidget->setMailLabelText(i18n("You have new E-Mails")+"("+m_count+")");
    }
    else
    {
      viewWidget->setMailLabelText(i18n("You have no new E-Mails"));
    }
  }
  else
  {
    // new mail
    QToolTip::add(systemTrayWidget,i18n("You have a new E-Mail"));
    viewWidget->setMailLabelText(i18n("You have new E-Mails")+"("+m_count+")");
//    systemTrayWidget->setPixmap(systemTrayWidget->mailPixmap);
    if(enableAlert)
    {
    	notifierWidget->showMessage(0,i18n("You have a new E-Mail")+"<br>"+"<font size=-1>"+addy+"</font>");
    }
  }
}

/** idle detection */
void KMsnApp::slotToggleIdle(bool f)
{
	if(_workTimer != 0L)
	{
		killTimer(_workTimer);
		_workTimer = 0L;
	}
	if(f)
	{
		if(currentStatus == NLN)
		{
			// away from computer
			_workTimer = startTimer(50000);
			slotStatusMsg(i18n("System is idle, set status to Away!"));
			imService->changeStatus(IDL);
		}
	}
	else
	{
		if(currentStatus == IDL)
		{
			_workTimer = startTimer(50000);
			slotStatusMsg(i18n("Set status to Online!"));
			imService->changeStatus(NLN);
		}
	}
}

/** update all menus */
void KMsnApp::slotUpdateStatus(uint status)
{
	if(_workTimer != 0L)
	{
		killTimer(_workTimer);
		_workTimer = 0L;
	}
	fileStatus->popupMenu()->setItemChecked(id_online,false);
	fileStatus->popupMenu()->setItemChecked(id_back,false);
	fileStatus->popupMenu()->setItemChecked(id_away,false);
	fileStatus->popupMenu()->setItemChecked(id_busy,false);
	fileStatus->popupMenu()->setItemChecked(id_phone,false);
	fileStatus->popupMenu()->setItemChecked(id_lunch,false);
	fileStatus->popupMenu()->setItemChecked(id_invisible,false);
	slotStatusMsg(i18n("Ready."));
	if(status == NLN)
	{
		systemTrayWidget->setPixmap(systemTrayWidget->onlinePixmap);
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Online")+")");
		QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Online</b><center>"));
		currentStatus = NLN;
		fileStatus->popupMenu()->setItemChecked(id_online,true);
	}
	if(status == BSY)
	{
		systemTrayWidget->setPixmap(systemTrayWidget->awayPixmap);
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Busy")+")");
		QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Busy</b><center>"));
		currentStatus = BSY;
		fileStatus->popupMenu()->setItemChecked(id_busy,true);
	}
	if(status == AWY)
	{
			systemTrayWidget->setPixmap(systemTrayWidget->awayPixmap);
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Away from computer")+")");
			QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Away from computer</b><center>"));
			currentStatus = AWY;
			fileStatus->popupMenu()->setItemChecked(id_away,true);
	}
	if(status == BRB)
	{
		systemTrayWidget->setPixmap(systemTrayWidget->awayPixmap);
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Be right back")+")");
		QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Be right back</b><center>"));
		currentStatus = BRB;
		fileStatus->popupMenu()->setItemChecked(id_back,true);
	}
	if(status == PHN)
	{
		systemTrayWidget->setPixmap(systemTrayWidget->awayPixmap);
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("On the phone")+")");
		QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>On the phone</b><center>"));
		currentStatus = PHN;
		fileStatus->popupMenu()->setItemChecked(id_phone,true);
	}
	if(status == LUN)
	{
		systemTrayWidget->setPixmap(systemTrayWidget->awayPixmap);
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Out to lunch")+")");
		QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Out to lunch</b><center>"));
		currentStatus = LUN;
		fileStatus->popupMenu()->setItemChecked(id_lunch,true);
	}
	if(status == HDN)
	{
		systemTrayWidget->setPixmap(systemTrayWidget->invisiblePixmap);
		viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Invisible")+")");
		QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Invisible</b><center>"));
		currentStatus = HDN;
		fileStatus->popupMenu()->setItemChecked(id_invisible,true);
	}
	if(status == IDL)
	{
			systemTrayWidget->setPixmap(systemTrayWidget->awayPixmap);
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Away from computer")+")");
			QToolTip::add(systemTrayWidget,i18n("<center>Current status :<br><b>Away from computer</b><center>"));
			currentStatus = IDL;
			fileStatus->popupMenu()->setItemChecked(id_away,true);
	}
}
/** No descriptions */
void KMsnApp::slotShowNotifierWidget(QString handle,uint status)
{
	if(!enableAlert) return;
	QString publicName = imService->getPublicName( handle );
	switch(status)
	{
		case NLN:
		{
			notifierWidget->showMessage(1,"<b>"+publicName+i18n("<br>is<br>Online</b>"));
			KNotifyClient::event("buddy_online",publicName+" is online");
			break;
		}
		case FLN:
		{
			notifierWidget->showMessage(1,"<b>"+publicName+i18n("<br>is<br>Offline</b>"));
			KNotifyClient::event("buddy_offline",publicName+" is offline");
			break;
		}
	} // all other states are removed
}


/** public name has changed */
void KMsnApp::slotPublicNameChanged(QString _publicName)
{
	if(_workTimer != 0L)
	{
		killTimer(_workTimer);
		_workTimer = 0L;
	}
	publicName = _publicName;
//	slotStatusMsg(i18n("Ready."));
	switch(currentStatus)
	{
		case NLN:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Online")+")");
			break;
		}
		case BSY:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Busy")+")");
			break;
		}
		case AWY:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Away from computer")+")");
			break;
		}
		case BRB:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Be right back")+")");
			break;
		}
		case PHN:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("On the phone")+")");
			break;
		}
		case LUN:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Out to lunch")+")");
			break;
		}
		case HDN:
		{
			viewWidget->setOnlineLabelText(publicName+" "+"("+i18n("Invisible")+")");
			break;
		}
	}
}

void KMsnApp::slotChangePublicName(QString publicName)
{
	imService->setMyPublicName(publicName);
}

void KMsnApp::slotAuthenticate( QString handle )
{
	NewUserImpl *authDlg = new NewUserImpl(0);
	authDlg->setHandle(handle);
	connect( authDlg, SIGNAL(addUser( QString )), this, SLOT(slotAddContact( QString )));
	connect( authDlg, SIGNAL(blockUser( QString )), this, SLOT(slotBlockContact( QString )));
	authDlg->show();
}

void KMsnApp::slotAddContact( QString handle )
{
	imService->contactAdd( handle );
}

void KMsnApp::slotBlockContact( QString handle)
{
	imService->contactBlock( handle );
}

void KMsnApp::stopWorkTimer()
{
	if(_workTimer != 0L)
		killTimer(_workTimer);
	_workTimer = 0L;
}






#include "kmsnapp.moc"

