/***************************************************************************
                          imcontact.h  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Olaf Lueg
    email                : olueg@olsd.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef IMCONTACT_H
#define IMCONTACT_H

#include <qobject.h>
#include <qstringlist.h>

//#include "imservice.h"

/**
  *@author olaf
  */

class IMContact : public QObject  {
Q_OBJECT
public:
	IMContact();
	~IMContact();
protected:
	QString _handle;
	QString _publicName;
	QStringList groupList;
	bool _blocked;
	bool _allow;
	int _status;
	bool _deleted;
public:
	void setHandle(QString handle) { _handle = handle;}
	void setPublicName(QString publicName) { _publicName = publicName;}
	void setStatus(int status) { _status = status; }
	void setBlocked( bool f) { _blocked = f;}
	void addToGroup(QString group);
	void removeFromGroup(QString group);
	QStringList getGroupList() { return groupList; }
	
	QString getHandle() { return _handle;}
	QString getPublicName() { return _publicName;}
	int getStatus() { return _status;}
	
	bool isBlocked() { return _blocked;}
	bool isAllowed() { return _allow;}
	
	bool isInGroup(QString groupName );
	
	void setDeleted( bool f ){ _deleted = f;}
	
	
};

#endif
