/***************************************************************************
                           kcntiterator.h - 
                         ---------------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCNTITERATOR_H
#define KCNTITERATOR_H

#include <qlist.h>
#include "kcontainerimpl.h"
#include "kcontainer.h"

/**
 * @short Iterator for @ref KObject objects contained in @ref KContainer objects
 *
 * @author Sergio Moretti
 *
 * @version $Id: kcntiterator.h,v 1.2 2001/03/22 09:26:52 sergio Exp $
 */
class KCntIterator 
{
 public:
   KCntIterator(const KContainer &c) : _it(*c.impl()) {}
   uint count () const { return _it.count(); }
   bool isEmpty () const { return _it.isEmpty(); }
   bool atFirst () const { return _it.atFirst(); }
   bool atLast () const { return _it.atLast(); }
   KObject toFirst () { return KObject(_it.toFirst()); }
   KObject toLast () { return KObject(_it.toLast()); }
   KObject current () const { return KObject(_it.current()); }
   KObject operator ()() { return KObject(_it()); }
   KObject operator++ () { return KObject(++_it); }
   KObject operator+= ( uint jump ) { return KObject(_it+=jump); }
   KObject operator-- () { return KObject(--_it); }
   KObject operator-= ( uint jump ) { return KObject(_it-=jump); }
   KCntIterator & operator= ( const KCntIterator & it ) { return _it = it._it, *this; }
private:
   KContainerImpl::Iterator _it;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
