/***************************************************************************
                          filelistview.cpp  -  description
                             -------------------
    begin                : Sat Aug 12 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <stdlib.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qiconset.h>
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstddirs.h>
#include <kglobal.h>
#include <kurlpixmapprovider.h>
#include <kleandisk.h>
#include "abfileinfo.h"
#include "filelistview.h"
#include "dup.h"

#include <iostream.h>

FileListView::FileListView(QWidget *parent, const char *name) : QListView(parent,name){
	_groupViewWidget = (GroupViewWidget *)parent;
	this -> addColumn(i18n("Filename"),125);
 	this -> addColumn(i18n("Folder"),250);
 	this -> addColumn(i18n("Size"),65);
 	this -> addColumn(i18n("CRC"),40);
 	this -> setColumnWidth(3,0);
	this -> addColumn(i18n("Last read"),150);
	this -> setColumnAlignment(3,2);
	this -> setColumnAlignment(4,1);
	this -> setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	this -> setItemMargin(2);
	setAllColumnsShowFocus (true);
	init();
	fgroup = 0;
}

FileListView::~FileListView(){
}

void FileListView::init(){
	this -> clear();
	fgroup = 0;
}

void FileListView::setFileGroup(FileGroupBase * f){
//	SETWAIT;
	init();
	if (f -> numFiles() == 0)
		return;
	fgroup = f;
	emit fileSelectionChanged(f);
	QString s;
	for (unsigned int i = 0; i < fileGroup() -> numFiles() ; i++){
		QListViewItem * item = new QListViewItem(this);
		setupItem(item, i);
  }
  //SETARROW;
}

void FileListView::setupItem(QListViewItem * i, unsigned int n){
	if (fileName(i).isEmpty()){
		QString s;
		ABFileInfo fi(fileGroup() -> file(n));
		QDateTime dat(fi.lastRead());
		i -> setText(0,fi.fileName());
		i -> setText(1,fi.dirPath());
		i -> setText(2,s.setNum(fi.size()));
		if (fileGroup() -> type() == TYPE_DUP)
			i -> setText(3,s.setNum(((DUP*)fileGroup()) -> crc(n)));
		i -> setText(4," " + dat.toString());
	}
	if (fileGroup() -> fileMark(n)){
		if (isSafe(fileName(i)))
			i -> setPixmap(0,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/green_marked.xpm")));
		else
			i -> setPixmap(0,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/red_marked.xpm")));
	}
	else{
		if (isSafe(fileName(i)))
			i -> setPixmap(0,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/green.xpm")));
		else
			i -> setPixmap(0,QPixmap(KGlobal::dirs() -> findResource("data","kleandisk/pics/red.xpm")));
	}
}

void FileListView::viewportMousePressEvent(QMouseEvent *e){
	if (fileGroup() == 0)
		return;
	if (fileGroup() -> type() != TYPE_UDG && fileGroup() -> type() != TYPE_DUP ){
		KMessageBox::information(0,i18n("Files belonging to this File Group cannot be marked"));
		return;
	}
	QPoint point(e -> pos());
	if (e -> x() <= 12){
		unsigned int n = 1;
		if (e -> button() == MidButton)
			n = 5;
		if (e -> button() == RightButton)
			n = 10;
		for (unsigned int t = 0; t < n; t++){
			QListViewItem * i = itemAt(point);
			if (i != 0){
				int j = fileGroup() -> file(fileName(i));
				fileGroup() -> setFileMark(j,!fileGroup() -> fileMark(j));
				setupItem(i,j);
				point.setY(point.y() + i -> height());
			}
		}
	}
	else{
		if (e -> button() == LeftButton){
			QListViewItem * i = itemAt(point);
			setSelected(i,true);
		}
	}
	emit fileSelectionChanged(fileGroup());
}


void FileListView::markAll(){
	SETWAIT;
	if (fileGroup()){
		QListViewItem * item = firstChild();
		while (item != 0L){
			QString s(fileName(item));
			unsigned int i = fileGroup() -> file(s);
			if (isSafe(s)){
				fileGroup() -> setFileMark(i, true);
				setupItem(item,i);
			}
			else{
				fileGroup() -> setFileMark(i, false);
				setupItem(item,i);
			}
			item = item -> itemBelow();
		}
	}
	SETARROW;
	emit fileSelectionChanged(fileGroup());
}

void FileListView::deMarkAll(){
	SETWAIT;
	if (fileGroup()){
		QListViewItem * item = firstChild();
		while (item != 0L){
			unsigned int i = fileGroup() -> file(fileName(item));
			fileGroup() -> setFileMark(i, false);
			setupItem(item,i);
			item = item -> itemBelow();
		}
	}
	SETARROW;
	emit fileSelectionChanged(fileGroup());
}

bool FileListView::isSafe(QString s){
	bool b;
	QDateTime current_date_time = QDateTime::currentDateTime();
	QFileInfo fi(s);
	QDateTime dat(fi.lastRead());
	unsigned int t = dat.secsTo(current_date_time)/(86400);
	if (t < fileGroup() -> safetyLevel())
		b = false;
	else
		b = true;
	return b;
}

QString FileListView::fileName(QListViewItem * i){
	QString s = i -> text(1);
	s = s + "/" + i -> text(0);
	if (s == QString("/"))
		s = "";
	return s;
}

