/***************************************************************************
                          batch.cpp  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "batch.h"
#include <qdatetime.h>
#include <iostream.h>

Batch::Batch(){
	procList = new QList<ABProcess>;
	procList -> setAutoDelete(true);
	cntr = 0;	
}

Batch::~Batch(){
	delete procList;
}

void Batch::clear(){
	procList -> clear();
	cntr = 0;
}

void Batch::append(ABProcess * p){
	procList -> append(p);
}

void Batch::start(bool b, bool c){
	cout << "batch: " << cntr << "\n";
	block = b;
	cont = c;
	if (!block){
		process(cntr) -> exec();
	  connect(process(cntr), SIGNAL(processExited(KProcess *)),SLOT(slotCont()));
	}
	else{
		process(cntr) -> exec(true);
		slotCont();
	}	
}

void Batch::slotCont(){
	emit processExited();
	if (process(cntr) -> error()){
		if (!cont)
			cntr = procList -> count();// batch doesn't continue after error in previous process
	}
	cntr++;
	if (cntr < count())
		start(block,cont);
	else{
		emit exit();
//   	cntr = 0;	
	}
}

bool Batch::error(){
	bool b = false;
	for (uint i = 0; i < count(); i++)
		if (process(i) -> error())
			b = true;
	return b;
}

