
#ifndef __THREADS_NATIVE__
#define __THREADS_NATIVE__

#include "jni.h"
#include "thread.h"

#ifdef NATIVE_THREADS

struct native_thread_lock {

  tOBREF object; //The object which is locked
  struct native_thread_lock* next;

  pthread_t thread_id;   //The id of the thread that acquired the lock
  pthread_mutex_t mutex; //The lock
  pthread_cond_t cond; //The condition object

  int iHasCondition; 
};

typedef struct native_thread_lock tThreadLock;

int THREAD_WaitForNativeThreads();
tThreadNode* THREAD_FindThread();
tThreadNode* THREAD_FindThreadByID(int id);
tThreadNode* THREAD_FindThreadByObject(tOBREF pstObject);

#ifndef GARBAGE2
int THREAD_StopAllThreads();
int THREAD_WakeAllThreads();
#endif

int THREAD_free_lock(  tOBREF pstObject);
int THREAD_FreeLocks();

#endif
int THREAD_addThreadToList(tStackFrame* pstFrame, void* thread_id, tOBREF obj, void* stackBottom);
jobject java_lang_Thread_nativeCurrentThread(JNIEnv* env, jclass thisclass);
int THREAD_GetNumberThreads();
void THREAD_InitMainThread
(
  tOBREF       hThread,  /* @parm Thread to initialise */
  int          iPriority,  /* @parm Priority to set thread to */
  tStackFrame* pstFrame,    /* @parm Environment frame to give to thread */
  tJNIData* pstJNIData, /* A JNIData structure that has been created by __createJNIData */
  void* stackBottom /* An optional argument indicating where the start of the C stack is */
);
#endif
