#ifdef USE_NETWORK_CLASSLOADER

char IPADDR[256];

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>



int NETWORK_CLASSLOADER_LoadAndLink(char* pszClassName, char* pszServerName, void** classData)
{
	int	so;
	int 	namelen, retval, msg_len;
	struct  sockaddr_in addr;
	char    message[256];
	
	int class_size;
	
	if ((so = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		perror("socket");
		return;
	}

	/* fill in the sin_addr structure */
	memset(&addr, 0, namelen = sizeof(addr));
	addr.sin_addr.s_addr = inet_addr(pszServerName); //host);
	addr.sin_family = AF_INET;
	addr.sin_port = htons(80); //Web server

	if ((-1 == connect(so, (struct sockaddr *)&addr, sizeof(addr)))) 
	{
		perror("connect");
		fprintf(stderr, "Could not connect to server %s on port 80\n", pszServerName);
		return;
	}

	sprintf(message, "GET /jewel/kissme-0.01/src/minclass/%s.class\n", pszClassName);
	retval = write(so, message, msg_len = strlen(message));
	if (retval < 0) {
		perror("write");
		return;
	} else {
	    //printf("write %d out of %d bytes\n", retval, msg_len);
	}

	//Read the size of the class
	class_size = 0;
	while(retval > 0)
	    {
		char b;

		retval = read(so, &b, 1);
		if(retval > 0)
		    class_size += retval;
		//		printf("%x.", (int) b);
	    }

	//	printf("class size is %x %i \n",class_size, class_size); 
	//	read(so, &class_size, sizeof(class_size));

	*classData = malloc(class_size);
	 if(*classData == NULL)
	     {
	     fprintf(stderr, "Error doing malloc in network_classloader %i\n", class_size);
	     return -1; //failure
	     }
	else
	    {
		int i = 0;
		retval = 1;

	if ((-1 == close(so))) 
		perror("close");

	if ((so = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		perror("socket");
		return;
	}

	/* fill in the sin_addr structure */
	memset(&addr, 0, namelen = sizeof(addr));
	addr.sin_addr.s_addr = inet_addr("1.0.0.2"); //host);
	addr.sin_family = AF_INET;
	addr.sin_port = htons(80); //Web server

	if ((-1 == connect(so, (struct sockaddr *)&addr, sizeof(addr)))) 
	{
		perror("connect");
		return;
	}

	retval = write(so, message, msg_len = strlen(message));

	//	printf("Wrote message");
		while(retval > 0)
		{
		 retval = read(so, ((char*) *classData + (i++)), 1);
		}
	    }

	if ((-1 == close(so))) 
		perror("close");

	return 0; //success
}


int NETWORK_CLASSLOADER_CanFindClass(char* pszClassName, char* pszServerName)
{
	int	so;
	int 	namelen, retval, msg_len;
	struct  sockaddr_in addr;
	char    message[256];
	
	int class_size;
	
	if ((so = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		perror("socket");
		return;
	}

	/* fill in the sin_addr structure */
	memset(&addr, 0, namelen = sizeof(addr));
	addr.sin_addr.s_addr = inet_addr(pszServerName); //host);
	addr.sin_family = AF_INET;
	addr.sin_port = htons(80); //Web server

	if ((-1 == connect(so, (struct sockaddr *)&addr, sizeof(addr)))) 
	{
		perror("connect");
		fprintf(stderr, "Could not connect to server %s on port 80\n", pszServerName);
		return;
	}

	sprintf(message, "GET /jewel/kissme-0.01/src/minclass/%s.class\n", pszClassName);
	retval = write(so, message, msg_len = strlen(message));
	if (retval < 0) {
		perror("write");
		return;
	} else {
	    //printf("write %d out of %d bytes\n", retval, msg_len);
	}

	
	//Read the reply
	class_size = 0;
	{
	    int first;

	    int comp1;

	    retval = read(so, &first, sizeof(first));

	    comp1 = 0xcafebabe;

	if ((-1 == close(so))) 
		perror("close");

	    if(first == comp1)
		{
		    return 0; //true
		}
	    else
		{
		    fprintf("network CANFINDCLASS return false for %s ---------------\n", pszClassName);
		return -1; //false
		}
	}

	return 0; //success
}


#endif
