#include <config.h>

#ifdef ALLOCATOR

#include "../public_methods.h"

#include "../../thread.h"
#include "garbage_defs.h"
#include "../bitfield.h"
#include "mark.h"

#include "classfile_methods.h"
#ifndef TEASEME
#include <stdio.h>
#include <assert.h>
#endif

#define HEAPBOUND(x) ( (((int32*) x) >= heap->pi32YoungHeap) && (((int32*) x) < (heap->pi32OldHeap + heap->i32OldHeapSize)))

int ALLOCATOR_MARK_MarkThreadStacks(tAllocatorHeap* heap)
{
    //First we iterate over each thread
    tThreadNode* iter = THREAD_lockAndGetThreadList();

    while(iter != NULL)
	{
	    //Now for each thread we iterate through all the initial stack frames
	    int numFrames = iter->pstInitialFrames->count;
	    int i;

	    if(iter->isTerminated == 0)
	      {
	    assert(iter->stackBottom >= iter->stackTop);
	    for(i = 0; i < numFrames;i++)
	      {
		tStackFrame* currStackFrame = LLIST_ElementAt(iter->pstInitialFrames, i);

		//And for that stack frame we mark it and its children
				 while( currStackFrame != NULL)
				   {
				     //And for each frame we must examine the current object
						      if (currStackFrame->pstCurrObject)
							ALLOCATOR_MARK_RecursivelyMark(heap, (tOBREF) currStackFrame->pstCurrObject, 0, GARBAGE_REACHABLE, (tOBREF) currStackFrame);
				     
				     if( currStackFrame->bIsNativeFrame == 0)
				       {		     
					 //And the java operand stack
					   {
					     int i;
					     if(currStackFrame->pstCurrMethod)
					       for (i = 0; i < currStackFrame->pstCurrMethod->pstCode->u16MaxStack + 1; i++)
						 {
						   if (ALLOCATOR_ISHANDLE(heap, (tOBREF) currStackFrame->pi32OpBot[i]))
						     {
						       ALLOCATOR_MARK_RecursivelyMark(heap, (tOBREF) currStackFrame->pi32OpBot[i], 1, GARBAGE_REACHABLE, (tOBREF) currStackFrame->pi32OpBot[i]);
						     }
						 }
					   }
					 
					 //And the local variables
					   {
					     int i32NumLocals;
					     int i;
					     if((currStackFrame->pstCurrMethod) && (currStackFrame->pi32Vars))
					       {
						 i32NumLocals = currStackFrame->pstCurrMethod->u16ArgSize + currStackFrame->pstCurrMethod->pstCode->u16MaxLocals;
						 for (i = 0; i < i32NumLocals; i++)
						   {
						     if (ALLOCATOR_ISHANDLE(heap, (tOBREF) currStackFrame->pi32Vars[i]))
						       {
							 ALLOCATOR_MARK_RecursivelyMark(heap, (tOBREF) currStackFrame->pi32Vars[i], 0, GARBAGE_REACHABLE, (tOBREF) currStackFrame->pi32Vars[i]);
						       }
						   }
					       }
					   }
				       }
				     currStackFrame = currStackFrame->pstChildFrame; //pstPrevFrame;
				   }
		
	      }
	      }
	    iter = iter->next;
	}
  THREAD_unlockThreadList();
  return 0;
}

int ALLOCATOR_MARK_MarkCStacks(tAllocatorHeap* heap)
{
    //First we iterate over each thread
    tThreadNode* iter = THREAD_lockAndGetThreadList();
//    tThreadNode* iter = pstThreadList;
    while(iter != NULL)
	{
	    int32* pi32TempPtr;

	    #ifdef GARBAGE_VERBOSE
	    fprintf(stderr, "Stack bottom is %x\n", (int) iter->stackBottom);
	    #endif

	    for (pi32TempPtr = iter->stackBottom ; pi32TempPtr > (int32*)    (iter->stackTop); pi32TempPtr--) //was 0x800
		{
		     if (ALLOCATOR_ISHANDLE(heap, (tOBREF) *pi32TempPtr))
			 {
			   ALLOCATOR_MARK_RecursivelyMark(heap, (tOBREF) *pi32TempPtr, 1, GARBAGE_REACHABLE, (tOBREF) (*pi32TempPtr));
			 }
		     else
		       {
			 if (HEAPBOUND(*pi32TempPtr))
			   {
			     /* if the field points into the heap but its contents don't
				then it might be a direct pointer into the heap */
			     #ifdef GARBAGE_VERBOSE
				eprintf("Found direct pointer on C stack (thread %i) %p %p (%s)\n", (int) iter->thread_id, pi32TempPtr, (void*) *pi32TempPtr, "none"); //((tObject*) *pi32TempPtr)->pstType->uidName);
			    #endif
							
							//       printf("%s\n",((tObject*) **( (tOBREF*) (pi32TempPtr)))->pstType->uidName);
			     //       assert(2==3);
			     //       exit(1);
			   }
		       }
		}
	    
	    iter = iter->next;
	}  
THREAD_unlockThreadList();
  return 0;
}

/*
 * @doc FUNC
 * @func
 * This function is used to mark items that are reachable. If the item that
 * is specified is an object then this function calls itself on its fields if
 * they are objects or arrays. If the specified item is an array of arrays or
 * an array of objects then it calls itself on each of the arrays or objects
 * in that array. If iBFCheck is 1 then a bitfield check is performed to see
 * if the item points to the beginning of an object if it points into the
 * heap (used when checking the C stack and Java stack).
 *
 * Returns 0 if no errors occurred
 */

int ALLOCATOR_MARK_RecursivelyMark(tAllocatorHeap* heap, tOBREF o, int iBFCheck, int32 i32Flag, tOBREF parentRef)
{
  tClassLoaderTuple*     pstTempClass;
  int32       i;
  int32       i32StartOffset;

  /* check if current value is a pointer into one of the heap sections */
  if( ALLOCATOR_ISHANDLE(heap, o ))
    {
          i32StartOffset = ((int32*) *o) - heap->pi32OldHeap;

          /* check the bitfield to see if it's really the start of an object */
	  if(!( IS_OLD_BIT_SET( i32StartOffset ) ))
	    {
	      /* return if there is no bit set in the bitfield for this address */
	      //eprintf("No bit set for ref %p->%p\n", o, *o);
	      return 0;
	    }
	  #ifdef DEBUG_OBJECT_FOR_GC
	      assert(ODEREF(o)->magic1 == OMAGIC1);
	      assert(ODEREF(o)->magic2 == OMAGIC2);
	  #endif
	  /* check to see if item has already been marked... return if so */
	  if (PDEREF(o)->i32Flags & i32Flag)
	    {
	      /* ignore it and return */
	      return 0;
	    }
	  else
	    {
	      /* mark it with relevant flag */
	      PDEREF(o)->i32Flags |= i32Flag;
	      //eprintf("Marked object at %p->%p (type %s) (parent %p)\n", o, *o, ODEREF(o)->pstType->uidName, parentRef);
	    }
	  
	  /* if it's an object then mark all its members if appropriate */
	  if ((PDEREF(o)->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
	    {
	      /* don't do static fields here - they get done separately */
	      
	      /* go through instance fields */
	      pstTempClass = PDEREF(o)->pstType;

	      while (pstTempClass)
		{
		  for (i = 0; i < pstTempClass->pstClass->u16InstCount; i++)
		    {
		      /* if signature says this is an object or array, mark it */
		      if ((pstTempClass->pstClass->pstInstOffsets[i].uidFieldSig[0] == '[') ||
			  (pstTempClass->pstClass->pstInstOffsets[i].uidFieldSig[0] == 'L'))
			{
			  tOBREF childRef =(tOBREF)  PDEREF(o)->pi32Vars[pstTempClass->pstClass->pstInstOffsets[i].u16Offset];
			  if (ALLOCATOR_ISHANDLE(heap, (tOBREF) childRef))
			    {
			      if((PDEREF(childRef)->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_OBJECT)
				{
#ifdef DEBUG_OBJECT_FOR_GC
				  assert(ODEREF(childRef)->magic1 == OMAGIC1);
				  assert(ODEREF(childRef)->magic2 == OMAGIC2);
#endif
				}
			      else
				{
#ifdef DEBUG_OBJECT_FOR_GC
				  assert(ADEREF(childRef)->magic1 == OMAGIC1);
				  assert(ADEREF(childRef)->magic2 == OMAGIC2);
#endif
				}
			      ALLOCATOR_MARK_RecursivelyMark(heap, childRef, 0, i32Flag, o);
			    }
			}
		    }
		  pstTempClass = pstTempClass->pstClass->pstSuperClass;
		}
	    }
	  /* if it's an array of arrays or of objects then mark them too */
	  else if ((PDEREF(o)->i32Flags & GARBAGE_TYPEMASK) == GARBAGE_ARRAY)
	    {
	      tARREF a = (tARREF) o;
	      if ((PDEREF(a)->enType == T_ARRAY) ||
		  (PDEREF(a)->enType == T_OBJECT))
		{
		  for (i = 0; i < PDEREF(a)->i32Number; i++)
		    {
		      tOBREF ref =  ((tOBREF*) PDEREF(a)->pvElements)[i];
		      if(ref)
			{
			  if (HEAPBOUND((int32*) *ref))
			    {
			      ALLOCATOR_MARK_RecursivelyMark(heap, ((tOBREF*) PDEREF(a)->pvElements)[i], 0, i32Flag, (tOBREF) a);
			    }
			}
		    }
		}
	    }
    }
  else
    {
      //This handle isn't in the heap
	assert( 1 == 2);
    }

return 0;
}




#endif
