/* General packet used to transmit info between layers*/
import java.io.*;

class Packet
{
  final public int HEADER_LEN=0;	// Offset of the data area.
   
  int   protocol;     			// The protocol.
  byte[] data;				// Raw packet data.
  Packet wrapper;			// The lower-level packet wrapper.
  
  Packet()
  {
    data=null;
    protocol=-1;
  }
  
  /*
   *  Used to "unpack" packets for higher protocol.
   */
  
  Packet unpack(int offset)
  {
     Packet p=new Packet();
     p.data=new byte[data.length-offset];
     System.arraycopy(data,offset,p.data,0,data.length-offset);
     p.protocol=protocol;  // Blatantly wrong.
     p.wrapper=this;
     return p;
  }

  Packet pack(int offset)
  {
     Packet p=new Packet();
     p.data=new byte[data.length+offset];
     System.arraycopy(data,0,p.data,offset,data.length);
     p.protocol=protocol;  // Blatantly wrong.
     p.wrapper=null;
     return p;
  }

  int checksum(int nr)
  { /*
     * Look at Stevens' Internetworking with TCP/IP Vol. 2
     */
    DataInputStream ds=new DataInputStream(new ByteArrayInputStream(data,0,nr));
    int sum=0;
    boolean theEnd=false;
    while (!theEnd)
    { 
      try { sum=sum+ds.readUnsignedShort();}
      catch (EOFException e) {theEnd=true;}
      catch (IOException e) {return -1;}
    }
    sum = (sum >> 16)+ (sum & 0xffff);
    sum += (sum >> 16); 
    return (~sum & 0xffff);
  }
};


